/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management;

import com.tangosol.coherence.management.internal.ClusterNameSupplier;
import com.tangosol.coherence.management.internal.MapProvider;
import com.tangosol.coherence.management.internal.resources.ManagementRootResource;
import com.tangosol.coherence.management.internal.resources.VersionsResource;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.management.MBeanServerProxy;
import com.tangosol.net.management.WrapperMBeanServerProxy;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;

public final class RestManagement {
    private RestManagement() {
    }

    public static void configure(ResourceConfig resourceConfig) {
        RestManagement.configure(resourceConfig, MBeanServerProxyFactory.DEFAULT, null);
    }

    public static void configure(ResourceConfig resourceConfig, MBeanServerProxyFactory factory) {
        RestManagement.configure(resourceConfig, factory, null);
    }

    public static void configure(ResourceConfig resourceConfig, Supplier<MBeanServer> factory) {
        RestManagement.configure(resourceConfig, RestManagement.createMBeanServerProxyFactory(factory), null);
    }

    public static void configure(ResourceConfig resourceConfig, Supplier<MBeanServer> factory, Supplier<Set<String>> supplierClusters) {
        RestManagement.configure(resourceConfig, RestManagement.createMBeanServerProxyFactory(factory), supplierClusters);
    }

    private static void configure(ResourceConfig resourceConfig, MBeanServerProxyFactory factory, Supplier<Set<String>> supplierClusters) {
        Objects.requireNonNull(resourceConfig);
        resourceConfig.register(MapProvider.class);
        resourceConfig.register((Object)new MBeanServerProxyBinder(Objects.requireNonNull(factory)));
        EncodingFilter.enableFor((ResourceConfig)resourceConfig, (Class[])new Class[]{GZipEncoder.class});
        if (supplierClusters == null) {
            resourceConfig.register(ManagementRootResource.class);
        } else {
            resourceConfig.register((Object)new ClusterNameSupplier.Binder(supplierClusters::get));
            resourceConfig.register(VersionsResource.class);
        }
    }

    private static MBeanServerProxyFactory createMBeanServerProxyFactory(Supplier<MBeanServer> supplier) {
        return () -> new WrapperMBeanServerProxy(Objects.requireNonNull(supplier));
    }

    private static class MBeanServerProxyBinder
    extends AbstractBinder {
        private final MBeanServerProxyFactory f_factory;

        private MBeanServerProxyBinder(MBeanServerProxyFactory factory) {
            this.f_factory = factory;
        }

        protected void configure() {
            this.bindFactory(new Supplier<MBeanServerProxy>(){

                @Override
                @RequestScoped
                public MBeanServerProxy get() {
                    return f_factory.get();
                }
            }).to(MBeanServerProxy.class);
        }
    }

    @FunctionalInterface
    public static interface MBeanServerProxyFactory {
        public static final MBeanServerProxyFactory DEFAULT = () -> CacheFactory.getCluster().getManagement().getMBeanServerProxy();

        public MBeanServerProxy get();
    }
}

