/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.management.internal.resources;

import com.tangosol.coherence.management.internal.EntityMBeanResponse;
import com.tangosol.coherence.management.internal.resources.AbstractManagementResource;
import com.tangosol.coherence.management.internal.resources.CacheMembersResource;
import com.tangosol.net.management.MBeanAccessor;
import com.tangosol.util.Filter;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class CacheResource
extends AbstractManagementResource {
    public CacheResource(AbstractManagementResource resource) {
        super(resource);
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="cacheName") String sCacheName, @QueryParam(value="role") String sRoleName, @QueryParam(value="collector") String sCollector) {
        Filter<String> filterAttributes = this.getAttributesFilter("name", this.getExcludeList(null));
        EntityMBeanResponse responseEntity = this.getResponseEntityForMbean(this.getQuery(sCacheName), this.getParentUri(), this.getCurrentUri(), filterAttributes, this.getLinksFilter(), "members");
        if (responseEntity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Map<String, Object> mapResponse = responseEntity.toJson();
        MBeanAccessor.QueryBuilder bldrQuery = this.createQueryBuilder().withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService());
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, this.getQuery(sCacheName), mapResponse);
        this.addAggregatedMetricsToResponseMap(sRoleName, sCollector, bldrQuery, mapResponse);
        return this.response(mapResponse);
    }

    @Path(value="members")
    public Object getMembersResource() {
        return new CacheMembersResource(this);
    }

    @Override
    protected EntityMBeanResponse getQueryResult(Map mapQuery, Map<String, String> mapArguments, URI uriParent) {
        String sCacheName = mapArguments.get("name");
        URI uriSelf = CacheResource.getSubUri(uriParent, sCacheName);
        Filter<String> filterAttributes = this.getAttributesFilter("name", this.getExcludeList(null));
        Filter<String> filterLinks = this.getLinksFilter(mapQuery);
        MBeanAccessor.QueryBuilder bldrQuery = this.getQuery(sCacheName);
        EntityMBeanResponse responseEntity = this.getResponseEntityForMbean(bldrQuery, uriParent, uriSelf, filterAttributes, filterLinks, "members");
        if (responseEntity != null) {
            Object oChildren;
            Map<String, Object> mapEntity = responseEntity.getEntity();
            MBeanAccessor.QueryBuilder bldrQueryStorage = this.createQueryBuilder().withBaseQuery(String.format(":type=StorageManager,cache=%s", sCacheName)).withService(this.getService());
            this.addAggregatedMetricsToResponseMap("*", null, bldrQuery, mapEntity);
            this.addAggregatedMetricsToResponseMap("*", null, bldrQueryStorage, mapEntity);
            Object v0 = oChildren = mapQuery == null ? null : mapQuery.get("children");
            if (oChildren != null && oChildren instanceof Map) {
                Map mapChildrenQuery = oChildren;
                this.addChildResourceQueryResult(new CacheMembersResource(this), "members", mapEntity, mapChildrenQuery, mapArguments, uriSelf);
            }
        }
        return responseEntity;
    }

    protected MBeanAccessor.QueryBuilder getQuery(String sCacheName) {
        return this.createQueryBuilder().withBaseQuery(":type=Cache,name=" + sCacheName).withService(this.getService());
    }
}

