/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonGenerator;
import com.oracle.coherence.io.json.genson.ext.jsr353.JSR353Bundle;
import com.oracle.coherence.io.json.genson.stream.JsonWriter;
import jakarta.json.JsonException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GensonJsonGeneratorFactory
implements JsonGeneratorFactory {
    private final boolean prettyPrint;
    private final boolean htmlSafe;
    private final boolean skipNull;

    public GensonJsonGeneratorFactory() {
        this.prettyPrint = false;
        this.htmlSafe = false;
        this.skipNull = false;
    }

    public GensonJsonGeneratorFactory(Map<String, ?> config) {
        this.prettyPrint = JSR353Bundle.toBoolean(config, "jakarta.json.stream.JsonGenerator.prettyPrinting");
        this.htmlSafe = JSR353Bundle.toBoolean(config, "GensonJsonGenerator.htmlSafe");
        this.skipNull = JSR353Bundle.toBoolean(config, "GensonJsonGenerator.skipNull");
    }

    public JsonGenerator createGenerator(Writer writer) {
        return new GensonJsonGenerator(new JsonWriter(writer, this.skipNull, this.htmlSafe, this.prettyPrint));
    }

    public JsonGenerator createGenerator(OutputStream out) {
        try {
            return new GensonJsonGenerator(new JsonWriter(new OutputStreamWriter(out, "UTF-8"), this.skipNull, this.htmlSafe, this.prettyPrint));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonException("Charset UTF-8 is not supported.", (Throwable)e);
        }
    }

    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        return new GensonJsonGenerator(new JsonWriter(new OutputStreamWriter(out), this.skipNull, this.htmlSafe, this.prettyPrint));
    }

    public Map<String, ?> getConfigInUse() {
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("jakarta.json.stream.JsonGenerator.prettyPrinting", this.prettyPrint);
        config.put("GensonJsonGenerator.htmlSafe", this.htmlSafe);
        config.put("GensonJsonGenerator.skipNull", this.skipNull);
        return config;
    }
}

