/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.Operations;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeUtil {
    private static final Map<Class<?>, Class<?>> _wrappedPrimitives = new HashMap();
    private static final Map<TypeAndRootClassKey, Type> _cache;
    private static final ThreadLocal<Map<Type, Type>> _circularExpandedType;

    public static final Class<?> wrap(Class<?> clazz) {
        Class<?> wrappedClass = _wrappedPrimitives.get(clazz);
        return wrappedClass == null ? clazz : wrappedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Type expandType(Type type, Type rootType) {
        if (type instanceof ExpandedType || type instanceof Class) {
            return type;
        }
        Map<Type, Type> circularTypes = _circularExpandedType.get();
        if (circularTypes == null) {
            circularTypes = new HashMap<Type, Type>();
            _circularExpandedType.set(circularTypes);
        }
        if (circularTypes.containsKey(type)) {
            return circularTypes.get(type);
        }
        try {
            circularTypes.put(type, TypeUtil.getRawClass(type));
            TypeAndRootClassKey key = new TypeAndRootClassKey(type, rootType);
            Object expandedType = _cache.get(key);
            if (expandedType == null) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)type;
                    Type[] args = pType.getActualTypeArguments();
                    int len = args.length;
                    Type[] expandedArgs = new Type[len];
                    for (int i = 0; i < len; ++i) {
                        expandedArgs[i] = TypeUtil.expandType(args[i], rootType);
                    }
                    expandedType = new ExpandedParameterizedType(pType, TypeUtil.getRawClass(rootType), expandedArgs);
                } else if (type instanceof TypeVariable) {
                    TypeVariable tvType = (TypeVariable)type;
                    if (rootType instanceof ParameterizedType) {
                        ParameterizedType rootPType = (ParameterizedType)rootType;
                        Type[] typeArgs = rootPType.getActualTypeArguments();
                        String typeName = tvType.getName();
                        int idx = 0;
                        for (TypeVariable<Class<?>> parameter : TypeUtil.genericDeclarationToClass(tvType.getGenericDeclaration()).getTypeParameters()) {
                            if (typeName.equals(parameter.getName())) {
                                expandedType = typeArgs[idx];
                                break;
                            }
                            ++idx;
                        }
                    } else {
                        expandedType = TypeUtil.resolveTypeVariable(tvType, TypeUtil.getRawClass(rootType));
                    }
                    if (type == expandedType) {
                        expandedType = TypeUtil.expandType(tvType.getBounds()[0], rootType);
                    }
                } else if (type instanceof GenericArrayType) {
                    GenericArrayType genArrType = (GenericArrayType)type;
                    Object cType = TypeUtil.expandType(genArrType.getGenericComponentType(), rootType);
                    if (genArrType.getGenericComponentType() == cType) {
                        cType = Object.class;
                    }
                    expandedType = new ExpandedGenericArrayType(genArrType, (Type)cType, TypeUtil.getRawClass(rootType));
                } else if (type instanceof WildcardType) {
                    WildcardType wType = (WildcardType)type;
                    Object object = expandedType = wType.getUpperBounds().length > 0 ? TypeUtil.expandType(wType.getUpperBounds()[0], rootType) : Object.class;
                }
                if (expandedType == null) {
                    throw new IllegalArgumentException("Type " + type + " not supported for expansion!");
                }
                _cache.put(key, (Type)expandedType);
            }
            Type type2 = expandedType;
            return type2;
        }
        finally {
            circularTypes.remove(type);
        }
    }

    public static final Type lookupGenericType(Class<?> ofClass, Class<?> inClass) {
        Class<?> superClass;
        if (ofClass == null || inClass == null || !ofClass.isAssignableFrom(inClass)) {
            return null;
        }
        if (ofClass.equals(inClass)) {
            return inClass;
        }
        if (ofClass.isInterface()) {
            Class<?>[] interfaces = inClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (ofClass.equals(interfaces[i])) {
                    return inClass.getGenericInterfaces()[i];
                }
                Type superType = TypeUtil.lookupGenericType(ofClass, interfaces[i]);
                if (superType == null) continue;
                return superType;
            }
        }
        if (ofClass.equals(superClass = inClass.getSuperclass())) {
            return inClass.getGenericSuperclass();
        }
        return TypeUtil.lookupGenericType(ofClass, inClass.getSuperclass());
    }

    public static final Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(TypeUtil.getRawClass(componentType), 0).getClass();
        }
        return TypeUtil.getRawClass(TypeUtil.expand(type, null));
    }

    public static final Type getCollectionType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return Object.class;
            }
        } else if (type instanceof ParameterizedType && Collection.class.isAssignableFrom(TypeUtil.getRawClass(type))) {
            return TypeUtil.typeOf(0, type);
        }
        throw new IllegalArgumentException("Could not extract parametrized type, are you sure it is a Collection or an Array?");
    }

    static final Type expand(Type type, Class<?> inClass) {
        Object expandedType = null;
        if (type instanceof TypeVariable) {
            TypeVariable tvType = (TypeVariable)type;
            if (inClass == null) {
                inClass = TypeUtil.genericDeclarationToClass(tvType.getGenericDeclaration());
            }
            if (type.equals(expandedType = TypeUtil.resolveTypeVariable(tvType, inClass))) {
                expandedType = tvType.getBounds()[0];
            }
        } else if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            expandedType = wType.getUpperBounds().length > 0 ? TypeUtil.expand(wType.getUpperBounds()[0], inClass) : Object.class;
        } else {
            return type;
        }
        return expandedType == null || type.equals(expandedType) ? Object.class : expandedType;
    }

    public static final Type resolveTypeVariable(TypeVariable<? extends GenericDeclaration> type, Class<?> inClass) {
        return TypeUtil.resolveTypeVariable(type, TypeUtil.genericDeclarationToClass(type.getGenericDeclaration()), inClass);
    }

    private static final Type resolveTypeVariable(TypeVariable<? extends GenericDeclaration> type, Class<?> declaringClass, Class<?> inClass) {
        if (inClass == null) {
            return null;
        }
        Class<?> superClass = null;
        Type resolvedType = null;
        Type genericSuperClass = null;
        if (!declaringClass.equals(inClass)) {
            if (declaringClass.isInterface()) {
                Class<?>[] interfaces = inClass.getInterfaces();
                for (int i = 0; i < interfaces.length && resolvedType == null; ++i) {
                    superClass = interfaces[i];
                    resolvedType = TypeUtil.resolveTypeVariable(type, declaringClass, superClass);
                    genericSuperClass = inClass.getGenericInterfaces()[i];
                }
            }
            if (resolvedType == null) {
                superClass = inClass.getSuperclass();
                resolvedType = TypeUtil.resolveTypeVariable(type, declaringClass, superClass);
                genericSuperClass = inClass.getGenericSuperclass();
            }
        } else {
            resolvedType = type;
            genericSuperClass = superClass = inClass;
        }
        if (resolvedType != null && resolvedType instanceof TypeVariable) {
            int positionInClass;
            type = resolvedType;
            TypeVariable<Class<?>>[] parameters = superClass.getTypeParameters();
            for (positionInClass = 0; positionInClass < parameters.length && !type.equals(parameters[positionInClass]); ++positionInClass) {
            }
            if (positionInClass < parameters.length && genericSuperClass instanceof ParameterizedType) {
                ParameterizedType pGenericType = (ParameterizedType)genericSuperClass;
                Type[] args = pGenericType.getActualTypeArguments();
                return positionInClass < args.length ? args[positionInClass] : null;
            }
        }
        return resolvedType;
    }

    public static final boolean match(Type type, Type oType, boolean strictMatch) {
        boolean match;
        if (type == null || oType == null) {
            return type == null && oType == null;
        }
        Class<?> clazz = TypeUtil.getRawClass(type);
        Class<?> oClazz = TypeUtil.getRawClass(oType);
        boolean bl = match = strictMatch ? oClazz.equals(clazz) : oClazz.isAssignableFrom(clazz);
        if (Object.class.equals(clazz)) {
            return match;
        }
        if (Object.class.equals(oClazz) && !strictMatch) {
            return match;
        }
        if (clazz.isArray() && !oClazz.isArray()) {
            return match;
        }
        Type[] types = TypeUtil.getTypes(type);
        Type[] oTypes = TypeUtil.getTypes(oType);
        match = match && (types.length == oTypes.length || types.length == 0);
        for (int i = 0; i < types.length && match; ++i) {
            match = TypeUtil.match(types[i], oTypes[i], strictMatch);
        }
        return match;
    }

    public static final Type typeOf(int parameterIdx, Type fromType) {
        ParameterizedType pType;
        Type[] ts;
        if (fromType instanceof Class) {
            Class tClass = (Class)fromType;
            TypeVariable<Class<T>>[] tvs = tClass.getTypeParameters();
            if (tvs.length > parameterIdx) {
                return TypeUtil.expandType(tvs[parameterIdx], fromType);
            }
        } else if (fromType instanceof ParameterizedType && (ts = (pType = (ParameterizedType)fromType).getActualTypeArguments()).length > parameterIdx) {
            return ts[parameterIdx];
        }
        throw new UnsupportedOperationException("Couldn't find parameter at " + parameterIdx + " from type " + fromType + " , you should first locate the parameterized type, expand it and then use typeOf.");
    }

    private static Class<?> genericDeclarationToClass(GenericDeclaration declaration) {
        if (declaration instanceof Class) {
            return (Class)declaration;
        }
        if (declaration instanceof Method) {
            return ((Method)declaration).getDeclaringClass();
        }
        if (declaration instanceof Constructor) {
            return ((Constructor)declaration).getDeclaringClass();
        }
        throw new UnsupportedOperationException();
    }

    private static final Type[] getTypes(Type type) {
        if (type instanceof Class) {
            Class tClass = (Class)type;
            if (tClass.isArray()) {
                return new Type[]{tClass.getComponentType()};
            }
            TypeVariable<Class<T>>[] tvs = ((Class)type).getTypeParameters();
            Type[] types = new Type[tvs.length];
            int i = 0;
            for (TypeVariable tv : tvs) {
                types[i++] = tv.getBounds()[0];
            }
            return types;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{((GenericArrayType)type).getGenericComponentType()};
        }
        if (type instanceof WildcardType) {
            return Operations.union(Type[].class, ((WildcardType)type).getUpperBounds(), ((WildcardType)type).getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray;
            TypeVariable tvType = (TypeVariable)type;
            Type resolvedType = TypeUtil.resolveTypeVariable(tvType, (Class)tvType.getGenericDeclaration());
            if (tvType.equals(resolvedType)) {
                typeArray = tvType.getBounds();
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = resolvedType;
            }
            return typeArray;
        }
        return new Type[0];
    }

    static {
        _wrappedPrimitives.put(Integer.TYPE, Integer.class);
        _wrappedPrimitives.put(Double.TYPE, Double.class);
        _wrappedPrimitives.put(Long.TYPE, Long.class);
        _wrappedPrimitives.put(Float.TYPE, Float.class);
        _wrappedPrimitives.put(Short.TYPE, Short.class);
        _wrappedPrimitives.put(Boolean.TYPE, Boolean.class);
        _wrappedPrimitives.put(Character.TYPE, Character.class);
        _wrappedPrimitives.put(Byte.TYPE, Byte.class);
        _wrappedPrimitives.put(Void.TYPE, Void.class);
        _cache = new ConcurrentHashMap<TypeAndRootClassKey, Type>(32);
        _circularExpandedType = new ThreadLocal();
    }

    private static abstract class ExpandedType<T extends Type> {
        protected final T originalType;
        protected final Class<?> rootClass;
        private final int _hash;

        private ExpandedType(T originalType, Class<?> rootClass) {
            if (originalType == null || rootClass == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.originalType = originalType;
            this.rootClass = rootClass;
            int prime = 31;
            int result = 1;
            this._hash = 31 * result + (originalType == null ? 0 : originalType.hashCode());
        }

        public T getOriginalType() {
            return this.originalType;
        }

        public Class<?> getRootClass() {
            return this.rootClass;
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpandedType other = (ExpandedType)obj;
            return !(this.originalType == null ? other.originalType != null : !this.originalType.equals(other.originalType));
        }
    }

    private static final class TypeAndRootClassKey {
        private final Type type;
        private final Type rootType;
        private int _hash;

        public TypeAndRootClassKey(Type type, Type rootType) {
            if (type == null || rootType == null) {
                throw new IllegalArgumentException("type and rootType must be not null!");
            }
            this.type = type;
            this.rootType = rootType;
            this._hash = 31 + rootType.hashCode();
            this._hash = 31 + type.hashCode();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeAndRootClassKey)) {
                return false;
            }
            TypeAndRootClassKey other = (TypeAndRootClassKey)obj;
            return this.rootType.equals(other.rootType) && this.type.equals(other.type);
        }
    }

    private static final class ExpandedParameterizedType
    extends ExpandedType<ParameterizedType>
    implements ParameterizedType {
        private final Type[] typeArgs;
        private final int _hash;

        public ExpandedParameterizedType(ParameterizedType originalType, Class<?> rootClass, Type[] typeArgs) {
            super(originalType, rootClass);
            if (typeArgs == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.typeArgs = typeArgs;
            int prime = 31;
            int result = super.hashCode();
            this._hash = 31 * result + Arrays.hashCode(typeArgs);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArgs;
        }

        @Override
        public Type getOwnerType() {
            return ((ParameterizedType)this.originalType).getOwnerType();
        }

        @Override
        public Type getRawType() {
            return ((ParameterizedType)this.originalType).getRawType();
        }

        @Override
        public int hashCode() {
            return this._hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpandedParameterizedType other = (ExpandedParameterizedType)obj;
            return Arrays.equals(this.typeArgs, other.typeArgs);
        }
    }

    private static final class ExpandedGenericArrayType
    extends ExpandedType<GenericArrayType>
    implements GenericArrayType {
        private final Type componentType;
        private final int _hash;

        public ExpandedGenericArrayType(GenericArrayType originalType, Type componentType, Class<?> rootClass) {
            super(originalType, rootClass);
            if (componentType == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.componentType = componentType;
            int prime = 31;
            int result = super.hashCode();
            this._hash = 31 * result + (componentType == null ? 0 : componentType.hashCode());
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        @Override
        public int hashCode() {
            return this._hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpandedGenericArrayType other = (ExpandedGenericArrayType)obj;
            return !(this.componentType == null ? other.componentType != null : !this.componentType.equals(other.componentType));
        }
    }
}

