/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.datetime;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import java.time.ZoneOffset;

class ZoneOffsetConverter
implements Converter<ZoneOffset> {
    ZoneOffsetConverter() {
    }

    @Override
    public void serialize(ZoneOffset object, ObjectWriter writer, Context ctx) {
        writer.beginObject().writeNumber("zoneOffset", object.getTotalSeconds()).endObject();
    }

    @Override
    public ZoneOffset deserialize(ObjectReader reader, Context ctx) {
        int totalSeconds = 0;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String name = reader.name();
            if (!"zoneOffset".equals(name)) continue;
            totalSeconds = reader.valueAsInt();
        }
        reader.endObject();
        return ZoneOffset.ofTotalSeconds(totalSeconds);
    }
}

