/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.reflect;

import com.oracle.coherence.io.json.genson.Trilean;
import com.oracle.coherence.io.json.genson.reflect.BeanMutatorAccessorResolver;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PropertyFilter
extends BeanMutatorAccessorResolver.PropertyBaseResolver {
    private final boolean exclude;
    private final String field;
    private final Class<?> declaringClass;
    private final Class<?> ofType;

    public PropertyFilter(boolean exclude, String field, Class<?> declaringClass, Class<?> ofType) {
        this.exclude = exclude;
        this.field = field;
        this.declaringClass = declaringClass;
        this.ofType = ofType;
    }

    @Override
    public Trilean isAccessor(Field field, Class<?> fromClass) {
        return this.filter(field.getName(), fromClass, field.getType(), this.exclude);
    }

    @Override
    public Trilean isMutator(Field field, Class<?> fromClass) {
        return this.filter(field.getName(), fromClass, field.getType(), this.exclude);
    }

    @Override
    public Trilean isAccessor(Method method, Class<?> fromClass) {
        String name = method.getName();
        if (name.startsWith("is") && name.length() > 2) {
            return this.filter(name.substring(2), method.getDeclaringClass(), method.getReturnType(), this.exclude);
        }
        if (name.length() > 3 && name.startsWith("get")) {
            return this.filter(name.substring(3), method.getDeclaringClass(), method.getReturnType(), this.exclude);
        }
        return Trilean.UNKNOWN;
    }

    @Override
    public Trilean isMutator(Method method, Class<?> fromClass) {
        String name = method.getName();
        if (name.length() > 3 && method.getParameterTypes().length == 1 && name.startsWith("set")) {
            return this.filter(name.substring(3), method.getDeclaringClass(), method.getParameterTypes()[0], this.exclude);
        }
        return Trilean.UNKNOWN;
    }

    private Trilean filter(String actualName, Class<?> fromClass, Class<?> propertyType, boolean exclude) {
        if (!(this.field != null && !actualName.equalsIgnoreCase(this.field) || this.declaringClass != null && !this.declaringClass.isAssignableFrom(fromClass) || this.ofType != null && !this.ofType.isAssignableFrom(TypeUtil.wrap(propertyType)))) {
            return exclude ? Trilean.FALSE : Trilean.TRUE;
        }
        return Trilean.UNKNOWN;
    }
}

