/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.ext.jsr353;

import com.oracle.coherence.io.json.genson.ext.jsr353.GensonJsonGeneratorFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;

public class GensonJsonWriterFactory
implements JsonWriterFactory {
    private final JsonGeneratorFactory generatorFactory;

    public GensonJsonWriterFactory() {
        this(Collections.emptyMap());
    }

    public GensonJsonWriterFactory(Map<String, ?> config) {
        this.generatorFactory = new GensonJsonGeneratorFactory(config);
    }

    public JsonWriter createWriter(final Writer writer) {
        return new JsonWriter(){
            private final JsonGenerator generator;
            private boolean written;
            {
                this.generator = GensonJsonWriterFactory.this.generatorFactory.createGenerator(writer);
                this.written = false;
            }

            public void writeArray(JsonArray array) {
                this.checkWritten();
                this.generator.write((JsonValue)array);
            }

            public void writeObject(JsonObject object) {
                this.checkWritten();
                this.generator.write((JsonValue)object);
            }

            public void write(JsonStructure value) {
                this.checkWritten();
                this.generator.write((JsonValue)value);
            }

            public void close() {
                this.generator.close();
            }

            private void checkWritten() {
                if (this.written) {
                    throw new IllegalStateException();
                }
                this.written = true;
            }
        };
    }

    public JsonWriter createWriter(OutputStream out) {
        try {
            return this.createWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonException("Charset UTF-8 is not supported.", (Throwable)e);
        }
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return this.generatorFactory.getConfigInUse();
    }
}

