/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson.convert;

import com.oracle.coherence.io.json.genson.ClassFilter;
import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.Genson;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.Wrapper;
import com.oracle.coherence.io.json.genson.annotation.HandleClassMetadata;
import com.oracle.coherence.io.json.genson.convert.ChainedFactory;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.genson.stream.ValueType;
import java.lang.reflect.Type;
import javax.json.JsonValue;

public class ClassMetadataConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private final boolean classMetadataWithStaticType;
    private final Class<T> tClass;

    public ClassMetadataConverter(Class<T> tClass, Converter<T> delegate, boolean classMetadataWithStaticType) {
        super(delegate);
        this.tClass = tClass;
        this.classMetadataWithStaticType = classMetadataWithStaticType;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws Exception {
        Class<?> clz = obj.getClass();
        ClassFilter filter = ctx.genson.classFilter();
        if (filter != null && !filter.evaluate(clz)) {
            throw new JsonBindingException("Unable to serialize " + clz.getName());
        }
        if (!(obj == null || this.isDefaultObjectType(obj, ctx) || this.isJsonValue(obj.getClass()) || !this.classMetadataWithStaticType && this.tClass.equals(obj.getClass()))) {
            writer.beginNextObjectMetadata().writeMetadata("class", ctx.genson.aliasFor(obj.getClass()));
        }
        ((Converter)this.wrapped).serialize(obj, writer, ctx);
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws Exception {
        String className;
        if (ValueType.OBJECT.equals((Object)reader.getValueType()) && !this.isJsonValue(this.tClass) && (className = reader.nextObjectMetadata().metadata("class")) != null) {
            try {
                Class<?> classFromMetadata = ctx.genson.classFor(className);
                ClassFilter filter = ctx.genson.classFilter();
                if (filter != null && !filter.evaluate(classFromMetadata)) {
                    throw new JsonBindingException("Unable to deserialize " + classFromMetadata.getName());
                }
                if (!classFromMetadata.equals(this.tClass)) {
                    Converter deser = ctx.genson.provideConverter(classFromMetadata);
                    return deser.deserialize(reader, ctx);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new JsonBindingException("Could not use @class metadata, no such class: " + className, e);
            }
        }
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    private boolean isDefaultObjectType(T obj, Context ctx) {
        return obj.getClass().equals(ctx.genson.defaultClass(ValueType.OBJECT));
    }

    private boolean isJsonValue(Class<?> clazz) {
        return JsonValue.class.isAssignableFrom(clazz);
    }

    public static class ClassMetadataConverterFactory
    extends ChainedFactory {
        private final boolean classMetadataWithStaticType;

        public ClassMetadataConverterFactory(boolean classMetadataWithStaticType) {
            this.classMetadataWithStaticType = classMetadataWithStaticType;
        }

        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (nextConverter == null) {
                throw new IllegalArgumentException("nextConverter must be not null for ClassMetadataConverter, as ClassMetadataConverter can not be the last converter in the chain!");
            }
            Class<?> rawClass = TypeUtil.getRawClass(type);
            if (genson.isWithClassMetadata() && !Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(HandleClassMetadata.class)) {
                return new ClassMetadataConverter(rawClass, nextConverter, this.classMetadataWithStaticType);
            }
            return nextConverter;
        }
    }
}

