/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.genson;

import com.oracle.coherence.io.json.genson.Operations;
import com.oracle.coherence.io.json.genson.reflect.TypeUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

public abstract class Wrapper<T>
implements AnnotatedElement {
    private AnnotatedElement wrappedElement;
    protected volatile T wrapped;

    protected Wrapper() {
    }

    protected Wrapper(T wrappedObject) {
        if (wrappedObject == null) {
            throw new IllegalArgumentException("Null not allowed!");
        }
        this.decorate(wrappedObject);
    }

    @Override
    public Annotation[] getAnnotations() {
        return Operations.union(Annotation[].class, this.wrappedElement.getAnnotations(), this.getClass().getAnnotations());
    }

    public <A extends Annotation> A getAnnotation(Class<A> aClass) {
        A ann = this.wrappedElement.getAnnotation(aClass);
        return ann == null ? this.getClass().getAnnotation(aClass) : ann;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Operations.union(Annotation[].class, this.wrappedElement.getDeclaredAnnotations(), this.getClass().getDeclaredAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.wrappedElement.isAnnotationPresent(annotationClass) || this.getClass().isAnnotationPresent(annotationClass);
    }

    protected void decorate(T object) {
        if (this.wrappedElement != null) {
            throw new IllegalStateException("An object is already wrapped!");
        }
        this.wrappedElement = object instanceof AnnotatedElement ? (AnnotatedElement)object : object.getClass();
        this.wrapped = object;
    }

    public T unwrap() {
        return this.wrapped;
    }

    public static AnnotatedElement toAnnotatedElement(Object object) {
        if (object == null) {
            return null;
        }
        if (Wrapper.isWrapped(object)) {
            return (AnnotatedElement)object;
        }
        return object.getClass();
    }

    public static boolean isWrapped(Object object) {
        return object instanceof Wrapper;
    }

    public static boolean isOfType(Object object, Class<?> clazz) {
        return TypeUtil.match(object.getClass(), clazz, false) || Wrapper.isWrapped(object) && Wrapper.isOfType(((Wrapper)object).unwrap(), clazz);
    }
}

