/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json;

import com.oracle.coherence.io.json.ClassFilter;
import com.oracle.coherence.io.json.GensonBundleProvider;
import com.oracle.coherence.io.json.genson.GensonBuilder;
import com.oracle.coherence.io.json.genson.ext.GensonBundle;
import com.oracle.coherence.io.json.internal.NullSetConverter;
import com.tangosol.coherence.config.Config;
import com.tangosol.util.Base;
import com.tangosol.util.NullImplementation;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;

public class CoherenceBundleProvider
implements GensonBundleProvider {
    protected static final String JSON_TYPE_ALIAS_ENFORCEMENT = "coherence.json.type.enforcement";

    @Override
    public GensonBundle provide() {
        return new CoherenceBundle();
    }

    protected static final class ExternalConfiguration {
        protected static final String TYPE_ALIASES_PROPERTIES = "META-INF/type-aliases.properties";
        protected static final String PACKAGE_ALIASES_PROPERTIES = "META-INF/package-aliases.properties";

        protected ExternalConfiguration() {
        }

        protected GensonBuilder apply(GensonBuilder builder, ClassLoader loader) {
            Objects.requireNonNull(builder, "builder may not be null");
            GensonBuilder currentBuilder = builder;
            ClassLoader clzLoader = loader == null ? Base.getContextClassLoader() : loader;
            Map<Properties, URL> typeAliases = this.loadConfigurationFiles(TYPE_ALIASES_PROPERTIES);
            Map<Properties, URL> pkgAliases = this.loadConfigurationFiles(PACKAGE_ALIASES_PROPERTIES);
            typeAliases.forEach((properties, url) -> this.processProperties((Properties)properties, (URL)url, (sAlias, sAliasFor) -> {
                if (properties.containsKey(sAliasFor)) {
                    currentBuilder.addCompatibilityAlias((String)sAlias, (String)sAliasFor);
                } else {
                    currentBuilder.addAlias((String)sAlias, Class.forName(sAliasFor, false, clzLoader));
                }
            }));
            pkgAliases.forEach((properties, url) -> this.processProperties((Properties)properties, (URL)url, currentBuilder::addPackageAlias));
            String sFilters = System.getProperty("jdk.serialFilter");
            if (sFilters != null && !sFilters.isEmpty()) {
                currentBuilder.withClassFilter(new ClassFilter());
            }
            return currentBuilder;
        }

        protected void processProperties(Properties props, URL url, ThrowingBiConsumer<String, String> consumer) {
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(oAlias, oAliasFor) -> {
                try {
                    consumer.accept(oAlias.toString(), oAliasFor.toString());
                }
                catch (IllegalArgumentException iae) {
                    throw Base.ensureRuntimeException((Throwable)iae, (String)String.format("Failed to process type aliases defined in %s", url));
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException((Throwable)e);
                }
            }));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Map<Properties, URL> loadConfigurationFiles(String sResourceName) {
            Objects.requireNonNull(sResourceName, "resourceName may not be null");
            LinkedHashMap<Properties, URL> props = new LinkedHashMap<Properties, URL>(4);
            try {
                Enumeration<URL> configFiles = Base.getContextClassLoader().getResources(sResourceName);
                while (configFiles.hasMoreElements()) {
                    Properties p = new Properties();
                    URL url = configFiles.nextElement();
                    try {
                        p.load(url.openStream());
                        props.put(p, url);
                    }
                    catch (IOException e) {
                        throw Base.ensureRuntimeException((Throwable)e, (String)String.format("Unable to load properties from %s", url.toString()));
                        return props;
                    }
                }
            }
            catch (IOException e) {
                throw Base.ensureRuntimeException((Throwable)e, (String)String.format("Error loading serializer configuration %s from classpath", sResourceName));
            }
        }

        protected static interface ThrowingBiConsumer<T, U> {
            public void accept(T var1, U var2) throws Exception;
        }
    }

    protected static final class CoherenceBundle
    extends GensonBundle {
        protected CoherenceBundle() {
        }

        @Override
        public void configure(GensonBuilder builder) {
            builder.setEnforceTypeAliases(Config.getBoolean((String)CoherenceBundleProvider.JSON_TYPE_ALIAS_ENFORCEMENT, (boolean)true)).withConverter(NullSetConverter.INSTANCE, NullImplementation.NullSet.class);
            ExternalConfiguration extConfig = new ExternalConfiguration();
            extConfig.apply(builder, Base.getContextClassLoader());
        }
    }
}

