/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.io.json.internal;

import com.oracle.coherence.io.json.genson.Context;
import com.oracle.coherence.io.json.genson.Converter;
import com.oracle.coherence.io.json.genson.JsonBindingException;
import com.oracle.coherence.io.json.genson.stream.ObjectReader;
import com.oracle.coherence.io.json.genson.stream.ObjectWriter;
import com.oracle.coherence.io.json.internal.RoundingModeConverter;
import java.math.MathContext;
import java.math.RoundingMode;

public class MathContextConverter
implements Converter<MathContext> {
    public static final MathContextConverter INSTANCE = new MathContextConverter();

    private MathContextConverter() {
    }

    @Override
    public void serialize(MathContext mathContext, ObjectWriter writer, Context ctx) throws Exception {
        writer.beginObject();
        writer.writeName("precision");
        writer.writeValue(mathContext.getPrecision());
        writer.writeName("roundingMode");
        RoundingModeConverter.INSTANCE.serialize(mathContext.getRoundingMode(), writer, ctx);
        writer.endObject();
    }

    @Override
    public MathContext deserialize(ObjectReader reader, Context ctx) throws Exception {
        int precision = -1;
        RoundingMode roundMode = null;
        reader.beginObject();
        while (reader.hasNext()) {
            reader.next();
            String name = reader.name();
            if ("precision".equals(name)) {
                precision = reader.valueAsInt();
                if (precision >= 0) continue;
                throw new JsonBindingException("Unable to deserialize java.math.MathContext; invalid value [" + precision + "] for precision");
            }
            if (!"roundingMode".equals(name)) continue;
            roundMode = RoundingModeConverter.INSTANCE.deserialize(reader, ctx);
        }
        reader.endObject();
        if (precision == -1 && roundMode == null) {
            throw new JsonBindingException("Unable to deserialize java.math.MathContext; no attributes present in object");
        }
        if (precision == -1) {
            throw new JsonBindingException("Unable to deserialize java.math.MathContext; roundMode attribute is present, but the precision attribute is not");
        }
        if (roundMode == null) {
            return new MathContext(precision);
        }
        return new MathContext(precision, roundMode);
    }
}

