/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntryEvent;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryListenerRegistration;
import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.MapEvent;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

public class LocalCacheAsynchronousMapListener<K, V>
extends AbstractMapListener {
    protected final String f_sDescription;
    protected final LocalCache<K, V> m_cache;

    LocalCacheAsynchronousMapListener(String sDescription, LocalCache<K, V> cache) {
        this.f_sDescription = sDescription;
        this.m_cache = cache;
    }

    public void entryInserted(MapEvent evt) {
        CoherenceCacheEventEventDispatcher<K, V> dispatcher = new CoherenceCacheEventEventDispatcher<K, V>();
        CoherenceCacheEntryEvent<K, V> createdEntry = new CoherenceCacheEntryEvent<K, V>(this.m_cache, EventType.CREATED, this.keyFromInternal(evt.getKey()), this.valueFromInternal(evt.getNewValue()));
        dispatcher.addEvent(CacheEntryCreatedListener.class, createdEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    public void entryUpdated(MapEvent evt) {
        CoherenceCacheEventEventDispatcher<K, V> dispatcher = new CoherenceCacheEventEventDispatcher<K, V>();
        CoherenceCacheEntryEvent<K, V> updatedEntry = new CoherenceCacheEntryEvent<K, V>(this.m_cache, EventType.UPDATED, this.keyFromInternal(evt.getKey()), this.valueFromInternal(evt.getNewValue()), this.valueFromInternal(evt.getOldValue()));
        dispatcher.addEvent(CacheEntryUpdatedListener.class, updatedEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    public void entryDeleted(MapEvent evt) {
        CoherenceCacheEventEventDispatcher<K, V> dispatcher = new CoherenceCacheEventEventDispatcher<K, V>();
        CoherenceCacheEntryEvent<K, Object> deletedEntry = new CoherenceCacheEntryEvent<K, Object>(this.m_cache, EventType.REMOVED, this.keyFromInternal(evt.getKey()), null, this.valueFromInternal(evt.getOldValue()));
        dispatcher.addEvent(CacheEntryRemovedListener.class, deletedEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    private K keyFromInternal(Object internalKey) {
        return this.m_cache.getKeyConverter().fromInternal(internalKey);
    }

    private V valueFromInternal(Object value) {
        LocalCacheValue cacheValue = (LocalCacheValue)value;
        return this.m_cache.getValueConverter().fromInternal(cacheValue.getInternalValue());
    }

    protected Iterable<CoherenceCacheEntryListenerRegistration<K, V>> getEventListeners() {
        return this.m_cache.getRegisteredAsynchronousEventListeners();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " cacheName=" + (this.m_cache == null ? "" : this.m_cache.getName()) + " description=" + this.f_sDescription;
    }

    public static class NonSyntheticEntryFilter
    extends com.tangosol.coherence.jcache.common.NonSyntheticEntryFilter {
        @Override
        public boolean isJCacheSynthetic(CacheEvent evt) {
            LocalCacheValue cacheValue = (LocalCacheValue)evt.getNewValue();
            return cacheValue.isSyntheticUpdate();
        }
    }
}

