/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.coherence.jcache.common.AbstractJCacheStatistics;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class ContextJCacheStatistics
extends AbstractJCacheStatistics
implements JCacheStatistics,
ExternalizableLite,
PortableObject {
    private static final long serialVersionUID = -1L;
    private final AtomicLong m_cGets = new AtomicLong(0L);
    private final AtomicLong m_cHits = new AtomicLong(0L);
    private final AtomicLong m_cHitsMillis = new AtomicLong(0L);
    private final AtomicLong m_cMisses = new AtomicLong(0L);
    private final AtomicLong m_cMissesMillis = new AtomicLong(0L);
    private final AtomicLong m_cPuts = new AtomicLong(0L);
    private final AtomicLong m_cPutsMillis = new AtomicLong(0L);
    private final AtomicLong m_cRemove = new AtomicLong(0L);
    private final AtomicLong m_cRemoveMillis = new AtomicLong(0L);
    private JCacheIdentifier m_id;

    public ContextJCacheStatistics() {
    }

    public ContextJCacheStatistics(JCacheIdentifier id) {
        this.m_id = id;
    }

    @Override
    public void registerHits(int count, long lStartMillis) {
        this.m_cGets.addAndGet(count);
        this.m_cHits.addAndGet(count);
        this.registerHitsCompleted(lStartMillis);
    }

    @Override
    public void registerMisses(int count, long lStartMillis) {
        this.m_cGets.addAndGet(count);
        this.m_cMisses.addAndGet(count);
        this.registerMissesCompleted(lStartMillis);
    }

    @Override
    public void registerPuts(long count, long lStartMillis) {
        this.m_cPuts.addAndGet(count);
        this.registerPutsCompleted(lStartMillis);
    }

    @Override
    public void registerPutsCompleted(long lStartMillis) {
        this.m_cPutsMillis.addAndGet(Helper.getCurrentTimeMillis() - lStartMillis);
    }

    @Override
    public void registerRemoves(long count, long lStartMillis) {
        this.m_cRemove.addAndGet(count);
        this.registerRemoveCompleted(lStartMillis);
    }

    @Override
    public void registerRemove() {
        this.m_cRemove.incrementAndGet();
    }

    @Override
    public void registerHitsCompleted(long lStartMillis) {
        this.m_cHitsMillis.addAndGet(Helper.getCurrentTimeMillis() - lStartMillis);
    }

    @Override
    public void registerMissesCompleted(long lStartMillis) {
        this.m_cMissesMillis.addAndGet(Helper.getCurrentTimeMillis() - lStartMillis);
    }

    @Override
    public void registerRemoveCompleted(long lStartMillis) {
        this.m_cRemoveMillis.addAndGet(Helper.getCurrentTimeMillis() - lStartMillis);
    }

    @Override
    public JCacheIdentifier getIdentifier() {
        return this.m_id;
    }

    @Override
    public JCacheStatistics add(JCacheStatistics stats) {
        this.m_cGets.addAndGet(stats.getCacheGets());
        this.m_cHits.addAndGet(stats.getCacheHits());
        this.m_cHitsMillis.addAndGet(stats.getCacheHitsMillis());
        this.m_cMisses.addAndGet(stats.getCacheMisses());
        this.m_cMissesMillis.addAndGet(stats.getCacheMissesMillis());
        this.m_cPuts.addAndGet(stats.getCachePuts());
        this.m_cPutsMillis.addAndGet(stats.getCachePutsMillis());
        this.m_cRemove.addAndGet(stats.getCacheRemovals());
        this.m_cRemoveMillis.addAndGet(stats.getCacheRemoveMillis());
        return this;
    }

    @Override
    public long getCacheHitsMillis() {
        return this.m_cHitsMillis.get();
    }

    @Override
    public long getCacheMissesMillis() {
        return this.m_cMissesMillis.get();
    }

    @Override
    public long getCachePutsMillis() {
        return this.m_cPutsMillis.get();
    }

    @Override
    public long getCacheRemoveMillis() {
        return this.m_cRemoveMillis.get();
    }

    @Override
    public void clear() {
        this.m_cGets.set(0L);
        this.m_cHits.set(0L);
        this.m_cHitsMillis.set(0L);
        this.m_cMisses.set(0L);
        this.m_cMissesMillis.set(0L);
        this.m_cPuts.set(0L);
        this.m_cPutsMillis.set(0L);
        this.m_cRemove.set(0L);
        this.m_cRemoveMillis.set(0L);
    }

    @Override
    public long getCacheHits() {
        return this.m_cHits.get();
    }

    @Override
    public float getCacheHitPercentage() {
        return this.getCacheGets() == 0L ? 0.0f : (float)this.getCacheHits() / (float)this.getCacheGets() * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.m_cMisses.get();
    }

    @Override
    public float getCacheMissPercentage() {
        return this.getCacheGets() == 0L ? 0.0f : (float)this.getCacheMisses() / (float)this.getCacheGets() * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.m_cGets.get();
    }

    @Override
    public long getCachePuts() {
        return this.m_cPuts.get();
    }

    @Override
    public long getCacheRemovals() {
        return this.m_cRemove.get();
    }

    @Override
    public long getCacheEvictions() {
        return 0L;
    }

    @Override
    public float getAverageGetTime() {
        long gets = this.getCacheGets();
        return gets == 0L ? 0.0f : (float)(this.getCacheMissesMillis() + this.getCacheHitsMillis()) / (float)gets;
    }

    @Override
    public float getAveragePutTime() {
        long puts = this.getCachePuts();
        return puts == 0L ? 0.0f : (float)this.getCachePutsMillis() / (float)puts;
    }

    @Override
    public float getAverageRemoveTime() {
        long count = this.getCacheRemovals();
        return count == 0L ? 0.0f : (float)this.getCacheRemoveMillis() / (float)count;
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_id = (JCacheIdentifier)in.readObject(0);
        this.m_cGets.set(in.readLong(1));
        this.m_cHits.set(in.readLong(2));
        this.m_cHitsMillis.set(in.readLong(3));
        this.m_cMisses.set(in.readLong(4));
        this.m_cMissesMillis.set(in.readLong(5));
        this.m_cPuts.set(in.readLong(6));
        this.m_cPutsMillis.set(in.readLong(7));
        this.m_cRemove.set(in.readLong(8));
        this.m_cRemoveMillis.set(in.readLong(9));
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, (Object)this.m_id);
        out.writeLong(1, this.m_cGets.get());
        out.writeLong(2, this.m_cHits.get());
        out.writeLong(3, this.m_cHitsMillis.get());
        out.writeLong(4, this.m_cMisses.get());
        out.writeLong(5, this.m_cMissesMillis.get());
        out.writeLong(6, this.m_cPuts.get());
        out.writeLong(7, this.m_cPutsMillis.get());
        out.writeLong(8, this.m_cRemove.get());
        out.writeLong(9, this.m_cRemoveMillis.get());
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_id = (JCacheIdentifier)ExternalizableHelper.readObject((DataInput)in);
        this.m_cGets.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cHits.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cHitsMillis.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cMisses.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cMissesMillis.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cPuts.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cPutsMillis.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cRemove.set(ExternalizableHelper.readLong((DataInput)in));
        this.m_cRemoveMillis.set(ExternalizableHelper.readLong((DataInput)in));
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_id);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cGets.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cHits.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cHitsMillis.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cMisses.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cMissesMillis.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cPuts.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cPutsMillis.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cRemove.get());
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_cRemoveMillis.get());
    }
}

