/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ResourceRegistry;
import javax.cache.configuration.CompleteConfiguration;

public class BinaryEntryHelper {
    private static int EXPIRY_POLICY_EXCEPTION_LOG_LEVEL = 2;
    public static final Byte JCACHE_SYNTHETIC_EXPIRY = 1;
    public static final Byte JCACHE_SYNTHETIC_CLEAR = 2;
    public static final Byte JCACHE_SYNTHETIC_EXPIRY_EVENT_FOR_ORIGINAL_VALUES = 3;
    public static final Byte JCACHE_SYNTHETIC_UPDATE = 4;
    public static final Byte JCACHE_SYNTHETIC_LOADED = 5;

    public static boolean isExpired(BackingMapManagerContext ctx, Binary binValue, JCacheEntryMetaInf metaInf, long ldtNow) {
        if (binValue != null && metaInf != null && metaInf.isExpiredAt(ldtNow)) {
            return true;
        }
        Byte bJCacheSynthetic = BinaryEntryHelper.getJCacheSyntheticKind(binValue, ctx);
        return JCACHE_SYNTHETIC_CLEAR.equals(bJCacheSynthetic) || JCACHE_SYNTHETIC_EXPIRY.equals(bJCacheSynthetic);
    }

    public static boolean isExpired(BinaryEntry binEntry, long ldtNow) {
        return binEntry.isPresent() ? BinaryEntryHelper.isExpired(binEntry.getContext(), binEntry.getBinaryValue(), BinaryEntryHelper.getValueMetaInf(binEntry), ldtNow) : false;
    }

    public static boolean isExpired(BinaryEntry binEntry, JCacheEntryMetaInf metaInf, long ldtNow) {
        return binEntry.isPresent() ? BinaryEntryHelper.isExpired(binEntry.getContext(), binEntry.getBinaryValue(), metaInf, ldtNow) : false;
    }

    public static Binary decorateBinValueWithJCacheMetaInf(Binary binValue, JCacheEntryMetaInf metaInf, BackingMapManagerContext ctx) {
        if (ctx.isInternalValueDecorated((Object)binValue, 14)) {
            binValue = (Binary)ctx.removeInternalValueDecoration((Object)binValue, 14);
        }
        binValue = (Binary)ctx.addInternalValueDecoration((Object)binValue, 14, (Object)metaInf);
        return binValue;
    }

    public static Binary decorateUpdateJCacheSynthetic(Binary binValue, BackingMapManagerContext ctx, Byte bJCacheSyntheticUpdate) {
        binValue = (Binary)ctx.removeInternalValueDecoration((Object)binValue, 15);
        binValue = (Binary)ctx.addInternalValueDecoration((Object)binValue, 15, (Object)bJCacheSyntheticUpdate);
        return binValue;
    }

    public static void expireEntry(BinaryEntry binEntryExpired) {
        BinaryEntryHelper.syntheticUpdateToEntry(binEntryExpired, JCACHE_SYNTHETIC_EXPIRY);
    }

    public static void syntheticUpdateToEntry(BinaryEntry binEntry, byte bJCacheSyntheticKind) {
        Binary binValue = BinaryEntryHelper.decorateUpdateJCacheSynthetic(binEntry.getBinaryValue(), binEntry.getContext(), bJCacheSyntheticKind);
        binEntry.updateBinaryValue(binValue);
        if (bJCacheSyntheticKind == JCACHE_SYNTHETIC_CLEAR || bJCacheSyntheticKind == JCACHE_SYNTHETIC_EXPIRY) {
            binEntry.expire(1L);
        }
    }

    public static Byte getJCacheSyntheticKind(Binary binValue, BackingMapManagerContext ctx) {
        return binValue == null ? null : (Byte)ctx.getInternalValueDecoration((Object)binValue, 15);
    }

    public static JCacheEntryMetaInf getValueMetaInf(BinaryEntry binEntry) {
        Binary binValue = binEntry.isPresent() ? binEntry.getBinaryValue() : null;
        return BinaryEntryHelper.getValueMetaInf(binValue, binEntry.getContext());
    }

    public static JCacheEntryMetaInf getValueMetaInf(Binary binValue, BackingMapManagerContext ctx) {
        return binValue == null ? null : (JCacheEntryMetaInf)ctx.getInternalValueDecoration((Object)binValue, 14);
    }

    public static Binary removeJCacheSyntheticDecoration(Binary binValue, BackingMapManagerContext ctx) {
        Binary binResult = binValue;
        while (ctx.isInternalValueDecorated((Object)binResult, 15)) {
            binResult = (Binary)ctx.removeInternalValueDecoration((Object)binValue, 15);
        }
        assert (!ctx.isInternalValueDecorated((Object)binResult, 15));
        return binResult;
    }

    public static Binary jcacheSyntheticExpiryEventForReusedBinaryEntry(Binary binValue, BackingMapManagerContext ctx) {
        return BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, ctx, JCACHE_SYNTHETIC_EXPIRY_EVENT_FOR_ORIGINAL_VALUES);
    }

    public static boolean isJCacheSynthetic(BinaryEntry binEntry) {
        assert (binEntry != null);
        BackingMapManagerContext ctx = binEntry.getContext();
        Binary binValue = binEntry.getBinaryValue();
        assert (ctx != null);
        if (binValue == null) {
            return false;
        }
        Byte result = (Byte)ctx.getInternalValueDecoration((Object)binValue, 15);
        return result != null && !result.equals(JCACHE_SYNTHETIC_LOADED);
    }

    public static boolean isJCacheSyntheticOrLoaded(BinaryEntry binEntry) {
        assert (binEntry != null);
        BackingMapManagerContext ctx = binEntry.getContext();
        Binary binValue = binEntry.getBinaryValue();
        assert (ctx != null);
        if (binValue == null) {
            return false;
        }
        Byte result = (Byte)ctx.getInternalValueDecoration((Object)binValue, 15);
        return result != null;
    }

    public static ResourceRegistry getResourceRegistry(BinaryEntry binEntry) {
        ConfigurableCacheFactory ccf = binEntry.getContext().getManager().getCacheFactory();
        return ccf.getResourceRegistry();
    }

    public static JCacheContext getContext(JCacheIdentifier cacheId, BinaryEntry binEntry) {
        ResourceRegistry reg = BinaryEntryHelper.getResourceRegistry(binEntry);
        JCacheContext ctx = JCacheContext.getContext(reg, cacheId);
        if (ctx == null) {
            CompleteConfiguration config = BinaryEntryHelper.getCacheToConfigurationMapping(binEntry, cacheId);
            ctx = JCacheContext.getContext(reg, cacheId, config);
        }
        return ctx;
    }

    static NamedCache getConfigurationCache(BinaryEntry binEntry) {
        ClassLoader loader = null;
        ConfigurableCacheFactory ccf = binEntry.getContext().getManager().getCacheFactory();
        return ccf.ensureCache("jcache-configurations", loader);
    }

    static CompleteConfiguration getCacheToConfigurationMapping(BinaryEntry binEntry, JCacheIdentifier cacheId) {
        return (CompleteConfiguration)BinaryEntryHelper.getConfigurationCache(binEntry).get((Object)cacheId.getCanonicalCacheName());
    }

    static Binary jcacheSyntheticUpdateEntry(Binary binValue, BackingMapManagerContext ctx) {
        return BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, ctx, JCACHE_SYNTHETIC_UPDATE);
    }
}

