/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache;

import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import javax.cache.expiry.ExpiryPolicy;

public class LocalCacheValue {
    private Object m_internalValue;
    private JCacheEntryMetaInf m_metaInf;
    private JCacheSyntheticKind m_syntheticKind = JCacheSyntheticKind.JCACHE_SYNTHETIC_NONE;

    private LocalCacheValue(Object internalValue, long ldtCreation, ExpiryPolicy policy, JCacheSyntheticKind kind) {
        this.m_internalValue = internalValue;
        this.m_metaInf = new JCacheEntryMetaInf(ldtCreation, policy);
        this.m_syntheticKind = kind;
    }

    public LocalCacheValue(LocalCacheValue oldValue) {
        this.m_internalValue = oldValue.m_internalValue;
        this.m_metaInf = new JCacheEntryMetaInf(oldValue.m_metaInf);
        this.m_syntheticKind = oldValue.m_syntheticKind;
    }

    public long getCreationTime() {
        return this.m_metaInf.getCreationTime();
    }

    public long getAccessTime() {
        return this.m_metaInf.getAccessTime();
    }

    public long getAccessCount() {
        return this.m_metaInf.getAccessCount();
    }

    public long getModificationTime() {
        return this.m_metaInf.getModificationTime();
    }

    public long getModificationCount() {
        return this.m_metaInf.getModificationCount();
    }

    public long getExpiryTime() {
        return this.m_metaInf.getExpiryTime();
    }

    public void setExpiryTime(long ldtExpiry) {
        this.m_metaInf.setExpiryTime(ldtExpiry);
    }

    public boolean isExpiredAt(long ldtNow) {
        return this.m_metaInf.isExpiredAt(ldtNow);
    }

    public Object get() {
        return this.m_internalValue;
    }

    public void set(Object internalValue) {
        this.m_internalValue = internalValue;
    }

    public Object getInternalValue(long ldtAccess) {
        this.m_metaInf.setAccessTime(ldtAccess);
        this.m_syntheticKind = JCacheSyntheticKind.JCACHE_SYNTHETIC_UPDATE;
        return this.m_internalValue;
    }

    public Object getInternalValue() {
        return this.m_internalValue;
    }

    public LocalCacheValue updateInternalValue(Object internalValue, long ldtModification, ExpiryPolicy policy) {
        this.m_metaInf.modified(ldtModification, policy);
        this.m_syntheticKind = JCacheSyntheticKind.JCACHE_SYNTHETIC_NONE;
        this.m_internalValue = internalValue;
        return this;
    }

    public void accessInternalValue(long ldtAccess, ExpiryPolicy policy) {
        this.m_metaInf.accessed(ldtAccess, policy);
        this.m_syntheticKind = JCacheSyntheticKind.JCACHE_SYNTHETIC_UPDATE;
    }

    public static LocalCacheValue createLoadedLocalCacheValue(Object internalValue, long ldtCreation, ExpiryPolicy policy) {
        return LocalCacheValue.createLocalCacheValue(internalValue, ldtCreation, policy, JCacheSyntheticKind.JCACHE_SYNTHETHIC_LOADED);
    }

    public static LocalCacheValue createLocalCacheValue(Object internalValue, long ldtCreation, ExpiryPolicy policy) {
        return LocalCacheValue.createLocalCacheValue(internalValue, ldtCreation, policy, JCacheSyntheticKind.JCACHE_SYNTHETIC_NONE);
    }

    public boolean isSyntheticUpdate() {
        boolean fResult = false;
        switch (this.m_syntheticKind) {
            case JCACHE_SYNTHETIC_CLEAR: 
            case JCACHE_SYNTHETIC_UPDATE: {
                fResult = true;
                break;
            }
            case JCACHE_SYNTHETIC_NONE: 
            case JCACHE_SYNTHETHIC_LOADED: {
                fResult = false;
            }
        }
        return fResult;
    }

    public boolean isLoaded() {
        return this.m_syntheticKind == JCacheSyntheticKind.JCACHE_SYNTHETHIC_LOADED;
    }

    private static LocalCacheValue createLocalCacheValue(Object internalValue, long ldtCreation, ExpiryPolicy policy, JCacheSyntheticKind kind) {
        return new LocalCacheValue(internalValue, ldtCreation, policy, kind);
    }

    public static enum JCacheSyntheticKind {
        JCACHE_SYNTHETIC_NONE,
        JCACHE_SYNTHETIC_CLEAR,
        JCACHE_SYNTHETIC_UPDATE,
        JCACHE_SYNTHETHIC_LOADED;

    }
}

