/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;

public class CacheLoaderProcessor<K, V>
extends AbstractEntryProcessor {
    private Factory<CacheLoader<K, V>> m_cacheLoaderFactory;
    private InvocableMap.EntryProcessor m_next;

    public CacheLoaderProcessor() {
    }

    public CacheLoaderProcessor(InvocableMap.EntryProcessor next, JCacheIdentifier id) {
        super(id);
        this.m_next = next;
    }

    public Object process(InvocableMap.Entry entry) {
        JCacheContext jcacheCtx;
        long ldtNow = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        if ((!binEntry.isPresent() || binEntry.isPresent() && BinaryEntryHelper.isExpired(binEntry, ldtNow)) && (jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry)).isReadThrough()) {
            Object oValue = jcacheCtx.getCacheLoader().load(entry.getKey());
            if (oValue == null) {
                throw new NullPointerException();
            }
            BackingMapManagerContext ctx = binEntry.getContext();
            Binary binValue = (Binary)ctx.getValueToInternalConverter().convert(oValue);
            JCacheEntryMetaInf valueMetaInf = new JCacheEntryMetaInf(ldtNow, jcacheCtx.getExpiryPolicy());
            if (!valueMetaInf.isExpiredAt(ldtNow)) {
                binValue = (Binary)ctx.addInternalValueDecoration((Object)binValue, 14, (Object)valueMetaInf);
                binEntry.updateBinaryValue(binValue);
            }
        }
        return this.m_next.process(entry);
    }

    @Override
    public void readExternal(DataInput dataInput) throws IOException {
        super.readExternal(dataInput);
        this.m_cacheLoaderFactory = (Factory)ExternalizableHelper.readObject((DataInput)dataInput);
        this.m_next = (InvocableMap.EntryProcessor)ExternalizableHelper.readObject((DataInput)dataInput);
    }

    @Override
    public void writeExternal(DataOutput dataOutput) throws IOException {
        super.writeExternal(dataOutput);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, this.m_cacheLoaderFactory);
        ExternalizableHelper.writeObject((DataOutput)dataOutput, (Object)this.m_next);
    }

    @Override
    public void readExternal(PofReader pofReader) throws IOException {
        super.readExternal(pofReader);
        this.m_cacheLoaderFactory = (Factory)pofReader.readObject(1);
        this.m_next = (InvocableMap.EntryProcessor)pofReader.readObject(2);
    }

    @Override
    public void writeExternal(PofWriter pofWriter) throws IOException {
        super.writeExternal(pofWriter);
        pofWriter.writeObject(1, this.m_cacheLoaderFactory);
        pofWriter.writeObject(2, (Object)this.m_next);
    }
}

