/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.cache.configuration.CompleteConfiguration;

public abstract class AbstractEntryProcessor<K>
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    protected JCacheIdentifier m_cacheId;

    AbstractEntryProcessor() {
        this.m_cacheId = null;
    }

    AbstractEntryProcessor(JCacheIdentifier cacheId) {
        this.m_cacheId = cacheId;
    }

    protected NamedCache getConfigurationCache(BinaryEntry binEntry) {
        ClassLoader loader = null;
        ConfigurableCacheFactory ccf = binEntry.getContext().getManager().getCacheFactory();
        return ccf.ensureCache("jcache-configurations", loader);
    }

    protected CompleteConfiguration getCacheToConfigurationMapping(BinaryEntry binEntry, JCacheIdentifier cacheId) {
        return (CompleteConfiguration)this.getConfigurationCache(binEntry).get((Object)cacheId.getCanonicalCacheName());
    }

    public void clearEntry(BinaryEntry binEntry) {
        binEntry.remove(true);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.m_cacheId = (JCacheIdentifier)ExternalizableHelper.readObject((DataInput)dataInput);
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)dataOutput, (Object)this.m_cacheId);
    }

    public void readExternal(PofReader pofReader) throws IOException {
        this.m_cacheId = (JCacheIdentifier)pofReader.readObject(0);
    }

    public void writeExternal(PofWriter pofWriter) throws IOException {
        pofWriter.writeObject(0, (Object)this.m_cacheId);
    }
}

