/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.EventType;

public class CoherenceCacheEntryEvent<K, V>
extends CacheEntryEvent<K, V> {
    private static final boolean JCACHE_1_0_COMPATIBILITY_MODE = true;
    private final K m_key;
    private final V m_value;
    private final V m_valueOld;
    private final boolean m_fOldValueAvailable;

    public CoherenceCacheEntryEvent(Cache<K, V> cache, EventType eventType, K key, V value) {
        super(cache, eventType);
        this.m_key = key;
        this.m_value = value;
        this.m_valueOld = null;
        this.m_fOldValueAvailable = false;
    }

    public CoherenceCacheEntryEvent(Cache<K, V> cache, EventType eventType, K key, V value, V oldValue) {
        super(cache, eventType);
        this.m_key = key;
        this.m_value = value;
        this.m_valueOld = oldValue;
        this.m_fOldValueAvailable = true;
    }

    public K getKey() {
        return this.m_key;
    }

    public V getValue() {
        switch (this.getEventType()) {
            case CREATED: 
            case UPDATED: {
                return this.m_value;
            }
            case EXPIRED: 
            case REMOVED: {
                return this.getOldValue();
            }
        }
        return null;
    }

    public <T> T unwrap(Class<T> clz) {
        if (clz != null && clz.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException("Class " + clz + " is unknown to this implementation");
    }

    public V getOldValue() {
        return this.m_valueOld;
    }

    public boolean isOldValueAvailable() {
        return this.m_fOldValueAvailable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("CacheEntryEvent[");
        buf.append(" key=");
        buf.append(this.getKey());
        buf.append(", value=");
        try {
            buf.append(this.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.isOldValueAvailable()) {
                buf.append(", oldValue=");
                buf.append(this.getOldValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return buf.toString();
    }
}

