/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.BinaryEntryStore;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;

public class PartitionedCacheBinaryEntryStore<K, V>
implements BinaryEntryStore {
    private transient AtomicReference<JCacheContext> m_refCtx = new AtomicReference();
    private final JCacheIdentifier m_cacheId;

    public PartitionedCacheBinaryEntryStore(String sName, BackingMapManagerContext mgrCtx, ClassLoader classLoader) {
        this.m_cacheId = new JCacheIdentifier(sName);
        Logger.finest(() -> "Created PartitionedCacheBinaryEntryStore for [name=" + sName + " JCacheId=" + this.m_cacheId.getCanonicalCacheName() + "]");
    }

    public void load(BinaryEntry binaryEntry) {
        Object oValue;
        long ldtStart = Helper.getCurrentTimeMillis();
        CacheLoader loader = this.getReadThroughCacheLoader(binaryEntry);
        if (loader != null && (oValue = loader.load(binaryEntry.getKey())) != null) {
            Binary binValue = (Binary)binaryEntry.getContext().getValueToInternalConverter().convert(oValue);
            JCacheEntryMetaInf metaInf = new JCacheEntryMetaInf(ldtStart, this.getExpiryPolicy(binaryEntry));
            binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, metaInf, binaryEntry.getContext());
            binValue = BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, binaryEntry.getContext(), BinaryEntryHelper.JCACHE_SYNTHETIC_LOADED);
            binaryEntry.updateBinaryValue(binValue);
            Logger.finest(() -> "PartitionedCacheBinaryEntryStore.load loaded key=" + binaryEntry.getKey() + " value=" + oValue);
        }
    }

    public void loadAll(Set set) {
        BinaryEntry aBinEntry;
        CacheLoader loader;
        long ldtStart = Helper.getCurrentTimeMillis();
        Set binEntries = set;
        if (!binEntries.isEmpty() && (loader = this.getReadThroughCacheLoader(aBinEntry = (BinaryEntry)binEntries.iterator().next())) != null) {
            try {
                JCacheEntryMetaInf metaInf = new JCacheEntryMetaInf(ldtStart, this.getExpiryPolicy(aBinEntry));
                Converter toInternalConverter = aBinEntry.getContext().getValueToInternalConverter();
                Map loadedMap = loader.loadAll((Iterable)new KeyIterable(binEntries));
                for (BinaryEntry binEntry : binEntries) {
                    Object oValue = loadedMap.get(binEntry.getKey());
                    if (binEntry.isPresent() || oValue == null) continue;
                    Binary binValue = (Binary)toInternalConverter.convert(oValue);
                    binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, metaInf, binEntry.getContext());
                    binValue = BinaryEntryHelper.decorateUpdateJCacheSynthetic(binValue, binEntry.getContext(), BinaryEntryHelper.JCACHE_SYNTHETIC_LOADED);
                    binEntry.updateBinaryValue(binValue);
                }
            }
            catch (Throwable e) {
                throw new CacheLoaderException(e);
            }
        }
    }

    public void store(BinaryEntry binaryEntry) {
        boolean fJCacheSynthetic;
        CacheWriter writer = this.getCacheWriter(binaryEntry);
        if (writer != null && !(fJCacheSynthetic = BinaryEntryHelper.isJCacheSyntheticOrLoaded(binaryEntry))) {
            CacheEntry entry = new CacheEntry(binaryEntry);
            writer.write(entry);
        }
    }

    public void storeAll(Set set) {
        if (set.isEmpty()) {
            return;
        }
        Set binEntries = set;
        CacheWriter writer = this.getCacheWriter((BinaryEntry)binEntries.iterator().next());
        if (writer != null) {
            Iterator iter = binEntries.iterator();
            while (iter.hasNext()) {
                if (!BinaryEntryHelper.isJCacheSyntheticOrLoaded((BinaryEntry)iter.next())) continue;
                iter.remove();
            }
            if (set.size() != 0) {
                ArrayList jcacheEntries = new ArrayList(set.size());
                for (BinaryEntry binEntry : binEntries) {
                    jcacheEntries.add(new CacheEntry(binEntry));
                }
                try {
                    writer.writeAll(jcacheEntries);
                    set.clear();
                }
                catch (RuntimeException e) {
                    set.clear();
                    for (Cache.Entry entry : jcacheEntries) {
                        set.add(entry.unwrap(BinaryEntry.class));
                    }
                    throw e;
                }
            }
        }
    }

    public void erase(BinaryEntry binaryEntry) {
        CacheWriter writer = this.getCacheWriter(binaryEntry);
        if (writer != null) {
            Logger.finest(() -> "PartitionedCacheBinaryEntryStore.erase calling CacheWriter.delete on key=" + binaryEntry.getKey() + "CacheWriter class=" + writer.getClass().getCanonicalName());
            try {
                writer.delete(binaryEntry.getKey());
            }
            catch (UnsupportedOperationException e) {
                throw new CacheWriterException("CacheWriter implementation " + writer.getClass().getCanonicalName() + ".delete threw an exception", (Throwable)e);
            }
        }
    }

    public void eraseAll(Set set) {
        if (set.isEmpty()) {
            return;
        }
        CacheWriter writer = this.getCacheWriter((BinaryEntry)set.iterator().next());
        if (writer != null) {
            try {
                HashSet<Object> keys = new HashSet<Object>();
                KeyIterator iter = new KeyIterator(set);
                while (iter.hasNext()) {
                    keys.add(iter.next());
                }
                writer.deleteAll(keys);
            }
            catch (RuntimeException re) {
                throw new CacheWriterException("CacheWriter implementation " + writer.getClass().getCanonicalName() + ".deleteAll(Set) threw an exception", (Throwable)re);
            }
        }
    }

    private JCacheContext getContext(BinaryEntry binEntry) {
        if (this.m_refCtx.get() == null) {
            this.m_refCtx.compareAndSet(null, BinaryEntryHelper.getContext(this.m_cacheId, binEntry));
        }
        return this.m_refCtx.get();
    }

    private ExpiryPolicy getExpiryPolicy(BinaryEntry binEntry) {
        return this.getContext(binEntry).getExpiryPolicy();
    }

    private CacheLoader getCacheLoader(BinaryEntry binEntry) {
        return this.getContext(binEntry).getCacheLoader();
    }

    private CacheLoader getReadThroughCacheLoader(BinaryEntry binEntry) {
        return this.getContext(binEntry).isReadThrough() ? this.getCacheLoader(binEntry) : null;
    }

    private CacheWriter getCacheWriter(BinaryEntry binEntry) {
        return this.getContext(binEntry).getCacheWriter();
    }

    private static class KeyIterator
    implements Iterator<Object> {
        private final Iterator<BinaryEntry> f_iter;

        public KeyIterator(Set<BinaryEntry> binEntries) {
            this.f_iter = binEntries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.f_iter.hasNext();
        }

        @Override
        public Object next() {
            BinaryEntry binEntry = this.f_iter.next();
            return binEntry == null ? null : binEntry.getKey();
        }

        @Override
        public void remove() {
            this.f_iter.remove();
        }
    }

    private static class KeyIterable
    implements Iterable<Object> {
        public final KeyIterator f_iter;

        public KeyIterable(Set<BinaryEntry> set) {
            this.f_iter = new KeyIterator(set);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.f_iter;
        }
    }

    private static class CacheEntry<K, V>
    implements Cache.Entry<K, V> {
        private final BinaryEntry f_binEntry;

        public CacheEntry(BinaryEntry binEntry) {
            this.f_binEntry = binEntry;
        }

        public K getKey() {
            return (K)this.f_binEntry.getKey();
        }

        public V getValue() {
            return (V)this.f_binEntry.getValue();
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz != null && clazz.isInstance(this)) {
                return (T)this;
            }
            if (clazz != null && clazz.isAssignableFrom(BinaryEntry.class)) {
                return (T)this.f_binEntry;
            }
            throw new IllegalArgumentException("The class " + clazz + " is unknown to this implementation");
        }
    }
}

