/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.localcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntry;
import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.coherence.jcache.localcache.LocalCacheValue;
import com.tangosol.coherence.jcache.localcache.processors.AbstractEntryProcessor;
import com.tangosol.util.InvocableMap;

public class GetAndReplaceProcessor<K, V>
extends AbstractEntryProcessor<K, V, V> {
    private Object m_internalNewValue;

    public GetAndReplaceProcessor(LocalCache cache, Object internalNewValue) {
        super(cache);
        this.m_internalNewValue = internalNewValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object process(InvocableMap.Entry entry) {
        Object exisitingValue = null;
        boolean fStatisticsEnabled = this.isStatisticsEnabled();
        long ldtNow = Helper.getCurrentTimeMillis();
        long ldtStart = fStatisticsEnabled ? ldtNow : 0L;
        try {
            if (entry.isPresent()) {
                boolean fIsExpired;
                LocalCacheValue cachedValue = (LocalCacheValue)entry.getValue();
                boolean bl = fIsExpired = cachedValue != null && cachedValue.isExpiredAt(ldtNow);
                if (cachedValue == null || fIsExpired) {
                    exisitingValue = null;
                    if (fIsExpired) {
                        this.processExpiries(entry.getKey());
                    }
                } else {
                    exisitingValue = cachedValue.getInternalValue(ldtNow);
                    CoherenceCacheEntry entryExternal = new CoherenceCacheEntry(this.fromInternalKey(entry.getKey()), this.fromInternalValue(this.m_internalNewValue));
                    this.writeCacheEntry(entryExternal);
                    entry.setValue((Object)this.updateLocalCacheValue(cachedValue, this.m_internalNewValue, ldtNow));
                }
            }
        }
        finally {
            if (fStatisticsEnabled) {
                JCacheStatistics stats = this.getJCacheStatistics();
                if (exisitingValue == null) {
                    stats.registerMisses(1, ldtStart);
                } else {
                    stats.registerPuts(1L, ldtStart);
                    stats.registerHits(1, ldtStart);
                }
            }
        }
        return exisitingValue;
    }
}

