/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.serialization.SerializationHelper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.cache.CacheException;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class CoherenceEntryProcessorResult<T>
implements EntryProcessorResult<T>,
ExternalizableLite,
PortableObject {
    private T m_oResult;
    private Exception m_exception;

    public CoherenceEntryProcessorResult() {
    }

    public CoherenceEntryProcessorResult(Exception exception) {
        this.m_oResult = null;
        this.m_exception = exception;
    }

    public CoherenceEntryProcessorResult(T oResult) {
        this.m_oResult = oResult;
        this.m_exception = null;
    }

    public T get() throws EntryProcessorException {
        if (this.m_exception == null) {
            return this.m_oResult;
        }
        Throwable throwable = Helper.unwrap(this.m_exception);
        if (throwable instanceof CacheException) {
            throw (CacheException)throwable;
        }
        throw new EntryProcessorException(throwable);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_oResult = ExternalizableHelper.readObject((DataInput)in);
        this.m_exception = (Exception)ExternalizableHelper.fromBinary((Binary)new Binary(in));
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_oResult);
        ExternalizableHelper.toBinary((Object)this.m_exception).writeExternal(out);
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_oResult = reader.readObject(0);
        boolean fUseJavaSerialization = reader.readBoolean(1);
        this.m_exception = fUseJavaSerialization ? SerializationHelper.fromByteArray(reader.readByteArray(2), Exception.class) : (Exception)reader.readObject(2);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_oResult);
        boolean fUseJavaSerialization = !(this.m_exception instanceof PortableObject) && !(this.m_exception instanceof ExternalizableLite);
        writer.writeBoolean(1, fUseJavaSerialization);
        if (fUseJavaSerialization) {
            writer.writeByteArray(2, SerializationHelper.toByteArray(this.m_exception));
        } else {
            writer.writeObject(2, (Object)this.m_exception);
        }
    }
}

