/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.coherence.jcache.common.ContextJCacheStatistics;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.Builder;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

public class JCacheContext {
    private final JCacheIdentifier m_id;
    private final CompleteConfiguration m_cfgComplete;
    private AtomicReference<ExpiryPolicy> m_refExpiryPolicy = new AtomicReference();
    private AtomicReference<CacheLoader> m_refCacheLoader = new AtomicReference();
    private AtomicReference<CacheWriter> m_refCacheWriter = new AtomicReference();
    private final JCacheStatistics m_stats;

    protected JCacheContext(JCacheIdentifier id, CompleteConfiguration config) {
        this.m_id = id;
        if (config == null) {
            CacheFactory.log((String)("JCacheContext constructor called with null configuration\nStack Trace: " + Base.printStackTrace((Throwable)new Exception("stack trace"))), (int)2);
            throw new NullPointerException("configuration passed to JCacheContext can not be null");
        }
        this.m_cfgComplete = config;
        this.m_stats = new ContextJCacheStatistics(id);
    }

    public ExpiryPolicy getExpiryPolicy() {
        if (this.m_refExpiryPolicy.get() == null) {
            Factory factory = null;
            if (this.m_cfgComplete == null) {
                throw new NullPointerException("JCacheContext.getExpiryPolicy: configuration unexpectedly is null");
            }
            factory = this.m_cfgComplete.getExpiryPolicyFactory();
            if (factory == null) {
                CacheFactory.log((String)("JcacheContext:getExpiryPolicy: ExpiryPolicyFactory unexpectedly null, using default ExpiryPolicy\n cacheid=" + this.m_id + " configuration=" + this.m_cfgComplete), (int)2);
                throw new NullPointerException("JCacheContext.getExpiryPolicy: factory unexpectedly is null");
            }
            this.m_refExpiryPolicy.compareAndSet(null, (ExpiryPolicy)factory.create());
        }
        return this.m_refExpiryPolicy.get();
    }

    public boolean isReadThrough() {
        return this.m_cfgComplete.isReadThrough();
    }

    public CacheLoader getCacheLoader() {
        if (this.m_refCacheLoader.get() == null) {
            Factory factoryLoader = this.m_cfgComplete.getCacheLoaderFactory();
            if (factoryLoader == null) {
                return null;
            }
            this.m_refCacheLoader.compareAndSet(null, (CacheLoader)factoryLoader.create());
        }
        return this.m_refCacheLoader.get();
    }

    public CacheWriter getCacheWriter() {
        if (this.m_cfgComplete.isWriteThrough() && this.m_refCacheWriter.get() == null) {
            Factory factoryWriter = this.m_cfgComplete.getCacheWriterFactory();
            if (factoryWriter == null) {
                return null;
            }
            this.m_refCacheWriter.compareAndSet(null, (CacheWriter)factoryWriter.create());
        }
        return this.m_refCacheWriter.get();
    }

    public CompleteConfiguration getConfiguration() {
        return this.m_cfgComplete;
    }

    public JCacheStatistics getStatistics() {
        return this.m_stats;
    }

    public static JCacheContext getContext(ResourceRegistry reg, JCacheIdentifier cacheId) {
        return (JCacheContext)reg.getResource(JCacheContext.class, cacheId.getCanonicalCacheName());
    }

    public static JCacheContext getContext(ResourceRegistry reg, JCacheIdentifier cacheId, CompleteConfiguration config) {
        JCacheContext ctx = JCacheContext.getContext(reg, cacheId);
        if (ctx == null) {
            reg.registerResource(JCacheContext.class, cacheId.getCanonicalCacheName(), (Builder)new JCacheContextBuilder(cacheId, config), RegistrationBehavior.IGNORE, null);
            ctx = JCacheContext.getContext(reg, cacheId);
        }
        return ctx;
    }

    public static void unregister(ResourceRegistry reg, JCacheIdentifier cacheId) {
        reg.unregisterResource(JCacheContext.class, cacheId.getCanonicalCacheName());
    }

    static class JCacheContextBuilder
    implements Builder<JCacheContext> {
        private JCacheIdentifier m_id;
        private CompleteConfiguration m_config;

        JCacheContextBuilder(JCacheIdentifier cacheId, CompleteConfiguration config) {
            this.m_id = cacheId;
            this.m_config = config;
        }

        public JCacheContext realize() {
            return new JCacheContext(this.m_id, this.m_config);
        }
    }
}

