/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.tangosol.coherence.config.CacheConfig;
import com.tangosol.coherence.config.CacheMapping;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.ResourceMapping;
import com.tangosol.coherence.config.ResourceMappingRegistry;
import com.tangosol.coherence.config.ServiceSchemeRegistry;
import com.tangosol.coherence.config.builder.AddressProviderBuilder;
import com.tangosol.coherence.config.builder.ListBasedAddressProviderBuilder;
import com.tangosol.coherence.config.scheme.LocalScheme;
import com.tangosol.coherence.config.scheme.RemoteCacheScheme;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.coherence.jcache.common.ContainerHelper;
import com.tangosol.config.ConfigurationException;
import com.tangosol.config.injection.SimpleInjector;
import com.tangosol.config.xml.AbstractNamespaceHandler;
import com.tangosol.config.xml.ProcessingContext;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteCacheServiceDependencies;
import com.tangosol.internal.net.service.peer.initiator.DefaultTcpInitiatorDependencies;
import com.tangosol.internal.net.service.peer.initiator.InitiatorDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ServiceDependencies;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.ResourceResolver;
import java.net.URI;

public class JCacheExtendNamespace
extends AbstractNamespaceHandler {
    public void onEndNamespace(ProcessingContext processingContext, XmlElement xmlElement, String s, URI uri) {
        ServiceScheme schemeService;
        CacheConfig cacheConfig = (CacheConfig)processingContext.getCookie(CacheConfig.class);
        if (cacheConfig == null) {
            throw new ConfigurationException("Can't locate the Coherence Configuration.  This only occurs when the " + uri + " namespace is used outside of a Coherence Cache Configuration", "Please ensure that the " + uri + " is defined with in the scope of a Coherence Cache Configuration");
        }
        ResourceRegistry registryResources = processingContext.getResourceRegistry();
        ServiceSchemeRegistry registryServices = cacheConfig.getServiceSchemeRegistry();
        ResourceMappingRegistry registryCacheMappings = cacheConfig.getMappingRegistry();
        ((InterceptorRegistry)registryResources.getResource(InterceptorRegistry.class)).registerEventInterceptor("jcache-lifecycle-interceptor", (EventInterceptor)new ContainerHelper.JCacheLifecycleInterceptor(), RegistrationBehavior.ALWAYS);
        SimpleInjector injector = new SimpleInjector();
        CacheMapping mapping = registryCacheMappings.findCacheMapping("jcache-configurations");
        if (mapping == null || mapping.usesWildcard()) {
            mapping = new CacheMapping("jcache-configurations", "jcache-extend-tcp");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
        if ((schemeService = registryServices.findSchemeBySchemeName("jcache-extend-tcp")) == null) {
            RemoteCacheScheme schemeRemote = new RemoteCacheScheme();
            schemeRemote.setSchemeName("jcache-extend-tcp");
            schemeRemote.setServiceName("JCacheTCPProxyServiceName");
            DefaultTcpInitiatorDependencies initiatorDependencies = new DefaultTcpInitiatorDependencies();
            String nameserviceAddress = Config.getProperty((String)"coherence.remote.address", (String)"127.0.0.1");
            int clusterport = Config.getInteger((String)"coherence.clusterport", (int)7574);
            CacheFactory.log((String)("JCacheExtendNamespace.onEndNamespace processing: nameservice address and port looked up via system properties:" + nameserviceAddress + ":" + clusterport), (int)3);
            ListBasedAddressProviderBuilder bldr = new ListBasedAddressProviderBuilder().add(nameserviceAddress, clusterport);
            initiatorDependencies.setNameServiceAddressProviderBuilder((AddressProviderBuilder)bldr);
            DefaultRemoteCacheServiceDependencies dependencies = new DefaultRemoteCacheServiceDependencies();
            dependencies.setRemoteServiceName("TCPProxyService");
            dependencies.setInitiatorDependencies((InitiatorDependencies)initiatorDependencies);
            injector.inject((Object)dependencies, (ResourceResolver)registryResources);
            schemeRemote.setServiceDependencies((ServiceDependencies)dependencies);
            injector.inject((Object)schemeRemote, (ResourceResolver)registryResources);
            registryServices.register((ServiceScheme)schemeRemote);
        }
        if ((mapping = registryCacheMappings.findCacheMapping("jcache-partitioned-*")) == null) {
            mapping = new CacheMapping("jcache-partitioned-*", "jcache-extend-tcp");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
        if ((schemeService = registryServices.findSchemeBySchemeName("jcache-local-scheme")) == null) {
            LocalScheme schemeLocal = new LocalScheme();
            schemeLocal.setSchemeName("jcache-local-scheme");
            schemeLocal.setServiceName("jcache-local-service");
            injector.inject((Object)schemeLocal, (ResourceResolver)registryResources);
            registryServices.register((ServiceScheme)schemeLocal);
        }
        if ((mapping = registryCacheMappings.findCacheMapping("jcache-local-*")) == null) {
            mapping = new CacheMapping("jcache-local-*", "jcache-local-scheme");
            registryCacheMappings.register((ResourceMapping)mapping);
        }
    }
}

