/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryEvent;
import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCache;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.MapEvent;
import com.tangosol.util.filter.EntryFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.EventType;

public class PartitionedCacheSyntheticDeleteMapListener<K, V>
extends AbstractMapListener {
    private final String f_description;
    private final PartitionedCache m_cache;

    PartitionedCacheSyntheticDeleteMapListener(String sDescription, PartitionedCache cache) {
        this.f_description = sDescription;
        this.m_cache = cache;
    }

    public void entryUpdated(MapEvent evt) {
        CoherenceCacheEventEventDispatcher<Object, Object> dispatcher = new CoherenceCacheEventEventDispatcher<Object, Object>();
        CoherenceCacheEntryEvent<Object, Object> expiredEntry = new CoherenceCacheEntryEvent<Object, Object>(this.m_cache, EventType.EXPIRED, evt.getKey(), null, evt.getOldValue());
        dispatcher.addEvent(CacheEntryExpiredListener.class, expiredEntry);
        dispatcher.dispatch(this.m_cache.getRegisteredSynchronousEventListeners());
        dispatcher.dispatch(this.m_cache.getRegisteredAsynchronousEventListeners());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " cacheName=" + (this.m_cache == null ? "" : this.m_cache.getName()) + " description=" + this.f_description;
    }

    private static Byte getJCacheSynthetic(BinaryEntry binEntry) {
        assert (binEntry != null);
        BackingMapManagerContext ctx = binEntry.getContext();
        Binary binValue = binEntry.getBinaryValue();
        assert (ctx != null);
        if (binValue == null) {
            return null;
        }
        return BinaryEntryHelper.getJCacheSyntheticKind(binValue, ctx);
    }

    public static class JCacheExpiryEntryFilter<T>
    implements EntryFilter<Object, T>,
    Serializable,
    PortableObject {
        public boolean evaluate(T o) {
            ConverterCollections.ConverterMapEvent cme;
            boolean fResult = false;
            if (o instanceof ConverterCollections.ConverterMapEvent && (cme = (ConverterCollections.ConverterMapEvent)o).getId() == 2) {
                BinaryEntry binEntry = (BinaryEntry)cme.getNewEntry();
                Byte jcacheSyntheticKind = PartitionedCacheSyntheticDeleteMapListener.getJCacheSynthetic(binEntry);
                boolean bl = jcacheSyntheticKind == null ? false : (fResult = BinaryEntryHelper.JCACHE_SYNTHETIC_EXPIRY.equals(jcacheSyntheticKind) || BinaryEntryHelper.JCACHE_SYNTHETIC_EXPIRY_EVENT_FOR_ORIGINAL_VALUES.equals(jcacheSyntheticKind));
                if (fResult) {
                    Logger.fine(() -> "jacheSyntheticKind=" + jcacheSyntheticKind + " event=" + String.valueOf(o));
                }
            }
            return fResult;
        }

        public boolean evaluateEntry(Map.Entry entry) {
            return true;
        }

        public void readExternal(PofReader pofReader) throws IOException {
        }

        public void writeExternal(PofWriter pofWriter) throws IOException {
        }
    }
}

