/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.jcache.AbstractCoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCacheManager;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntry;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryListenerRegistration;
import com.tangosol.coherence.jcache.common.CoherenceCacheMXBean;
import com.tangosol.coherence.jcache.common.InternalConverter;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.common.MBeanServerRegistrationUtility;
import com.tangosol.coherence.jcache.common.SerializingInternalConverter;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheAsynchronousMapListener;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheConfiguration;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheSynchronousMapListener;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCacheSyntheticDeleteMapListener;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedJCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.ClearProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.ConditionalRemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.ConditionalReplaceProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.ContainsKeyProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetAndPutProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetAndRemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetAndReplaceProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetPartitionCountEP;
import com.tangosol.coherence.jcache.partitionedcache.processors.GetProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.InvokeProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.PutAllProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.PutIfAbsentProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.PutProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.RemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.ReplaceProcessor;
import com.tangosol.io.Serializer;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.ResourceRegistry;
import com.tangosol.util.WrapperCollections;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.PartitionedFilter;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.event.CacheEntryListener;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class PartitionedCache<K, V>
extends AbstractCoherenceBasedCache<K, V, PartitionedCacheConfiguration<K, V>> {
    private static final int UNKNOWN_PARTITION_COUNT = -2;
    private final AtomicReference<ExecutorService> m_refExecutorService = new AtomicReference<Object>(null);
    private final CacheLoader<K, V> m_loader;
    private final CacheMXBean m_mxbean;
    private final JCacheStatistics m_stats;
    private final InternalConverter<K> m_converterKey;
    private final InternalConverter<V> m_converterValue;
    private MapListener m_listenerAsynchronous;
    private MapListener m_listenerSynchronous;
    private final Filter m_filterCreateUpdateRemove;
    private MapListener m_listenerExpiryEvent;
    private final Filter m_filterExpiryEvent;
    private final AtomicInteger m_ref_c_partition = new AtomicInteger(-2);
    private AtomicBoolean m_fStats = new AtomicBoolean();
    private final JCacheIdentifier m_cacheId;
    private final CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> m_setListenerRegistrationSynchronous;
    private final CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> m_setListenerRegistrationAsynchronous;

    public PartitionedCache(CoherenceBasedCacheManager manager, String sJCacheName, PartitionedCacheConfiguration<K, V> configuration) {
        super(manager, sJCacheName, configuration);
        this.m_cacheId = new JCacheIdentifier(manager.getURI().toString(), sJCacheName);
        Logger.finest(() -> "PartitionedCache ctor cacheName=" + String.valueOf(this.m_cacheId) + " configuration=" + String.valueOf(configuration));
        this.m_manager.putCacheToConfigurationMapping(this.m_cacheId, configuration);
        this.m_namedCache = PartitionedCache.getNamedCache(manager, this.m_cacheId);
        this.m_stats = new PartitionedJCacheStatistics(this);
        this.m_fStats.set(configuration.isStatisticsEnabled());
        this.m_loader = this.getContext().getCacheLoader();
        this.m_mxbean = new CoherenceCacheMXBean(this);
        ClassLoader classLoader = manager.getClassLoader();
        ConfigurableCacheFactory ccf = manager.getConfigurableCacheFactory();
        ResourceRegistry registryResources = ccf.getResourceRegistry();
        SerializerFactory factorySerializer = (SerializerFactory)registryResources.getResource(SerializerFactory.class, "serializer");
        Serializer serializer = factorySerializer == null ? ExternalizableHelper.ensureSerializer((ClassLoader)classLoader) : factorySerializer.createSerializer(classLoader);
        this.m_converterKey = new SerializingInternalConverter<K>(serializer);
        this.m_converterValue = new SerializingInternalConverter<V>(serializer);
        if (configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
        LinkedList listSynchDef = new LinkedList();
        LinkedList listAsyncDef = new LinkedList();
        Iterable listListenerConfigurations = configuration.getCacheEntryListenerConfigurations();
        for (CacheEntryListenerConfiguration listenerConfiguration : listListenerConfigurations) {
            CoherenceCacheEntryListenerRegistration registration = new CoherenceCacheEntryListenerRegistration(listenerConfiguration);
            if (listenerConfiguration.isSynchronous()) {
                listSynchDef.add(registration);
                continue;
            }
            listAsyncDef.add(registration);
        }
        this.m_setListenerRegistrationSynchronous = new CopyOnWriteArraySet(listSynchDef);
        this.m_setListenerRegistrationAsynchronous = new CopyOnWriteArraySet(listAsyncDef);
        this.m_filterCreateUpdateRemove = new PartitionedCacheAsynchronousMapListener.NonSyntheticEntryFilter();
        this.m_filterExpiryEvent = new PartitionedCacheSyntheticDeleteMapListener.JCacheExpiryEntryFilter();
        this.synchronizeCacheEntryListeners();
    }

    @Override
    public JCacheIdentifier getIdentifier() {
        return this.m_cacheId;
    }

    @Override
    public void destroy() {
        PartitionedCache.destroyCache(this.m_manager, this.m_cacheId, this.m_namedCache);
    }

    public V get(K key) {
        RuntimeException exception = null;
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        V value = null;
        try {
            value = this.m_converterValue.fromInternal(this.m_namedCache.invoke(key, new GetProcessor(this.m_cacheId)));
        }
        catch (Exception e) {
            exception = this.handleException(e, CacheLoaderException.class);
        }
        if (exception != null) {
            throw exception;
        }
        return value;
    }

    public Map<K, V> getAll(Set<? extends K> setKey) {
        this.ensureOpen();
        if (setKey.contains(null)) {
            throw new NullPointerException();
        }
        try {
            return this.m_namedCache.invokeAll(setKey, new GetProcessor(this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheException.class);
        }
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            return (Boolean)this.m_namedCache.invoke(key, (InvocableMap.EntryProcessor)new ContainsKeyProcessor(this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheException.class);
        }
    }

    public void loadAll(final Set<? extends K> setKey, final boolean fReplaceExistingValues, final CompletionListener listener) {
        this.ensureOpen();
        if (setKey == null) {
            throw new NullPointerException("setKey");
        }
        if (this.m_loader == null) {
            if (listener != null) {
                listener.onCompletion();
            }
        } else {
            for (K key : setKey) {
                if (key != null) continue;
                throw new NullPointerException("keys contains a null");
            }
            this.submit(new Runnable(){
                final /* synthetic */ PartitionedCache this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    block5: {
                        try {
                            ArrayList listKeysToLoad = new ArrayList();
                            for (Object key : setKey) {
                                if (!fReplaceExistingValues && this.this$0.containsKey(key)) continue;
                                listKeysToLoad.add(key);
                            }
                            Map mapLoaded = this.this$0.m_loader.loadAll(listKeysToLoad);
                            for (Object key : listKeysToLoad) {
                                if (mapLoaded.get(key) != null) continue;
                                mapLoaded.remove(key);
                            }
                            this.this$0.putAllWithEntryProcessor(mapLoaded, fReplaceExistingValues, false, true);
                            if (listener != null) {
                                listener.onCompletion();
                            }
                        }
                        catch (Exception e) {
                            if (listener == null) break block5;
                            listener.onException((Exception)this.this$0.handleException(e, CacheLoaderException.class));
                        }
                    }
                }
            });
        }
    }

    public void put(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("key parameter");
        }
        if (value == null) {
            throw new NullPointerException("value parameter");
        }
        try {
            Binary binValue = (Binary)this.m_converterValue.toInternal(value);
            this.m_namedCache.invoke(key, new PutProcessor(binValue, this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public V getAndPut(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("key parameter");
        }
        if (value == null) {
            throw new NullPointerException("value parameter");
        }
        try {
            Binary binValue = (Binary)this.m_converterValue.toInternal(value);
            Binary binResult = (Binary)this.m_namedCache.invoke(key, new GetAndPutProcessor(binValue, this.m_cacheId));
            return this.m_converterValue.fromInternal(binResult);
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, true, ((PartitionedCacheConfiguration)this.m_configuration).isWriteThrough());
    }

    public void putAll(Map<? extends K, ? extends V> map, boolean fReplaceExistingValues, boolean fUseWriteThrough) {
        this.ensureOpen();
        if (map == null) {
            throw new NullPointerException();
        }
        this.putAllWithEntryProcessor(map, fReplaceExistingValues, fUseWriteThrough, false);
    }

    public boolean putIfAbsent(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter m_key");
        }
        if (value == null) {
            throw new NullPointerException("parameter m_value");
        }
        try {
            Binary binValue = (Binary)this.m_converterValue.toInternal(value);
            return (Boolean)this.m_namedCache.invoke(key, new PutIfAbsentProcessor(binValue, this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean remove(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            return (Boolean)this.m_namedCache.invoke(key, new RemoveProcessor(this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean remove(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (value == null) {
            throw new NullPointerException("parameter value");
        }
        try {
            Binary binValue = (Binary)this.m_converterValue.toInternal(value);
            return (Boolean)this.m_namedCache.invoke(key, new ConditionalRemoveProcessor(binValue, this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public V getAndRemove(K key) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            return this.m_converterValue.fromInternal(this.m_namedCache.invoke(key, new GetAndRemoveProcessor(this.m_cacheId)));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean replace(K key, V valueOrig, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (valueOrig == null) {
            throw new NullPointerException("parameter valueOrig");
        }
        if (value == null) {
            throw new NullPointerException("parameter newValue");
        }
        try {
            Binary binValueOrig = (Binary)this.m_converterValue.toInternal(valueOrig);
            Binary binValue = (Binary)this.m_converterValue.toInternal(value);
            return (Boolean)this.m_namedCache.invoke(key, new ConditionalReplaceProcessor(binValueOrig, binValue, this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public boolean replace(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (value == null) {
            throw new NullPointerException("parameter value");
        }
        try {
            Object iValue = this.m_converterValue.toInternal(value);
            return (Boolean)this.m_namedCache.invoke(key, new ReplaceProcessor((Binary)iValue, this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public V getAndReplace(K key, V value) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (value == null) {
            throw new NullPointerException("parameter value");
        }
        try {
            Object iValue = this.m_converterValue.toInternal(value);
            return this.m_converterValue.fromInternal(this.m_namedCache.invoke(key, new GetAndReplaceProcessor((Binary)iValue, this.m_cacheId)));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        if (keys.contains(null)) {
            throw new NullPointerException("keys set contains a null");
        }
        try {
            this.m_namedCache.invokeAll(keys, new RemoveProcessor(this.m_cacheId));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void removeAll() {
        this.ensureOpen();
        try {
            this.removeAll(this.m_namedCache.keySet());
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    public void clear() {
        this.ensureOpen();
        Set keys = this.m_namedCache.keySet();
        if (!keys.isEmpty()) {
            int cPartitions = this.getPartitionCount(keys);
            if (cPartitions == -1) {
                this.m_namedCache.invoke((Object)AlwaysFilter.INSTANCE, (InvocableMap.EntryProcessor)ClearProcessor.INSTANCE);
            } else {
                for (int i = 0; i < cPartitions; ++i) {
                    PartitionSet parts = new PartitionSet(cPartitions);
                    parts.add(i);
                    this.m_namedCache.invokeAll((Filter)new PartitionedFilter((Filter)AlwaysFilter.INSTANCE, parts), (InvocableMap.EntryProcessor)ClearProcessor.INSTANCE);
                }
            }
        }
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        if (key == null) {
            throw new NullPointerException("parameter key");
        }
        if (entryProcessor == null) {
            throw new NullPointerException("parameter entryProcessor");
        }
        try {
            EntryProcessorResult result = (EntryProcessorResult)this.m_namedCache.invoke(key, new InvokeProcessor<K, V, T>(this.m_cacheId, entryProcessor, arguments));
            return (T)(result == null ? null : result.get());
        }
        catch (Exception e) {
            throw this.handleException(e, EntryProcessorException.class);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> setKey, EntryProcessor<K, V, T> proc, Object ... arguments) {
        Map result;
        if (setKey == null || proc == null) {
            throw new NullPointerException();
        }
        try {
            result = this.m_namedCache.invokeAll(setKey, new InvokeProcessor<K, V, T>(this.m_cacheId, proc, arguments));
        }
        catch (Exception e) {
            throw this.handleException(e, EntryProcessorException.class);
        }
        return result;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        ((PartitionedCacheConfiguration)this.m_configuration).addCacheEntryListenerConfiguration(config);
        this.createAndAddListenerConfiguration(config);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> config) {
        this.removeListenerConfiguration(config);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new EntryIterator(this.m_namedCache.entrySet().iterator(), this);
    }

    @Override
    public CacheMXBean getMBean() {
        return this.m_mxbean;
    }

    @Override
    public JCacheStatistics getStatistics() {
        return ((PartitionedCacheConfiguration)this.m_configuration).isStatisticsEnabled() ? this.m_stats : null;
    }

    @Override
    public void onBeforeClosing() {
        CacheEntryListener<K, V> listener;
        if (this.m_loader instanceof Closeable) {
            try {
                ((Closeable)this.m_loader).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable CacheLoader: ", (Throwable)e);
            }
        }
        for (CoherenceCacheEntryListenerRegistration<K, V> registration : this.m_setListenerRegistrationAsynchronous) {
            listener = registration.getCacheEntryListener();
            if (!(listener instanceof Closeable)) continue;
            try {
                ((Closeable)listener).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable Asynchronous CacheEntryListener: ", (Throwable)e);
            }
        }
        for (CoherenceCacheEntryListenerRegistration<K, V> registration : this.m_setListenerRegistrationSynchronous) {
            listener = registration.getCacheEntryListener();
            if (!(registration.getCacheEntryListener() instanceof Closeable)) continue;
            try {
                ((Closeable)listener).close();
            }
            catch (IOException e) {
                Logger.fine((String)"Unexpected exception in closable Synchronous CacheEntryListener: ", (Throwable)e);
            }
        }
        if (this.m_listenerSynchronous != null) {
            this.m_namedCache.removeMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove);
        }
        if (this.m_listenerAsynchronous != null) {
            this.m_namedCache.removeMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove);
        }
        this.m_namedCache.removeMapListener(this.m_listenerExpiryEvent, this.m_filterExpiryEvent);
        ExecutorService exeSvc = this.m_refExecutorService.get();
        if (exeSvc != null) {
            exeSvc.shutdown();
            this.m_refExecutorService.compareAndSet(exeSvc, null);
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.m_stats != null && this.m_fStats.get();
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.m_manager.getClassLoader();
    }

    protected void submit(Runnable task) {
        ExecutorService newExeSvc;
        boolean fSetResult;
        if (this.isClosed()) {
            return;
        }
        if (this.m_refExecutorService.get() == null && !(fSetResult = this.m_refExecutorService.compareAndSet(null, newExeSvc = Executors.newFixedThreadPool(20)))) {
            newExeSvc.shutdown();
        }
        this.m_refExecutorService.get().submit(task);
    }

    protected CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> getRegisteredSynchronousEventListeners() {
        return this.m_setListenerRegistrationSynchronous;
    }

    protected CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> getRegisteredAsynchronousEventListeners() {
        return this.m_setListenerRegistrationAsynchronous;
    }

    @Override
    public void setStatisticsEnabled(boolean fEnabled) {
        ((PartitionedCacheConfiguration)this.m_configuration).setStatisticsEnabled(fEnabled);
        this.m_fStats.set(fEnabled);
        if (fEnabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
        }
    }

    @Override
    public void setManagementEnabled(boolean fEnabled) {
        ((PartitionedCacheConfiguration)this.m_configuration).setManagementEnabled(fEnabled);
        if (fEnabled) {
            MBeanServerRegistrationUtility.registerCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        } else {
            MBeanServerRegistrationUtility.unregisterCacheObject(this, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
    }

    public JCacheContext getContext() {
        ResourceRegistry reg = this.m_manager.getConfigurableCacheFactory().getResourceRegistry();
        return JCacheContext.getContext(reg, this.m_cacheId, (CompleteConfiguration)this.m_configuration);
    }

    public static void destroyCache(CoherenceBasedCacheManager mgr, JCacheIdentifier id, NamedCache namedCache) {
        ConfigurableCacheFactory ccf = mgr.getConfigurableCacheFactory();
        mgr.removeCacheToConfigurationMapping(id);
        JCacheContext.unregister(ccf.getResourceRegistry(), id);
        try {
            MBeanServerRegistrationUtility.unregisterCacheObject(mgr, id, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
            MBeanServerRegistrationUtility.unregisterCacheObject(mgr, id, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ccf.destroyCache(namedCache);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void destroyCache(CoherenceBasedCacheManager mgr, JCacheIdentifier id) {
        try {
            MBeanServerRegistrationUtility.unregisterCacheObject(mgr, id, MBeanServerRegistrationUtility.ObjectNameType.Statistics);
            MBeanServerRegistrationUtility.unregisterCacheObject(mgr, id, MBeanServerRegistrationUtility.ObjectNameType.Configuration);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PartitionedCache.destroyCache(mgr, id, PartitionedCache.getNamedCache(mgr, id));
    }

    private void synchronizeCacheEntryListeners() {
        boolean F_LITE = false;
        if (this.m_setListenerRegistrationSynchronous.isEmpty() && this.m_setListenerRegistrationAsynchronous.isEmpty()) {
            if (this.m_listenerExpiryEvent != null) {
                this.m_namedCache.removeMapListener(this.m_listenerExpiryEvent, this.m_filterExpiryEvent);
                this.m_listenerExpiryEvent = null;
            }
        } else if (this.m_listenerExpiryEvent == null) {
            this.m_listenerExpiryEvent = new PartitionedCacheSyntheticDeleteMapListener("coherence-jcache-adapter-expiry-event-listener", this);
            this.m_namedCache.addMapListener(this.m_listenerExpiryEvent, this.m_filterExpiryEvent, F_LITE);
        }
        if (this.m_setListenerRegistrationSynchronous.isEmpty()) {
            if (this.m_listenerSynchronous != null) {
                this.m_namedCache.removeMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove);
                this.m_listenerSynchronous = null;
            }
        } else if (this.m_listenerSynchronous == null) {
            this.m_listenerSynchronous = new PartitionedCacheSynchronousMapListener("coherence-jcache-adapter-synchronous-listener", this);
            this.m_namedCache.addMapListener(this.m_listenerSynchronous, this.m_filterCreateUpdateRemove, F_LITE);
        }
        if (this.m_setListenerRegistrationAsynchronous.isEmpty()) {
            if (this.m_listenerAsynchronous != null) {
                this.m_namedCache.removeMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove);
                this.m_listenerAsynchronous = null;
            }
        } else if (this.m_listenerAsynchronous == null) {
            this.m_listenerAsynchronous = new PartitionedCacheAsynchronousMapListener("coherence-jcache-adapter-asynchronous-listener", this);
            this.m_namedCache.addMapListener(this.m_listenerAsynchronous, this.m_filterCreateUpdateRemove, F_LITE);
        }
    }

    private static NamedCache getNamedCache(CoherenceBasedCacheManager mgr, JCacheIdentifier id) {
        return mgr.getConfigurableCacheFactory().ensureCache("jcache-partitioned-" + id.getCanonicalCacheName(), mgr.getClassLoader());
    }

    private void createAndAddListenerConfiguration(CacheEntryListenerConfiguration<K, V> configuration) {
        CoherenceCacheEntryListenerRegistration<K, V> registration = new CoherenceCacheEntryListenerRegistration<K, V>(configuration);
        if (configuration.isSynchronous()) {
            this.m_setListenerRegistrationSynchronous.add(registration);
        } else {
            this.m_setListenerRegistrationAsynchronous.add(registration);
        }
        this.synchronizeCacheEntryListeners();
    }

    private void removeListenerConfiguration(CacheEntryListenerConfiguration<K, V> configListenerConfiguration) {
        if (configListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CopyOnWriteArraySet<CoherenceCacheEntryListenerRegistration<K, V>> setListeners = configListenerConfiguration.isSynchronous() ? this.m_setListenerRegistrationSynchronous : this.m_setListenerRegistrationAsynchronous;
        for (CoherenceCacheEntryListenerRegistration<K, V> listenerRegistration : setListeners) {
            if (!configListenerConfiguration.equals(listenerRegistration.getConfiguration())) continue;
            setListeners.remove(listenerRegistration);
            ((PartitionedCacheConfiguration)this.m_configuration).getCacheEntryListenerConfigurations().remove(configListenerConfiguration);
        }
        this.synchronizeCacheEntryListeners();
    }

    private void putAllWithEntryProcessor(Map<? extends K, ? extends V> map, boolean fReplaceExistingValues, boolean fUseWriteThrough, boolean fLoadAll) {
        HashMap<Object, Binary> binMap = new HashMap<Object, Binary>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("parameter map had a null key with a value of " + String.valueOf(entry.getValue()));
            }
            if (entry.getValue() == null) {
                throw new NullPointerException("parameter map had a null value for key " + String.valueOf(entry.getKey()));
            }
            Binary bValue = (Binary)this.m_converterValue.toInternal(entry.getValue());
            binMap.put(entry.getKey(), bValue);
        }
        try {
            this.m_namedCache.invokeAll(PutAllProcessor.setOf(binMap), new PutAllProcessor(this.m_cacheId, fReplaceExistingValues, fUseWriteThrough, fLoadAll));
        }
        catch (Exception e) {
            throw this.handleException(e, CacheWriterException.class);
        }
    }

    private <T> Constructor<T> getClassCtor(Class<T> clzz) {
        Class[] argTypes = new Class[]{Throwable.class};
        Constructor<T> result = null;
        try {
            result = clzz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    private <T extends RuntimeException> RuntimeException handleException(Exception exception, Class<T> clzException) {
        Throwable t = exception;
        if (exception instanceof WrapperException && (t = exception.getCause()) instanceof Error) {
            throw (Error)t;
        }
        if (clzException.isInstance(t)) {
            return (RuntimeException)t;
        }
        Constructor<T> ctor = this.getClassCtor(clzException);
        Object[] args = new Object[]{t};
        RuntimeException eResult = null;
        if (ctor != null) {
            try {
                eResult = (RuntimeException)ctor.newInstance(args);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return eResult;
    }

    private int getPartitionCount(Set<K> setKey) {
        if (this.m_ref_c_partition.get() == -2) {
            this.ensureOpen();
            Iterator<K> iter = setKey.iterator();
            if (iter.hasNext()) {
                K key = iter.next();
                int cPartitions = (Integer)this.m_namedCache.invoke(key, (InvocableMap.EntryProcessor)new GetPartitionCountEP());
                this.m_ref_c_partition.compareAndSet(-2, cPartitions);
            }
        }
        return this.m_ref_c_partition.get();
    }

    public String toString() {
        return this.m_sJCacheName;
    }

    public static class EntryIterator<K, V>
    extends WrapperCollections.AbstractWrapperIterator {
        private final PartitionedCache<K, V> m_namedCache;
        private Map.Entry<K, V> m_entryLast = null;
        private Map.Entry<K, V> m_entryNext = null;

        public EntryIterator(Iterator<Map.Entry<K, V>> iter, PartitionedCache<K, V> cache) {
            super(iter);
            this.m_namedCache = cache;
        }

        public boolean hasNext() {
            if (this.m_entryNext == null) {
                this.fetch();
            }
            return this.m_entryNext != null;
        }

        public Cache.Entry<K, V> next() {
            if (this.hasNext()) {
                this.m_entryLast = this.m_entryNext;
                this.m_entryNext = null;
                return new CoherenceCacheEntry<K, V>(this.m_entryLast);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.m_entryLast == null) {
                throw new IllegalStateException("Must progress to the next m_entry to remove");
            }
            this.m_namedCache.remove(this.m_entryLast.getKey());
        }

        private void fetch() {
            while (this.m_entryNext == null && super.hasNext()) {
                Map.Entry entry = (Map.Entry)super.next();
                V value = this.m_namedCache.get(entry.getKey());
                if (value == null) continue;
                this.m_entryNext = entry;
            }
        }
    }
}

