/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.passthroughcache;

import com.tangosol.coherence.jcache.passthroughcache.PassThroughCacheEntryEvent;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.util.Collections;
import javax.cache.Cache;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

public class PassThroughMapListenerAdapter<K, V>
implements MapListener {
    private Cache<K, V> m_cache;
    private CacheEntryListener<? super K, ? super V> m_cacheEntryListener;

    public PassThroughMapListenerAdapter(Cache<K, V> cache, CacheEntryListener<? super K, ? super V> cacheEntryListener) {
        this.m_cache = cache;
        this.m_cacheEntryListener = cacheEntryListener;
    }

    public void entryInserted(MapEvent event) {
        PassThroughCacheEntryEvent<K, V> entryEvent = new PassThroughCacheEntryEvent<K, V>(this.m_cache, EventType.CREATED, event);
        if (this.m_cacheEntryListener instanceof CacheEntryCreatedListener) {
            ((CacheEntryCreatedListener)this.m_cacheEntryListener).onCreated(Collections.singleton(entryEvent));
        }
    }

    public void entryUpdated(MapEvent event) {
        PassThroughCacheEntryEvent<K, V> entryEvent = new PassThroughCacheEntryEvent<K, V>(this.m_cache, EventType.UPDATED, event);
        if (this.m_cacheEntryListener instanceof CacheEntryUpdatedListener) {
            ((CacheEntryUpdatedListener)this.m_cacheEntryListener).onUpdated(Collections.singleton(entryEvent));
        }
    }

    public void entryDeleted(MapEvent event) {
        PassThroughCacheEntryEvent<K, V> entryEvent = new PassThroughCacheEntryEvent<K, V>(this.m_cache, EventType.REMOVED, event);
        if (this.m_cacheEntryListener instanceof CacheEntryRemovedListener) {
            ((CacheEntryRemovedListener)this.m_cacheEntryListener).onRemoved(Collections.singleton(entryEvent));
        }
    }

    public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
        return this.m_cacheEntryListener;
    }
}

