/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache;

import com.tangosol.coherence.jcache.common.CoherenceCacheEntryEvent;
import com.tangosol.coherence.jcache.common.CoherenceCacheEntryListenerRegistration;
import com.tangosol.coherence.jcache.common.CoherenceCacheEventEventDispatcher;
import com.tangosol.coherence.jcache.partitionedcache.PartitionedCache;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.MapEvent;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

public class PartitionedCacheAsynchronousMapListener<K, V>
extends AbstractMapListener {
    protected final String f_sDescription;
    protected final PartitionedCache<K, V> m_cacheSource;

    PartitionedCacheAsynchronousMapListener(String sDescription, PartitionedCache<K, V> cache) {
        this.f_sDescription = sDescription;
        this.m_cacheSource = cache;
    }

    public void entryInserted(MapEvent evt) {
        if (CacheFactory.isLogEnabled((int)6)) {
            CacheFactory.log((String)("entryInserted event entry=" + evt.getKey() + " value=" + evt.getNewValue()), (int)6);
        }
        CoherenceCacheEventEventDispatcher<Object, Object> dispatcher = new CoherenceCacheEventEventDispatcher<Object, Object>();
        CoherenceCacheEntryEvent<Object, Object> createdEntry = new CoherenceCacheEntryEvent<Object, Object>(this.m_cacheSource, EventType.CREATED, evt.getKey(), evt.getNewValue());
        dispatcher.addEvent(CacheEntryCreatedListener.class, createdEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    public void entryUpdated(MapEvent evt) {
        if (CacheFactory.isLogEnabled((int)6)) {
            CacheFactory.log((String)("entryUpdated event entry=" + evt.getKey() + " old value=" + evt.getOldValue() + " new value=" + evt.getNewValue()), (int)6);
        }
        CoherenceCacheEventEventDispatcher<Object, Object> dispatcher = new CoherenceCacheEventEventDispatcher<Object, Object>();
        CoherenceCacheEntryEvent<Object, Object> updatedEntry = new CoherenceCacheEntryEvent<Object, Object>(this.m_cacheSource, EventType.UPDATED, evt.getKey(), evt.getNewValue(), evt.getOldValue());
        dispatcher.addEvent(CacheEntryUpdatedListener.class, updatedEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    public void entryDeleted(MapEvent evt) {
        if (CacheFactory.isLogEnabled((int)6)) {
            CacheFactory.log((String)("entryDeleted event entry=" + evt.getKey() + " value=" + evt.getOldValue()), (int)6);
        }
        CoherenceCacheEventEventDispatcher<Object, Object> dispatcher = new CoherenceCacheEventEventDispatcher<Object, Object>();
        CoherenceCacheEntryEvent<Object, Object> deletedEntry = new CoherenceCacheEntryEvent<Object, Object>(this.m_cacheSource, EventType.REMOVED, evt.getKey(), null, evt.getOldValue());
        dispatcher.addEvent(CacheEntryRemovedListener.class, deletedEntry);
        dispatcher.dispatch(this.getEventListeners());
    }

    protected Iterable<CoherenceCacheEntryListenerRegistration<K, V>> getEventListeners() {
        return this.m_cacheSource.getRegisteredAsynchronousEventListeners();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " cacheName=" + (this.m_cacheSource == null ? "" : this.m_cacheSource.getName()) + " description=" + this.f_sDescription;
    }

    public static class NonSyntheticEntryFilter
    extends com.tangosol.coherence.jcache.common.NonSyntheticEntryFilter {
        @Override
        public boolean isJCacheSynthetic(CacheEvent evt) {
            BinaryEntry binEntry = (BinaryEntry)evt.getNewEntry();
            return BinaryEntryHelper.isJCacheSynthetic(binEntry);
        }
    }
}

