/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.passthroughcache.processors;

import com.tangosol.coherence.jcache.common.CoherenceEntryProcessorResult;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;

public class InvokeProcessor<K, V, T>
extends AbstractProcessor
implements ExternalizableLite,
PortableObject {
    private EntryProcessor<K, V, T> m_processor;
    private Object[] m_arrArguments;

    public InvokeProcessor() {
    }

    public InvokeProcessor(EntryProcessor<K, V, T> processor, Object ... arguments) {
        if (processor == null) {
            throw new NullPointerException("processor can't be null");
        }
        this.m_processor = processor;
        this.m_arrArguments = new Object[arguments.length];
        System.arraycopy(arguments, 0, this.m_arrArguments, 0, arguments.length);
    }

    public Object process(InvocableMap.Entry entry) {
        CoherenceEntryProcessorResult<Object> result;
        InternalEntry internalEntry = new InternalEntry(entry);
        try {
            Object t = this.m_processor.process(internalEntry, this.m_arrArguments);
            result = t == null ? null : new CoherenceEntryProcessorResult<Object>(t);
        }
        catch (Exception e) {
            result = new CoherenceEntryProcessorResult<Object>(e);
        }
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_processor = (EntryProcessor)ExternalizableHelper.readObject((DataInput)in);
        int cArguments = ExternalizableHelper.readInt((DataInput)in);
        InvokeProcessor.azzert((cArguments < 256 ? 1 : 0) != 0, (String)"Unexpected number of arguments.");
        this.m_arrArguments = new Object[cArguments];
        for (int i = 0; i < cArguments; ++i) {
            this.m_arrArguments[i] = ExternalizableHelper.readObject((DataInput)in);
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_processor);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_arrArguments.length);
        for (Object oArgument : this.m_arrArguments) {
            ExternalizableHelper.writeObject((DataOutput)out, (Object)oArgument);
        }
    }

    public void readExternal(PofReader reader) throws IOException {
        this.m_processor = (EntryProcessor)reader.readObject(0);
        int cArguments = reader.readInt(1);
        this.m_arrArguments = new Object[cArguments];
        reader.readObjectArray(2, this.m_arrArguments);
    }

    public void writeExternal(PofWriter writer) throws IOException {
        writer.writeObject(0, this.m_processor);
        writer.writeInt(1, this.m_arrArguments.length);
        writer.writeObjectArray(2, this.m_arrArguments);
    }

    static class InternalEntry<K, V>
    implements MutableEntry<K, V> {
        private InvocableMap.Entry m_entry;

        public InternalEntry(InvocableMap.Entry entry) {
            this.m_entry = entry;
        }

        public boolean exists() {
            return this.m_entry.isPresent();
        }

        public void remove() {
            this.m_entry.remove(false);
        }

        public void setValue(V value) {
            this.m_entry.setValue(value);
        }

        public K getKey() {
            return (K)this.m_entry.getKey();
        }

        public V getValue() {
            return (V)this.m_entry.getValue();
        }

        public <T> T unwrap(Class<T> clz) {
            if (clz != null && clz.isInstance(this.m_entry)) {
                return (T)this.m_entry;
            }
            throw new IllegalArgumentException("Unsupported unwrap(" + clz + ")");
        }
    }
}

