/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.tangosol.coherence.jcache.CoherenceBasedCompleteConfiguration;
import com.tangosol.internal.util.ObjectFormatter;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;

public abstract class AbstractCoherenceBasedCompleteConfiguration<K, V>
implements CoherenceBasedCompleteConfiguration<K, V>,
ExternalizableLite,
PortableObject {
    protected Class<K> m_clzKey;
    protected Class<V> m_clzValue;
    protected List<CacheEntryListenerConfiguration<K, V>> m_listListenerConfigurations;
    protected Factory<CacheLoader<K, V>> m_factoryCacheLoader;
    protected Factory<CacheWriter<? super K, ? super V>> m_factoryCacheWriter;
    protected Factory<ExpiryPolicy> m_factoryExpiryPolicy;
    protected boolean m_fReadThrough;
    protected boolean m_fWriteThrough;
    protected boolean m_fStatisticsEnabled;
    protected boolean m_fStoreByValue;
    protected boolean m_fManagementEnabled;

    public AbstractCoherenceBasedCompleteConfiguration() {
        this.m_clzKey = Object.class;
        this.m_clzValue = Object.class;
        this.m_listListenerConfigurations = new ArrayList<CacheEntryListenerConfiguration<K, V>>();
        this.m_factoryCacheLoader = null;
        this.m_factoryCacheWriter = null;
        this.setExpiryPolicyFactory(null);
        this.m_fReadThrough = false;
        this.m_fWriteThrough = false;
        this.m_fStatisticsEnabled = false;
        this.m_fStoreByValue = true;
        this.m_fManagementEnabled = false;
    }

    public AbstractCoherenceBasedCompleteConfiguration(CompleteConfiguration<K, V> cfgComplete) {
        this.m_clzKey = cfgComplete.getKeyType();
        this.m_clzValue = cfgComplete.getValueType();
        this.m_listListenerConfigurations = new ArrayList<CacheEntryListenerConfiguration<K, V>>();
        for (CacheEntryListenerConfiguration cfgListener : cfgComplete.getCacheEntryListenerConfigurations()) {
            this.addCacheEntryListenerConfiguration(cfgListener);
        }
        this.m_factoryCacheLoader = cfgComplete.getCacheLoaderFactory();
        this.m_factoryCacheWriter = cfgComplete.getCacheWriterFactory();
        this.setExpiryPolicyFactory((Factory<ExpiryPolicy>)cfgComplete.getExpiryPolicyFactory());
        this.m_fReadThrough = cfgComplete.isReadThrough();
        this.m_fWriteThrough = cfgComplete.isWriteThrough();
        this.m_fStatisticsEnabled = cfgComplete.isStatisticsEnabled();
        this.m_fStoreByValue = cfgComplete.isStoreByValue();
        this.m_fManagementEnabled = cfgComplete.isManagementEnabled();
    }

    public Class<K> getKeyType() {
        return this.m_clzKey;
    }

    public Class<V> getValueType() {
        return this.m_clzValue;
    }

    public boolean isStoreByValue() {
        return this.m_fStoreByValue;
    }

    public List<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return this.m_listListenerConfigurations;
    }

    public Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.m_factoryCacheLoader;
    }

    public Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.m_factoryCacheWriter;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.m_factoryExpiryPolicy;
    }

    public boolean isReadThrough() {
        return this.m_fReadThrough;
    }

    public boolean isWriteThrough() {
        return this.m_fWriteThrough;
    }

    public boolean isStatisticsEnabled() {
        return this.m_fStatisticsEnabled;
    }

    public boolean isManagementEnabled() {
        return this.m_fManagementEnabled;
    }

    @Override
    public void setTypes(Class<K> clzKey, Class<V> clzValue) {
        if (clzKey == null || clzValue == null) {
            throw new NullPointerException("The key and/or value type can't be null");
        }
        this.m_clzKey = clzKey;
        this.m_clzValue = clzValue;
    }

    @Override
    public void addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cfgListener) {
        if (cfgListener == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        if (this.m_listListenerConfigurations.contains(cfgListener)) {
            throw new IllegalArgumentException("A CacheEntryListenerConfiguration can be registered only once");
        }
        this.m_listListenerConfigurations.add(cfgListener);
    }

    @Override
    public void setCacheLoaderFactory(Factory<? extends CacheLoader<K, V>> factory) {
        this.m_factoryCacheLoader = factory;
    }

    @Override
    public void setCacheWriterFactory(Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        this.m_factoryCacheWriter = factory;
    }

    @Override
    public void setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
        this.m_factoryExpiryPolicy = factory == null ? EternalExpiryPolicy.factoryOf() : factory;
    }

    @Override
    public void setReadThrough(boolean fReadThrough) {
        this.m_fReadThrough = fReadThrough;
    }

    @Override
    public void setWriteThrough(boolean fWriteThrough) {
        this.m_fWriteThrough = fWriteThrough;
    }

    @Override
    public void setStoreByValue(boolean fStoreByValue) {
        this.m_fStoreByValue = fStoreByValue;
    }

    @Override
    public void setStatisticsEnabled(boolean fStatisticsEnabled) {
        this.m_fStatisticsEnabled = fStatisticsEnabled;
    }

    @Override
    public void setManagementEnabled(boolean fManagementEnabled) {
        this.m_fManagementEnabled = fManagementEnabled;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_clzKey.hashCode();
        result = 31 * result + this.m_clzValue.hashCode();
        result = 31 * result + (this.m_listListenerConfigurations == null ? 0 : this.m_listListenerConfigurations.hashCode());
        result = 31 * result + (this.m_factoryCacheLoader == null ? 0 : this.m_factoryCacheLoader.hashCode());
        result = 31 * result + (this.m_factoryCacheWriter == null ? 0 : this.m_factoryCacheWriter.hashCode());
        result = 31 * result + (this.m_factoryExpiryPolicy == null ? 0 : this.m_factoryExpiryPolicy.hashCode());
        result = 31 * result + (this.m_fReadThrough ? 1231 : 1237);
        result = 31 * result + (this.m_fStatisticsEnabled ? 1231 : 1237);
        result = 31 * result + (this.m_fStoreByValue ? 1231 : 1237);
        result = 31 * result + (this.m_fWriteThrough ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractCoherenceBasedCompleteConfiguration)) {
            return false;
        }
        AbstractCoherenceBasedCompleteConfiguration other = (AbstractCoherenceBasedCompleteConfiguration)object;
        if (!this.m_clzKey.equals(other.m_clzKey)) {
            return false;
        }
        if (!this.m_clzValue.equals(other.m_clzValue)) {
            return false;
        }
        if (this.m_listListenerConfigurations == null ? other.m_listListenerConfigurations != null : !this.m_listListenerConfigurations.equals(other.m_listListenerConfigurations)) {
            return false;
        }
        if (this.m_factoryCacheLoader == null ? other.m_factoryCacheLoader != null : !this.m_factoryCacheLoader.equals(other.m_factoryCacheLoader)) {
            return false;
        }
        if (this.m_factoryCacheWriter == null ? other.m_factoryCacheWriter != null : !this.m_factoryCacheWriter.equals(other.m_factoryCacheWriter)) {
            return false;
        }
        if (this.m_factoryExpiryPolicy == null ? other.m_factoryExpiryPolicy != null : !this.m_factoryExpiryPolicy.equals(other.m_factoryExpiryPolicy)) {
            return false;
        }
        if (this.m_fReadThrough != other.m_fReadThrough) {
            return false;
        }
        if (this.m_fStatisticsEnabled != other.m_fStatisticsEnabled) {
            return false;
        }
        if (this.m_fStoreByValue != other.m_fStoreByValue) {
            return false;
        }
        return this.m_fWriteThrough == other.m_fWriteThrough;
    }

    public String toString() {
        return new ObjectFormatter().format(this.getClass().getCanonicalName(), (Object)this);
    }

    private Class loadClass(ClassLoader loader, String className, String description) {
        Class result = Object.class;
        if (className != null) {
            try {
                result = loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                CacheFactory.log((String)(description + " not found: " + className), (int)2);
            }
        }
        return result;
    }

    public void readExternal(DataInput in) throws IOException {
        ClassLoader loader = Base.getContextClassLoader();
        String className = ExternalizableHelper.readUTF((DataInput)in);
        this.m_clzKey = this.loadClass(loader, className, "keyClass");
        className = ExternalizableHelper.readUTF((DataInput)in);
        this.m_clzValue = this.loadClass(loader, className, "valueClass");
        ExternalizableHelper.readCollection((DataInput)in, this.m_listListenerConfigurations, (ClassLoader)loader);
        this.m_factoryCacheLoader = (Factory)ExternalizableHelper.readObject((DataInput)in);
        this.m_factoryCacheWriter = (Factory)ExternalizableHelper.readObject((DataInput)in);
        this.setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)ExternalizableHelper.readObject((DataInput)in)));
        this.m_fReadThrough = in.readBoolean();
        this.m_fWriteThrough = in.readBoolean();
        this.m_fStatisticsEnabled = in.readBoolean();
        this.m_fStoreByValue = in.readBoolean();
        this.m_fManagementEnabled = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_clzKey.getCanonicalName());
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_clzValue.getCanonicalName());
        ExternalizableHelper.writeCollection((DataOutput)out, this.m_listListenerConfigurations);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_factoryCacheLoader);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_factoryCacheWriter);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_factoryExpiryPolicy);
        out.writeBoolean(this.m_fReadThrough);
        out.writeBoolean(this.m_fWriteThrough);
        out.writeBoolean(this.m_fStatisticsEnabled);
        out.writeBoolean(this.m_fStoreByValue);
        out.writeBoolean(this.m_fManagementEnabled);
    }

    public void readExternal(PofReader in) throws IOException {
        try {
            ClassLoader loader = Base.getContextClassLoader();
            String keyClassName = in.readString(0);
            this.m_clzKey = this.loadClass(loader, keyClassName, "keyClass");
            String valueClassName = in.readString(1);
            this.m_clzValue = this.loadClass(loader, valueClassName, "valueClass");
            in.readCollection(2, this.m_listListenerConfigurations);
            this.m_factoryCacheLoader = (Factory)in.readObject(3);
            this.m_factoryCacheWriter = (Factory)in.readObject(4);
            this.setExpiryPolicyFactory((Factory<ExpiryPolicy>)((Factory)in.readObject(5)));
            this.m_fReadThrough = in.readBoolean(6);
            this.m_fWriteThrough = in.readBoolean(7);
            this.m_fStatisticsEnabled = in.readBoolean(8);
            this.m_fStoreByValue = in.readBoolean(9);
            this.m_fManagementEnabled = in.readBoolean(10);
        }
        catch (Throwable e) {
            CacheFactory.log((String)("handled unexpected exception in " + this.getClass().getCanonicalName() + ".readExternal config=\n" + this + "\nstack trace: \n" + Base.printStackTrace((Throwable)e)), (int)2);
            throw e;
        }
    }

    public void writeExternal(PofWriter out) throws IOException {
        try {
            out.writeString(0, this.m_clzKey.getCanonicalName());
            out.writeString(1, this.m_clzValue.getCanonicalName());
            out.writeCollection(2, this.m_listListenerConfigurations);
            out.writeObject(3, this.m_factoryCacheLoader);
            out.writeObject(4, this.m_factoryCacheWriter);
            out.writeObject(5, this.m_factoryExpiryPolicy);
            out.writeBoolean(6, this.m_fReadThrough);
            out.writeBoolean(7, this.m_fWriteThrough);
            out.writeBoolean(8, this.m_fStatisticsEnabled);
            out.writeBoolean(9, this.m_fStoreByValue);
            out.writeBoolean(10, this.m_fManagementEnabled);
        }
        catch (Throwable e) {
            CacheFactory.log((String)("handled unexpected exception in " + this.getClass().getCanonicalName() + ".writeExternal config=\n" + this + "\nstack trace: \n" + Base.printStackTrace((Throwable)e)), (int)2);
            throw e;
        }
    }
}

