/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache;

import com.oracle.coherence.common.base.Disposable;
import com.tangosol.coherence.jcache.AbstractCoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCache;
import com.tangosol.coherence.jcache.CoherenceBasedCachingProvider;
import com.tangosol.coherence.jcache.CoherenceBasedCompleteConfiguration;
import com.tangosol.coherence.jcache.CoherenceBasedConfiguration;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.localcache.LocalCache;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import com.tangosol.util.Builder;
import com.tangosol.util.RegistrationBehavior;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;

public class CoherenceBasedCacheManager
implements CacheManager,
Disposable {
    private final ConcurrentHashMap<String, CoherenceBasedCache<?, ?>> m_mapNameToJCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, WeakReference<CoherenceBasedCache<?, ?>>> m_closedMapNameToJCache = new ConcurrentHashMap();
    private final CoherenceBasedCachingProvider m_provider;
    private final URI m_uri;
    private final WeakReference<ClassLoader> m_refClassLoader;
    private final Properties m_properties;
    private ConfigurableCacheFactory m_ccf;
    private volatile boolean m_fClosed = false;
    private String m_sResourceName;

    public CoherenceBasedCacheManager(CoherenceBasedCachingProvider provider, ConfigurableCacheFactory ccf, URI uri, ClassLoader classLoader, Properties properties) {
        if (provider == null) {
            throw new NullPointerException("No CachingProvider specified");
        }
        if (ccf == null) {
            throw new NullPointerException("No Configurable Cache Factory specified");
        }
        if (classLoader == null) {
            throw new NullPointerException("No ClassLoader specified");
        }
        this.m_provider = provider;
        this.m_ccf = ccf;
        this.m_uri = uri;
        this.m_refClassLoader = new WeakReference<ClassLoader>(classLoader);
        this.m_properties = properties == null ? new Properties() : (Properties)properties.clone();
        this.m_fClosed = false;
        if (ccf instanceof ExtensibleConfigurableCacheFactory) {
            final CoherenceBasedCacheManager thisOne = this;
            Builder<CacheManager> bldr = new Builder<CacheManager>(){

                public CacheManager realize() {
                    return thisOne;
                }
            };
            this.m_sResourceName = ccf.getResourceRegistry().registerResource(CacheManager.class, (Builder)bldr, RegistrationBehavior.ALWAYS, null);
        }
    }

    public CoherenceBasedCompleteConfiguration getCacheToConfigurationMapping(JCacheIdentifier cacheId) {
        return (CoherenceBasedCompleteConfiguration)this.getConfigurationCache().get((Object)cacheId.getCanonicalCacheName());
    }

    public void putCacheToConfigurationMapping(JCacheIdentifier cacheId, CoherenceBasedCompleteConfiguration config) {
        CoherenceBasedCompleteConfiguration existingConfig = this.getCacheToConfigurationMapping(cacheId);
        if (existingConfig != null && !existingConfig.equals(config)) {
            throw new IllegalStateException("CacheCreationFailure: Failed to create cache named " + cacheId.getCanonicalCacheName() + " with configuration: " + config + "\nA cache with that name already exists with the different configuration: " + existingConfig);
        }
        this.getConfigurationCache().put((Object)cacheId.getCanonicalCacheName(), (Object)config);
    }

    public void removeCacheToConfigurationMapping(JCacheIdentifier cacheId) {
        this.getConfigurationCache().remove((Object)cacheId.getCanonicalCacheName());
    }

    private NamedCache getConfigurationCache() {
        ClassLoader loader = null;
        return this.m_ccf.ensureCache("jcache-configurations", loader);
    }

    public CachingProvider getCachingProvider() {
        return this.m_provider;
    }

    public URI getURI() {
        return this.m_uri;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.m_refClassLoader.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String sJCacheName, C cfgJCache) throws IllegalArgumentException {
        this.ensureOpen();
        if (sJCacheName == null) {
            throw new NullPointerException("cacheName must not be null");
        }
        if (cfgJCache == null) {
            throw new NullPointerException("config must not be null");
        }
        if (cfgJCache instanceof CoherenceBasedConfiguration) {
            CoherenceBasedCacheManager coherenceBasedCacheManager = this;
            synchronized (coherenceBasedCacheManager) {
                CoherenceBasedCache cacheCreated;
                CoherenceBasedConfiguration cfgCoherence = (CoherenceBasedConfiguration)cfgJCache;
                CoherenceBasedCache<Object, Object> cache = this.m_mapNameToJCache.get(sJCacheName);
                if (cache == null && (cache = this.m_mapNameToJCache.putIfAbsent(sJCacheName, cacheCreated = cfgCoherence.createCache(this, sJCacheName))) == null) {
                    return cacheCreated;
                }
            }
        } else {
            if (cfgJCache instanceof Configuration) {
                CoherenceBasedConfiguration cfgCoherence = this.m_provider.convertConfiguration(cfgJCache, this.getClassLoader());
                return this.createCache(sJCacheName, cfgCoherence);
            }
            throw new CacheException("Cache creation failed due to unknown Configuration type: " + cfgJCache.getClass().getName());
        }
        throw new CacheException("A cache named " + sJCacheName + " already exists.");
    }

    public <K, V> Cache<K, V> getCache(String sJCacheName, Class<K> clzKey, Class<V> clzType) {
        CoherenceBasedCompleteConfiguration configuration;
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (clzKey == null) {
            throw new NullPointerException("clzKey can not be null");
        }
        if (clzType == null) {
            throw new NullPointerException("clzType can not be null");
        }
        Cache<K, V> cache = this.m_mapNameToJCache.get(sJCacheName);
        CoherenceBasedCompleteConfiguration coherenceBasedCompleteConfiguration = configuration = cache == null ? this.getCacheToConfigurationMapping(new JCacheIdentifier(this.getURI().toString(), sJCacheName)) : cache.getConfiguration(Configuration.class);
        if (cache == null) {
            if (configuration == null) {
                return null;
            }
            cache = this.createCache(sJCacheName, configuration);
        }
        if (configuration.getKeyType() != null && configuration.getKeyType().equals(clzKey)) {
            if (configuration.getValueType() != null && configuration.getValueType().equals(clzType)) {
                return cache;
            }
            throw new ClassCastException("Incompatible cache value types specified, expected " + configuration.getValueType() + " but " + clzType + " was specified");
        }
        throw new ClassCastException("Incompatible cache key types specified, expected " + configuration.getKeyType() + " but " + clzKey + " was specified");
    }

    public Cache getCache(String sJCacheName) {
        return this.getCacheInternal(sJCacheName, false);
    }

    public Iterable<String> getCacheNames() {
        this.ensureOpen();
        return Collections.unmodifiableSet(new TreeSet(this.m_mapNameToJCache.keySet()));
    }

    public void destroyCache(String sName) {
        this.ensureOpen();
        if (sName == null) {
            throw new NullPointerException();
        }
        CoherenceBasedCache<?, ?> cache = this.m_mapNameToJCache.remove(sName);
        if (cache == null) {
            WeakReference<CoherenceBasedCache<?, ?>> refCache = this.m_closedMapNameToJCache.remove(sName);
            CoherenceBasedCache<?, ?> coherenceBasedCache = cache = refCache == null ? null : (CoherenceBasedCache<?, ?>)refCache.get();
        }
        if (cache == null) {
            JCacheIdentifier id = new JCacheIdentifier(this.getURI().toString(), sName);
            CoherenceBasedCompleteConfiguration config = this.getCacheToConfigurationMapping(id);
            if (config != null) {
                config.destroyCache(this, sName);
            }
        } else {
            cache.close();
            cache.destroy();
        }
    }

    public void enableStatistics(String sName, boolean fEnabled) {
        this.ensureOpen();
        if (sName == null) {
            throw new NullPointerException();
        }
        AbstractCoherenceBasedCache cache = (AbstractCoherenceBasedCache)this.getCacheInternal(sName, false);
        if (cache == null) {
            throw new CacheException("no cache named " + sName);
        }
        cache.setStatisticsEnabled(fEnabled);
    }

    public void enableManagement(String sName, boolean fEnabled) {
        this.ensureOpen();
        if (sName == null) {
            throw new NullPointerException();
        }
        AbstractCoherenceBasedCache cache = (AbstractCoherenceBasedCache)this.getCacheInternal(sName, false);
        if (cache == null) {
            throw new CacheException("no cache named " + sName);
        }
        cache.setManagementEnabled(fEnabled);
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.m_fClosed = true;
        this.m_provider.release(this.getClassLoader(), this.getURI());
        ArrayList cacheList = new ArrayList(this.m_mapNameToJCache.values());
        this.m_mapNameToJCache.clear();
        for (Cache cache : cacheList) {
            try {
                cache.close();
            }
            catch (Exception e) {
                CacheFactory.log((String)("Error stopping cache " + cache + ": " + Base.printStackTrace((Throwable)e)), (int)2);
            }
        }
        this.m_ccf.getResourceRegistry().unregisterResource(CacheManager.class, this.m_sResourceName);
        if (this.m_ccf.getResourceRegistry().getResource(CacheManager.class) == null) {
            CacheFactory.getCacheFactoryBuilder().release(this.m_ccf);
            this.m_ccf.dispose();
        }
        this.m_ccf = null;
    }

    public void dispose() {
        if (!this.isClosed()) {
            this.close();
        }
    }

    public boolean isClosed() {
        return this.m_fClosed;
    }

    public <T> T unwrap(Class<T> clz) {
        if (clz != null && clz.isInstance(this.m_ccf)) {
            return (T)this.m_ccf;
        }
        if (clz != null && clz.isInstance(this)) {
            return (T)this;
        }
        throw new IllegalArgumentException("Unsupported unwrap(" + clz + ")");
    }

    private <K, V> Cache<K, V> getCacheInternal(String sName, boolean fTypeCheck) {
        CoherenceBasedCompleteConfiguration configuration;
        this.ensureOpen();
        Cache<K, V> cache = this.m_mapNameToJCache.get(sName);
        CoherenceBasedCompleteConfiguration coherenceBasedCompleteConfiguration = configuration = cache == null ? this.getCacheToConfigurationMapping(new JCacheIdentifier(this.getURI().toString(), sName)) : cache.getConfiguration(Configuration.class);
        if (cache == null) {
            if (configuration == null) {
                return null;
            }
            cache = this.createCache(sName, configuration);
        }
        if (!fTypeCheck || configuration.getKeyType().equals(Object.class) && configuration.getValueType().equals(Object.class)) {
            return cache;
        }
        throw new IllegalArgumentException("Cache " + sName + " was defined with specific types Cache<" + configuration.getKeyType() + ", " + configuration.getValueType() + "> in which case CacheManager.getCache(String, Class, Class) must be used");
    }

    private void ensureOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
    }

    public ConfigurableCacheFactory getConfigurableCacheFactory() {
        this.ensureOpen();
        return this.m_ccf;
    }

    public void releaseCache(String sName) {
        CoherenceBasedCache<?, ?> closedCache = this.m_mapNameToJCache.remove(sName);
        if (closedCache != null) {
            this.m_closedMapNameToJCache.put(sName, new WeakReference(closedCache));
        }
    }

    public boolean validate() {
        boolean result = true;
        if (this.m_mapNameToJCache.size() > 0) {
            for (Map.Entry<String, CoherenceBasedCache<?, ?>> entry : this.m_mapNameToJCache.entrySet()) {
                CoherenceBasedCache<?, ?> cache = entry.getValue();
                if (cache instanceof LocalCache) continue;
                JCacheIdentifier cacheId = cache.getIdentifier();
                CoherenceBasedCompleteConfiguration config = this.getCacheToConfigurationMapping(cacheId);
                if (config == null) {
                    result = false;
                    CacheFactory.log((String)("CoherenceBasedCacheManager.validate failed.  No mapping for JCache " + cacheId + " in meta mapping of jcacheId to configuration."), (int)2);
                    break;
                }
                if (config.equals(cache.getConfiguration(CompleteConfiguration.class))) continue;
                result = false;
                CoherenceBasedCompleteConfiguration inMemoryConfiguration = (CoherenceBasedCompleteConfiguration)cache.getConfiguration(CoherenceBasedCompleteConfiguration.class);
                CacheFactory.log((String)("CoherenceBasedCacheManager.validate failed due to differing Configurations. JCache " + cacheId + "\nInMemory Configuration is:\n" + inMemoryConfiguration + "\n replicated meta cache configuration is:\n" + config), (int)2);
                break;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CoherenceBasedCacheManager uri=").append(this.m_uri).append(" clzLdr=").append(this.getClassLoader()).append(" eccf=").append(this.getConfigurableCacheFactory()).append(" isclosed=").append(this.isClosed());
        return sb.toString();
    }
}

