/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JCacheIdentifier
implements ExternalizableLite,
PortableObject {
    private static final Character URI_NAME_SEPARATOR = Character.valueOf('$');
    private String m_sCacheMgrURI;
    private String m_sCacheName;

    public JCacheIdentifier() {
    }

    public JCacheIdentifier(String sCanonicalCacheName) {
        String DELIMITER = "[" + URI_NAME_SEPARATOR + "]+";
        String PREFIXES = "(jcache-partitioned-|jcache-local-)";
        String cacheNamePrefixStripped = sCanonicalCacheName.replaceAll("(jcache-partitioned-|jcache-local-)", "");
        String[] tokens = cacheNamePrefixStripped.split(DELIMITER);
        if (tokens.length != 2) {
            throw new IllegalAccessError("expected form of \"CacheManagerURI" + URI_NAME_SEPARATOR + "cacheName\" for parameter sCanonicalCacheName, it had this invalid value instead " + sCanonicalCacheName);
        }
        this.m_sCacheMgrURI = tokens[0];
        this.m_sCacheName = tokens[1];
    }

    public JCacheIdentifier(String sMgrUri, String sCacheName) {
        this.m_sCacheMgrURI = sMgrUri;
        this.m_sCacheName = sCacheName;
    }

    public String getName() {
        return this.m_sCacheName;
    }

    public String getCacheManagerURI() {
        return this.m_sCacheMgrURI;
    }

    public String getCanonicalCacheName() {
        return this.m_sCacheMgrURI + URI_NAME_SEPARATOR + this.m_sCacheName;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JCacheIdentifier)) {
            return false;
        }
        JCacheIdentifier id = (JCacheIdentifier)o;
        return this.m_sCacheMgrURI.equals(id.m_sCacheMgrURI) && this.m_sCacheName.equals(this.m_sCacheName);
    }

    public int hashCode() {
        return this.m_sCacheMgrURI.hashCode() + this.m_sCacheName.hashCode();
    }

    public String toString() {
        return this.getCanonicalCacheName();
    }

    public void readExternal(PofReader pofReader) throws IOException {
        this.m_sCacheMgrURI = pofReader.readString(0);
        this.m_sCacheName = pofReader.readString(1);
    }

    public void writeExternal(PofWriter pofWriter) throws IOException {
        pofWriter.writeObject(0, (Object)this.m_sCacheMgrURI);
        pofWriter.writeObject(1, (Object)this.m_sCacheName);
    }

    public void readExternal(DataInput dataInput) throws IOException {
        this.m_sCacheMgrURI = dataInput.readUTF();
        this.m_sCacheName = dataInput.readUTF();
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.m_sCacheMgrURI);
        dataOutput.writeUTF(this.m_sCacheName);
    }
}

