/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.common;

import java.util.concurrent.atomic.AtomicReference;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;

public class CoherenceCacheEntryListenerRegistration<K, V> {
    private final CacheEntryListenerConfiguration<K, V> m_configuration;
    private final AtomicReference<CacheEntryListener<? super K, ? super V>> m_refListener = new AtomicReference();
    private final AtomicReference<CacheEntryEventFilter<? super K, ? super V>> m_refFilter = new AtomicReference();

    public CoherenceCacheEntryListenerRegistration(CacheEntryListenerConfiguration<K, V> configuration) {
        this.m_configuration = configuration;
    }

    public CacheEntryEventFilter<? super K, ? super V> getCacheEntryFilter() {
        Factory factoryEventFilter = this.m_configuration.getCacheEntryEventFilterFactory();
        if (this.m_refFilter.get() == null && factoryEventFilter != null) {
            this.m_refFilter.compareAndSet((CacheEntryEventFilter<K, Object>)null, (CacheEntryEventFilter<K, Object>)factoryEventFilter.create());
        }
        return this.m_refFilter.get();
    }

    public CacheEntryListener<? super K, ? super V> getCacheEntryListener() {
        Factory factoryEventListener = this.m_configuration.getCacheEntryListenerFactory();
        if (this.m_refListener.get() == null && factoryEventListener != null) {
            this.m_refListener.compareAndSet((CacheEntryListener<K, Object>)null, (CacheEntryListener<K, Object>)factoryEventListener.create());
        }
        return this.m_refListener.get();
    }

    public CacheEntryListenerConfiguration<K, V> getConfiguration() {
        return this.m_configuration;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CoherenceCacheEntryListenerRegistration)) {
            return false;
        }
        CoherenceCacheEntryListenerRegistration other = (CoherenceCacheEntryListenerRegistration)object;
        if (this.getCacheEntryFilter() == null ? other.getCacheEntryFilter() != null : !this.getCacheEntryFilter().equals(other.getCacheEntryFilter())) {
            return false;
        }
        if (this.m_configuration.isOldValueRequired() != other.getConfiguration().isOldValueRequired()) {
            return false;
        }
        if (this.m_configuration.isSynchronous() != other.getConfiguration().isSynchronous()) {
            return false;
        }
        return !(this.getCacheEntryListener() == null ? other.getCacheEntryListener() != null : !this.getCacheEntryListener().equals(other.getCacheEntryListener()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getCacheEntryFilter() == null ? 0 : this.getCacheEntryFilter().hashCode());
        result = 31 * result + (this.m_configuration.isOldValueRequired() ? 1231 : 1237);
        result = 31 * result + (this.m_configuration.isSynchronous() ? 1231 : 1237);
        result = 31 * result + (this.getCacheEntryListener() == null ? 0 : this.getCacheEntryListener().hashCode());
        return result;
    }
}

