/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheContext;
import com.tangosol.coherence.jcache.common.JCacheEntryMetaInf;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.common.JCacheStatistics;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractEntryProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.GuardSupport;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.LiteMap;
import java.util.Map;
import java.util.Set;

public class GetProcessor<K>
extends AbstractEntryProcessor {
    public GetProcessor() {
    }

    public GetProcessor(JCacheIdentifier id) {
        super(id);
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtStart = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = entry instanceof BinaryEntry ? (BinaryEntry)entry : null;
        boolean fBinEntryOrigPresent = binEntry != null && binEntry.isPresent();
        JCacheContext jcacheCtx = BinaryEntryHelper.getContext(this.m_cacheId, binEntry);
        JCacheStatistics stats = jcacheCtx.getStatistics();
        Binary binValue = binEntry.getBinaryValue();
        if (binEntry.isPresent()) {
            BackingMapManagerContext ctx = binEntry.getContext();
            JCacheEntryMetaInf valueMetaInf = BinaryEntryHelper.getValueMetaInf(binEntry);
            if (BinaryEntryHelper.isExpired(binEntry, valueMetaInf, ldtStart)) {
                BinaryEntryHelper.expireEntry(binEntry);
                if (BinaryEntryHelper.getContext(this.m_cacheId, binEntry).isReadThrough()) {
                    Object oValue = BinaryEntryHelper.getContext(this.m_cacheId, binEntry).getCacheLoader().load(binEntry.getKey());
                    if (oValue != null) {
                        binValue = (Binary)binEntry.getContext().getValueToInternalConverter().convert(oValue);
                    }
                    valueMetaInf = new JCacheEntryMetaInf(ldtStart, jcacheCtx.getExpiryPolicy());
                    if (binValue == null || BinaryEntryHelper.isExpired(ctx, binValue, valueMetaInf, ldtStart)) {
                        stats.registerMisses(1, ldtStart);
                        return null;
                    }
                } else {
                    stats.registerMisses(1, ldtStart);
                    return null;
                }
            }
            assert (valueMetaInf != null);
            valueMetaInf.accessed(ldtStart, jcacheCtx.getExpiryPolicy());
            binValue = BinaryEntryHelper.decorateBinValueWithJCacheMetaInf(binValue, valueMetaInf, ctx);
            binValue = BinaryEntryHelper.jcacheSyntheticUpdateEntry(binValue, ctx);
            binEntry.updateBinaryValue(binValue);
            if (fBinEntryOrigPresent) {
                stats.registerHits(1, ldtStart);
            } else {
                stats.registerMisses(1, ldtStart);
            }
        } else {
            stats.registerMisses(1, ldtStart);
        }
        return binValue;
    }

    public Map processAll(Set setEntries) {
        LiteMap mapResults = new LiteMap();
        for (Object entry : setEntries) {
            GuardSupport.heartbeat();
            BinaryEntry bEntry = (BinaryEntry)entry;
            Binary binValue = (Binary)this.process((InvocableMap.Entry)bEntry);
            if (binValue == null) continue;
            mapResults.put(bEntry.getKey(), binValue);
        }
        return mapResults;
    }
}

