/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.jcache.partitionedcache.processors;

import com.tangosol.coherence.jcache.common.Helper;
import com.tangosol.coherence.jcache.common.JCacheIdentifier;
import com.tangosol.coherence.jcache.partitionedcache.processors.AbstractRemoveProcessor;
import com.tangosol.coherence.jcache.partitionedcache.processors.BinaryEntryHelper;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;

public class RemoveProcessor<K, V>
extends AbstractRemoveProcessor<K, V> {
    public RemoveProcessor() {
        super(null);
    }

    public RemoveProcessor(JCacheIdentifier id) {
        super(id);
    }

    public Object process(InvocableMap.Entry entry) {
        long ldtStart = Helper.getCurrentTimeMillis();
        BinaryEntry binEntry = (BinaryEntry)entry;
        Boolean fResult = Boolean.FALSE;
        if (binEntry.isPresent()) {
            boolean syntheticRemove = BinaryEntryHelper.isExpired(binEntry, ldtStart);
            if (syntheticRemove) {
                BinaryEntryHelper.expireEntry(binEntry);
                this.deleteCacheEntry(binEntry);
            } else {
                entry.remove(false);
                BinaryEntryHelper.getContext(this.m_cacheId, binEntry).getStatistics().registerRemoves(1L, ldtStart);
                fResult = Boolean.TRUE;
            }
        } else {
            this.deleteCacheEntry(binEntry);
        }
        return fResult;
    }
}

