/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.client;

import com.oracle.coherence.client.ChannelProviders;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.config.ConfigurationException;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.io.Serializer;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.util.Resources;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettySslContextChannelCredentials;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import javax.net.ssl.SSLException;

public interface GrpcSessionConfiguration
extends SessionConfiguration {
    public static final int DEFAULT_PRIORITY = -1;
    public static final String DEFAULT_HOST = "localhost";
    public static final String PROP_HOST = "coherence.grpc.channels.%s.host";
    public static final String PROP_PORT = "coherence.grpc.channels.%s.port";
    public static final String PROP_TLS_KEY = "coherence.grpc.channels.%s.tls.key";
    public static final String PROP_TLS_KEYPASS = "coherence.grpc.channels.%s.tls.password";
    public static final String PROP_TLS_CERT = "coherence.grpc.channels.%s.tls.cert";
    public static final String PROP_TLS_CA = "coherence.grpc.channels.%s.tls.ca";
    public static final String PROP_TLS_AUTHORITY = "coherence.grpc.channels.%s.tls.authority";
    public static final String PROP_CREDENTIALS = "coherence.grpc.channels.%s.credentials";
    public static final String CREDENTIALS_INSECURE = "insecure";
    public static final String CREDENTIALS_TLS = "tls";
    public static final String CREDENTIALS_PLAINTEXT = "plaintext";
    public static final String PROP_TARGET = "coherence.grpc.channels.%s.target";

    public static Builder builder(Channel channel) {
        return new Builder(channel, null, null);
    }

    public static Builder builder() {
        return new Builder(null, "default", null);
    }

    public static Builder builder(String sChannelName) {
        return new Builder(null, sChannelName, null);
    }

    public static Builder builder(String channelName, String sFallbackName) {
        return new Builder(null, channelName, sFallbackName);
    }

    default public String getScopeName() {
        return "";
    }

    public Channel getChannel();

    default public Optional<Serializer> getSerializer() {
        return Optional.empty();
    }

    default public Optional<String> getFormat() {
        return this.getSerializer().map(Serializer::getName);
    }

    default public boolean enableTracing() {
        return false;
    }

    public static class DefaultConfiguration
    implements GrpcSessionConfiguration {
        private final String f_sName;
        private final String f_sScopeName;
        private final Channel f_channel;
        private final int f_nPriority;
        private final Serializer f_serializer;
        private final String f_sFormat;
        private final boolean f_fTracing;

        private DefaultConfiguration(String sName, String sScope, int nPriority, Channel channel, Serializer serializer, String sFormat, boolean fTracing) {
            this.f_sName = sName;
            this.f_sScopeName = sScope;
            this.f_nPriority = nPriority;
            this.f_channel = channel;
            this.f_serializer = serializer;
            this.f_sFormat = sFormat;
            this.f_fTracing = fTracing;
        }

        @Override
        public Channel getChannel() {
            return this.f_channel;
        }

        @Override
        public Optional<Serializer> getSerializer() {
            return Optional.ofNullable(this.f_serializer);
        }

        @Override
        public Optional<String> getFormat() {
            return Optional.ofNullable(this.f_sFormat);
        }

        @Override
        public boolean enableTracing() {
            return this.f_fTracing;
        }

        public String getName() {
            return this.f_sName;
        }

        @Override
        public String getScopeName() {
            return this.f_sScopeName;
        }

        public int getPriority() {
            return this.f_nPriority;
        }
    }

    public static class Builder {
        private final Channel f_channel;
        private final String f_sChannelName;
        private final String f_sFallbackChannelName;
        private String m_sName;
        private int m_nPriority = -1;
        private Serializer m_serializer;
        private String m_sFormat;
        private String m_sScope;
        private boolean m_fTracing = TracingHelper.isEnabled();

        private Builder(Channel channel, String sChannelName, String sFallbackName) {
            this.f_channel = channel;
            this.f_sChannelName = sChannelName;
            this.f_sFallbackChannelName = sFallbackName;
        }

        public Builder named(String sName) {
            this.m_sName = sName;
            return this;
        }

        public Builder withPriority(int nPriority) {
            this.m_nPriority = nPriority;
            return this;
        }

        public Builder withScopeName(String sScopeName) {
            this.m_sScope = sScopeName;
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            String sFormat = serializer == null ? null : serializer.getName();
            return this.withSerializer(serializer, sFormat);
        }

        public Builder withSerializer(Serializer serializer, String sFormat) {
            this.m_serializer = serializer;
            this.m_sFormat = sFormat;
            return this;
        }

        public Builder withSerializerFormat(String sFormat) {
            this.m_serializer = null;
            this.m_sFormat = sFormat;
            return this;
        }

        public Builder withTracing(boolean fEnabled) {
            this.m_fTracing = fEnabled;
            return this;
        }

        public GrpcSessionConfiguration build() {
            Channel channel;
            String sName;
            String string = sName = this.m_sName == null || this.m_sName.trim().isEmpty() ? "" : this.m_sName;
            if (this.f_channel == null) {
                if (this.f_sChannelName == null && this.f_sFallbackChannelName == null) {
                    Logger.config((String)("Session configuration for gRPC session " + sName + " has no channel or channel name set, falling back to the default configuration."));
                    channel = this.createChannel("default", GrpcSessionConfiguration.DEFAULT_HOST);
                } else {
                    channel = this.createChannel(this.f_sChannelName, null);
                    Logger.config((String)("Session configuration for gRPC session " + sName + " cannot find configuration properties for name " + this.f_sChannelName + ", falling back to channel name " + this.f_sFallbackChannelName));
                    if (channel == null && this.f_sFallbackChannelName != null) {
                        channel = this.createChannel(this.f_sFallbackChannelName, null);
                    }
                }
            } else {
                channel = this.f_channel;
            }
            if (channel == null) {
                throw new IllegalStateException("Could not configure a channel for this session configuration,channelName=" + this.f_sChannelName + " fallbackName=" + this.f_sFallbackChannelName);
            }
            String sScope = this.m_sScope == null || this.m_sScope.trim().isEmpty() ? "" : this.m_sScope;
            return new DefaultConfiguration(sName, sScope, this.m_nPriority, channel, this.m_serializer, this.m_sFormat, this.m_fTracing);
        }

        private Channel createChannel(String sName, String sDefaultHost) {
            ManagedChannelBuilder builder;
            Optional<Channel> optional = this.findChannel(sName);
            if (optional.isPresent()) {
                return optional.get();
            }
            ChannelCredentials credentials = this.createCredentials(sName);
            String target = this.getProperty(GrpcSessionConfiguration.PROP_TARGET, sName);
            if (target == null || target.trim().isEmpty()) {
                if ("default".equals(sName) && sDefaultHost == null) {
                    sDefaultHost = GrpcSessionConfiguration.DEFAULT_HOST;
                }
                String sHost = this.getProperty(GrpcSessionConfiguration.PROP_HOST, sName, sDefaultHost);
                int nPort = Config.getInteger((String)String.format(GrpcSessionConfiguration.PROP_PORT, sName), (int)1408);
                if (sHost == null) {
                    return null;
                }
                builder = Grpc.newChannelBuilderForAddress((String)sHost, (int)nPort, (ChannelCredentials)credentials);
                String sAuthority = this.getProperty(GrpcSessionConfiguration.PROP_TLS_AUTHORITY, sName);
                if (sAuthority != null) {
                    builder.overrideAuthority(sAuthority);
                }
            } else {
                builder = Grpc.newChannelBuilder((String)target, (ChannelCredentials)credentials);
            }
            return builder.build();
        }

        private Optional<Channel> findChannel(String ... asName) {
            int n = 0;
            String[] stringArray = asName;
            int n2 = stringArray.length;
            if (n < n2) {
                String sName = stringArray[n];
                return ChannelProviders.INSTANCE.findChannel(sName);
            }
            return Optional.empty();
        }

        private String getProperty(String sProperty, String sChannelName) {
            return Config.getProperty((String)String.format(sProperty, sChannelName));
        }

        private String getProperty(String sProperty, String sChannelName, String sDefault) {
            return Config.getProperty((String)String.format(sProperty, sChannelName), (String)sDefault);
        }

        ChannelCredentials createCredentials(String sChannelName) {
            ChannelCredentials credentials;
            String sType = this.getProperty(GrpcSessionConfiguration.PROP_CREDENTIALS, sChannelName, GrpcSessionConfiguration.CREDENTIALS_PLAINTEXT);
            if (GrpcSessionConfiguration.CREDENTIALS_PLAINTEXT.equals(sType)) {
                credentials = InsecureChannelCredentials.create();
            } else if (GrpcSessionConfiguration.CREDENTIALS_INSECURE.equals(sType)) {
                try {
                    SslContext sslContext = GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                    credentials = NettySslContextChannelCredentials.create((SslContext)sslContext);
                }
                catch (SSLException e) {
                    throw Exceptions.ensureRuntimeException((Throwable)e);
                }
            } else if (GrpcSessionConfiguration.CREDENTIALS_TLS.equals(sType)) {
                try {
                    SslContextBuilder builder = SslContextBuilder.forClient();
                    String sTlsCert = this.getProperty(GrpcSessionConfiguration.PROP_TLS_CERT, sChannelName);
                    String sTlsKey = this.getProperty(GrpcSessionConfiguration.PROP_TLS_KEY, sChannelName);
                    String sTlsPass = this.getProperty(GrpcSessionConfiguration.PROP_TLS_KEYPASS, sChannelName);
                    String sTlsCA = this.getProperty(GrpcSessionConfiguration.PROP_TLS_CA, sChannelName);
                    URL urlCert = null;
                    URL urlKey = null;
                    URL urlCA = null;
                    if (sTlsKey != null && sTlsCert == null || sTlsKey == null && sTlsCert != null) {
                        String sReason = "Invalid gRPC configuration for channel \"" + sChannelName + "\", " + (sTlsKey == null ? "no key file specified" : "no cert file specified");
                        throw new ConfigurationException(sReason, "When configuring gRPC TLS both the key and cert files must be configured key=\"" + sTlsKey + "\" cert=\"" + sTlsCert + "\"");
                    }
                    if (sTlsKey != null && sTlsCert != null) {
                        urlCert = Resources.findFileOrResource((String)sTlsCert, null);
                        if (urlCert == null) {
                            throw new ConfigurationException("Cannot find configured TLS cert for channel \"" + sChannelName + "\": " + sTlsCert, "Ensure the TLS cert exists");
                        }
                        urlKey = Resources.findFileOrResource((String)sTlsKey, null);
                        if (urlKey == null) {
                            throw new ConfigurationException("Cannot find configured TLS key for channel \"" + sChannelName + "\": " + sTlsCert, "Ensure the TLS key exists");
                        }
                        builder.keyManager(urlCert.openStream(), urlKey.openStream(), sTlsPass);
                    }
                    if (sTlsCA != null) {
                        urlCA = Resources.findFileOrResource((String)sTlsCA, null);
                        if (urlCA == null) {
                            throw new ConfigurationException("Cannot find configured TLS CA: for channel \"" + sChannelName + "\": " + sTlsCA, "Ensure the TLS CA exists");
                        }
                        builder.trustManager(urlCA.openStream());
                    }
                    builder = GrpcSslContexts.configure((SslContextBuilder)builder);
                    Logger.info((String)("Creating gRPC Channel \"" + sChannelName + "\" using TLS credentials. key=" + urlKey + " cert=" + urlCert + " ca=" + urlCA));
                    credentials = NettySslContextChannelCredentials.create((SslContext)builder.build());
                }
                catch (IOException e) {
                    throw Exceptions.ensureRuntimeException((Throwable)e);
                }
            } else {
                throw new ConfigurationException("Invalid credentials type for channel " + sChannelName, "Valid values are insecure tls plaintext");
            }
            return credentials;
        }
    }
}

