/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.client;

import com.oracle.coherence.cdi.CdiMapListener;
import com.oracle.coherence.cdi.CoherenceExtension;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.grpc.client.RemoteSessions;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;

public class CoherenceClientExtension
implements Extension {
    private static final CompletableFuture<Void> s_futureStarted = new CompletableFuture();

    synchronized void initMapEventObservers(@Observes @Initialized(value=ApplicationScoped.class) Object event, BeanManager beanManager, CoherenceExtension extension) {
        this.checkStart().thenRun(() -> {
            Instance instance = beanManager.createInstance();
            HashMap<String, Map> sessions = new HashMap<String, Map>();
            Set listeners = extension.getRemoteMapListeners();
            for (CdiMapListener listener : listeners) {
                String sSession = listener.getRemoteSessionName();
                String sScope = listener.getScopeName();
                Map map = sessions.computeIfAbsent(sScope, k -> new HashMap());
                Session session = map.computeIfAbsent(sSession, k -> (Session)instance.select(Session.class, new Annotation[]{Remote.Literal.of((String)sSession), Scope.Literal.of((String)sScope)}).get());
                session.getCache(listener.getCacheName(), new NamedMap.Option[0]);
            }
        });
    }

    protected void shutdown(@Observes @Priority(value=1) BeforeShutdown event) {
        RemoteSessions.instance().shutdown();
    }

    private CompletableFuture<Void> checkStart() {
        try {
            Class.forName("io.helidon.microprofile.grpc.server.spi.GrpcMpExtension");
        }
        catch (ClassNotFoundException e) {
            CoherenceClientExtension.setStarted();
        }
        return s_futureStarted;
    }

    static void setStarted() {
        s_futureStarted.complete(null);
    }
}

