/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.messages.common.v1.ErrorMessage;
import com.tangosol.io.Serializer;
import com.tangosol.net.RequestIncompleteException;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.function.BiFunction;

public final class ErrorsHelper {
    public static final Metadata.Key<String> KEY_ERROR = Metadata.Key.of((String)"coherence-error-stack", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Base64.Encoder s_encoder = Base64.getEncoder();
    private static final Base64.Decoder s_decoder = Base64.getDecoder();
    private static final int MAX_STACK_LENGTH = 1000;

    private ErrorsHelper() {
    }

    public static StatusRuntimeException ensureStatusRuntimeException(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            return ErrorsHelper.enrich((StatusRuntimeException)t);
        }
        if (t instanceof StatusException) {
            return ((StatusException)t).getStatus().asRuntimeException(ErrorsHelper.getErrorMetadata(t));
        }
        return Status.INTERNAL.withCause(t).withDescription(t.getMessage()).asRuntimeException(ErrorsHelper.getErrorMetadata(t));
    }

    public static StatusRuntimeException ensureStatusRuntimeException(Throwable t, String description) {
        Status status = t instanceof StatusRuntimeException ? ((StatusRuntimeException)t).getStatus().getCode().toStatus() : (t instanceof StatusException ? ((StatusException)t).getStatus().getCode().toStatus() : Status.INTERNAL);
        return status.withCause(t).withDescription(description).asRuntimeException(ErrorsHelper.getErrorMetadata(t));
    }

    public static Optional<String> getRemoteStack(StatusRuntimeException e) {
        Metadata trailers = e.getTrailers();
        String s = trailers == null ? null : (String)trailers.get(KEY_ERROR);
        return s == null ? Optional.empty() : Optional.of(new String(s_decoder.decode(s)));
    }

    public static Optional<String> getRemoteStack(StatusException e) {
        Metadata trailers = e.getTrailers();
        String s = trailers == null ? null : (String)trailers.get(KEY_ERROR);
        return s == null ? Optional.empty() : Optional.of(new String(s_decoder.decode(s)));
    }

    public static RequestIncompleteException createException(ErrorMessage error, Serializer serializer) {
        return ErrorsHelper.createException(error, serializer, RequestIncompleteException::new);
    }

    public static <E extends Exception> E createException(ErrorMessage error, Serializer serializer, BiFunction<String, Throwable, E> factory) {
        if (error == null) {
            return null;
        }
        Throwable cause = null;
        if (error.hasError()) {
            cause = (Throwable)BinaryHelper.fromByteString(error.getError(), serializer);
        }
        return (E)((Exception)factory.apply(error.getMessage(), cause));
    }

    public static ErrorMessage createErrorMessage(Throwable error, Serializer serializer) {
        String sMsg = error.getMessage();
        if (sMsg == null || sMsg.isEmpty()) {
            sMsg = error.getClass().getSimpleName();
        }
        ErrorMessage.Builder builder = ErrorMessage.newBuilder().setMessage(sMsg);
        if (serializer != null) {
            try {
                Throwable cause;
                if (error instanceof StatusRuntimeException && (cause = error.getCause()) != null) {
                    error = cause;
                }
                if (error instanceof StatusException && (cause = error.getCause()) != null) {
                    error = cause;
                }
                builder.setError(BinaryHelper.toByteString(error, serializer));
            }
            catch (Throwable t) {
                Logger.err((Throwable)t);
            }
        }
        return builder.build();
    }

    private static StatusRuntimeException enrich(StatusRuntimeException e) {
        Metadata metadata = e.getTrailers();
        if (metadata == null) {
            metadata = new Metadata();
            e = e.getStatus().asRuntimeException(metadata);
        }
        metadata.put(KEY_ERROR, (Object)ErrorsHelper.getStackTrace((Throwable)e));
        return e;
    }

    private static Metadata getErrorMetadata(Throwable t) {
        Metadata metadata = new Metadata();
        metadata.put(KEY_ERROR, (Object)ErrorsHelper.getStackTrace(t));
        return metadata;
    }

    private static String getStackTrace(Throwable t) {
        byte[] abEncoded;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8));
        byte[] abStack = out.toByteArray();
        if (abStack.length > 1000) {
            byte[] abTruncated = new byte[1000];
            System.arraycopy(abStack, 0, abTruncated, 0, 1000);
            abEncoded = s_encoder.encode(abTruncated);
        } else {
            abEncoded = s_encoder.encode(abStack);
        }
        return new String(abEncoded);
    }

    public static void logIfNotCancelled(Throwable t) {
        if (ErrorsHelper.rootCause(t) instanceof SocketException) {
            Logger.err((String)t.getMessage());
        } else {
            boolean fLog = true;
            Status.Code code = null;
            if (t instanceof StatusRuntimeException) {
                StatusRuntimeException sre = (StatusRuntimeException)t;
                code = sre.getStatus().getCode();
            } else if (t instanceof StatusException) {
                StatusException se = (StatusException)t;
                code = se.getStatus().getCode();
            }
            if (code == Status.Code.UNAVAILABLE) {
                fLog = !t.getMessage().contains("Channel shutdownNow invoked");
            } else {
                boolean bl = fLog = code != null && code != Status.Code.CANCELLED && code != Status.Code.UNIMPLEMENTED;
            }
            if (fLog) {
                Logger.err((Throwable)t);
            }
        }
    }

    private static Throwable rootCause(Throwable t) {
        Throwable rootCause = t;
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            rootCause = cause;
        }
        return rootCause;
    }
}

