/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperBufferInput;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ReadableBuffer;
import io.grpc.internal.ReadableBuffers;
import io.helidon.grpc.core.MarshallerSupplier;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.inject.Named;

public class SerializerMarshaller<T>
implements MethodDescriptor.Marshaller<T> {
    private final Serializer f_serializer;
    private final Class<? extends T> f_clazz;

    protected SerializerMarshaller(Serializer serializer, Class<? extends T> clazz) {
        this.f_serializer = serializer;
        this.f_clazz = clazz;
    }

    public InputStream stream(T value) {
        try {
            ByteArrayWriteBuffer bufOut = new ByteArrayWriteBuffer(512);
            this.f_serializer.serialize(bufOut.getBufferOutput(), value);
            ReadableBuffer bufIn = ReadableBuffers.wrap((byte[])bufOut.getRawByteArray(), (int)0, (int)bufOut.length());
            return ReadableBuffers.openStream((ReadableBuffer)bufIn, (boolean)true);
        }
        catch (Throwable t) {
            Logger.err((String)"Unexpected error during gRPC marshalling", (Throwable)t);
            throw Status.INTERNAL.withCause(t).asRuntimeException();
        }
    }

    public T parse(InputStream stream) {
        try {
            return (T)this.f_serializer.deserialize((ReadBuffer.BufferInput)new WrapperBufferInput((DataInput)new DataInputStream(stream)), this.f_clazz);
        }
        catch (Throwable t) {
            Logger.err((String)"Unexpected error during gRPC marshalling", (Throwable)t);
            throw Status.INTERNAL.withCause(t).asRuntimeException();
        }
    }

    @Named(value="ext-lite")
    public static class Supplier
    implements MarshallerSupplier {
        private final Serializer f_serializer = new DefaultSerializer(Classes.ensureClassLoader(null));

        public <T> MethodDescriptor.Marshaller<T> get(Class<T> clazz) {
            return new SerializerMarshaller<T>(this.f_serializer, clazz);
        }
    }
}

