/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.internal.GrpcTracingInterceptors;
import com.oracle.coherence.grpc.proxy.GrpcServerConfiguration;
import com.oracle.coherence.grpc.proxy.NettyCredentialsHelper;
import com.oracle.coherence.grpc.proxy.NettyNamedCacheService;
import com.oracle.coherence.grpc.proxy.common.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.common.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.common.GrpcMetricsInterceptor;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.oracle.coherence.grpc.proxy.common.NamedCacheService;
import com.oracle.coherence.grpc.proxy.common.NamedCacheServiceGrpcImpl;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.net.service.peer.acceptor.DefaultGrpcAcceptorDependencies;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcAcceptorController;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.protobuf.services.ChannelzService;
import io.grpc.protobuf.services.HealthStatusManager;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NettyGrpcAcceptorController
implements GrpcAcceptorController {
    private GrpcAcceptorDependencies m_dependencies;
    private volatile boolean m_fRunning;
    private Server m_server;
    private Server m_inProcessServer;
    private DaemonPool m_daemonPool;
    private HealthStatusManager m_healthStatusManager;
    private List<BindableGrpcProxyService> m_listServices;
    private final Lock f_lock = new ReentrantLock();

    public int getPriority() {
        return 0;
    }

    public void setDependencies(GrpcAcceptorDependencies deps) {
        this.m_dependencies = deps;
    }

    public GrpcAcceptorDependencies getDependencies() {
        GrpcAcceptorDependencies deps = this.m_dependencies;
        if (deps == null) {
            deps = this.m_dependencies = new DefaultGrpcAcceptorDependencies();
        }
        return deps;
    }

    public void setDaemonPool(DaemonPool pool) {
        this.m_daemonPool = pool;
    }

    public void start() {
        if (this.m_fRunning) {
            return;
        }
        this.f_lock.lock();
        try {
            if (this.m_fRunning) {
                return;
            }
            GrpcAcceptorDependencies deps = this.getDependencies();
            ServerBuilder<?> serverBuilder = this.createServerBuilder(deps);
            InProcessServerBuilder inProcessBuilder = this.createInProcessServerBuilder(deps);
            Context context = deps.getContext();
            GrpcServiceDependencies.DefaultDependencies serviceDeps = new GrpcServiceDependencies.DefaultDependencies();
            serviceDeps.setContext(context);
            if (this.m_daemonPool != null) {
                serviceDeps.setExecutor((Executor)new DaemonPoolExecutor(this.m_daemonPool));
            }
            this.m_listServices = NettyGrpcAcceptorController.createGrpcServices((GrpcServiceDependencies)serviceDeps);
            ArrayList<String> listServiceNames = new ArrayList<String>();
            for (BindableGrpcProxyService service : this.m_listServices) {
                GrpcMetricsInterceptor interceptor = new GrpcMetricsInterceptor(service.getMetrics());
                ServerServiceDefinition definition = ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{interceptor});
                serverBuilder.addService(definition);
                inProcessBuilder.addService(definition);
                listServiceNames.add(definition.getServiceDescriptor().getName());
            }
            this.m_healthStatusManager = new HealthStatusManager();
            serverBuilder.addService(this.m_healthStatusManager.getHealthService());
            serverBuilder.addService((BindableService)ChannelzService.newInstance((int)deps.getChannelzPageSize()));
            this.configure(serverBuilder, inProcessBuilder);
            ServerInterceptor grpcTracingInterceptor = GrpcTracingInterceptors.getServerInterceptor();
            if (grpcTracingInterceptor != null) {
                serverBuilder.intercept(grpcTracingInterceptor);
            }
            Server server = serverBuilder.build();
            Server inProcessServer = inProcessBuilder.build();
            server.start();
            inProcessServer.start();
            for (SocketAddress address : inProcessServer.getListenSockets()) {
                Logger.info(() -> "In-Process GrpcAcceptor is now listening for connections using name \"" + String.valueOf(address) + "\"");
            }
            this.m_server = server;
            this.m_inProcessServer = inProcessServer;
            this.m_healthStatusManager.setStatus("$GRPC:GrpcProxy", HealthCheckResponse.ServingStatus.SERVING);
            listServiceNames.forEach(s -> this.m_healthStatusManager.setStatus(s, HealthCheckResponse.ServingStatus.SERVING));
            this.m_fRunning = true;
        }
        catch (IOException e) {
            throw Exceptions.ensureRuntimeException((Throwable)e, (String)"Failed to start gRPC server");
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void stop() {
        if (this.m_fRunning) {
            this.f_lock.lock();
            try {
                if (this.m_fRunning) {
                    this.m_fRunning = false;
                    this.m_healthStatusManager.enterTerminalState();
                    this.m_healthStatusManager = null;
                    this.stopServer(this.m_inProcessServer, "in-process server");
                    this.m_inProcessServer = null;
                    this.stopServer(this.m_server, "server");
                    this.m_server = null;
                    this.m_listServices = null;
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
    }

    public boolean isRunning() {
        return this.m_fRunning;
    }

    public String getLocalAddress() {
        return this.m_dependencies.getLocalAddress();
    }

    public int getLocalPort() {
        Server server = this.m_server;
        if (server == null) {
            throw new IllegalStateException("The gRPC server is not started");
        }
        return server.getPort();
    }

    public String getInProcessName() {
        Server server = this.m_inProcessServer;
        if (server != null) {
            return server.getListenSockets().stream().filter(Objects::nonNull).map(String::valueOf).findAny().orElse(null);
        }
        return null;
    }

    public List<BindableGrpcProxyService> getBindableServices() {
        return this.m_listServices;
    }

    protected ServerBuilder<?> createServerBuilder(GrpcAcceptorDependencies deps) {
        ServerCredentials credentials = NettyCredentialsHelper.createServerCredentials(deps.getSocketProviderBuilder());
        return Grpc.newServerBuilderForPort((int)deps.getLocalPort(), (ServerCredentials)credentials);
    }

    protected InProcessServerBuilder createInProcessServerBuilder(GrpcAcceptorDependencies deps) {
        Context ctx = deps.getContext();
        ContainerContext ctxContainer = ctx == null ? null : ctx.getContainerContext();
        String sPrefix = ctx == null ? "" : ctx.getDefaultScope();
        String sScope = ServiceScheme.getScopePrefix((String)(sPrefix + "$GRPC"), (ContainerContext)ctxContainer);
        String sName = ServiceScheme.getScopedServiceName((String)sScope, (String)deps.getInProcessName());
        return InProcessServerBuilder.forName((String)sName);
    }

    public static List<BindableGrpcProxyService> createGrpcServices() {
        return NettyGrpcAcceptorController.createGrpcServices(null);
    }

    public static List<BindableGrpcProxyService> createGrpcServices(GrpcServiceDependencies depsService) {
        NamedCacheService.DefaultDependencies deps = new NamedCacheService.DefaultDependencies(depsService);
        NamedCacheServiceGrpcImpl cacheService = new NamedCacheServiceGrpcImpl((NamedCacheService)NettyNamedCacheService.newInstance((NamedCacheService.Dependencies)deps));
        return List.of(cacheService);
    }

    protected void configure(ServerBuilder<?> serverBuilder, InProcessServerBuilder inProcessServerBuilder) {
        for (GrpcServerConfiguration cfg : ServiceLoader.load(GrpcServerConfiguration.class)) {
            try {
                cfg.configure(serverBuilder, inProcessServerBuilder);
            }
            catch (Throwable t) {
                Logger.err((String)("Caught exception calling GrpcServerConfiguration " + String.valueOf(cfg)), (Throwable)t);
            }
        }
    }

    private void stopServer(Server server, String sName) {
        boolean fStopped = false;
        if (server == null) {
            return;
        }
        server.shutdown();
        Logger.finest((String)("Awaiting termination of Coherence gRPC proxy " + sName));
        try {
            fStopped = server.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!fStopped) {
            Logger.finest((String)("Forcing termination of Coherence gRPC proxy " + sName));
            server.shutdownNow();
        }
        Logger.fine((String)("Stopped Coherence gRPC proxy " + sName));
    }
}

