/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Logger;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;

public class ServerLoggingInterceptor
implements ServerInterceptor {
    public static final Metadata.Key<String> TRACE_ID_KEY = Metadata.Key.of((String)"traceId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        final String sId = (String)headers.get(TRACE_ID_KEY);
        MethodDescriptor descriptor = call.getMethodDescriptor();
        Logger.info(() -> String.format("In interceptCall loggingId=%s method=%s", sId, descriptor.getFullMethodName()));
        GrpcServerCall<ReqT, RespT> grpcServerCall = new GrpcServerCall<ReqT, RespT>(call, sId);
        ServerCall.Listener listener = next.startCall(grpcServerCall, headers);
        return new GrpcForwardingServerCallListener<ReqT>(descriptor, listener){

            public void onMessage(ReqT message) {
                Logger.info(() -> String.format("In onMessage: loggingId=%s method=%s, message=%s", sId, this.m_sMethodName, message));
                super.onMessage(message);
            }

            public void onHalfClose() {
                Logger.info(() -> String.format("In onHalfClose: loggingId=%s method=%s", sId, this.m_sMethodName));
                super.onHalfClose();
            }

            public void onCancel() {
                Logger.info(() -> String.format("In onCancel: loggingId=%s method=%s", sId, this.m_sMethodName));
                super.onCancel();
            }

            public void onComplete() {
                Logger.info(() -> String.format("In onComplete: loggingId=%s method=%s", sId, this.m_sMethodName));
                super.onComplete();
            }

            public void onReady() {
                Logger.info(() -> String.format("In onReady: loggingId=%s method=%s", sId, this.m_sMethodName));
                super.onReady();
            }
        };
    }

    private static class GrpcServerCall<ReqT, RespT>
    extends ServerCall<ReqT, RespT> {
        private final ServerCall<ReqT, RespT> m_serverCall;
        private final String m_sId;

        protected GrpcServerCall(ServerCall<ReqT, RespT> serverCall, String sId) {
            this.m_serverCall = serverCall;
            this.m_sId = sId;
        }

        public void request(int numMessages) {
            this.m_serverCall.request(numMessages);
        }

        public void sendHeaders(Metadata headers) {
            this.m_serverCall.sendHeaders(headers);
        }

        public void sendMessage(RespT message) {
            Logger.info(() -> String.format("In sendMessage: id=%s method=%s, response=%s", this.m_sId, this.m_serverCall.getMethodDescriptor().getFullMethodName(), message));
            this.m_serverCall.sendMessage(message);
        }

        public void close(Status status, Metadata trailers) {
            this.m_serverCall.close(status, trailers);
        }

        public boolean isCancelled() {
            return this.m_serverCall.isCancelled();
        }

        public MethodDescriptor<ReqT, RespT> getMethodDescriptor() {
            return this.m_serverCall.getMethodDescriptor();
        }
    }

    private static class GrpcForwardingServerCallListener<ReqT>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
        protected final String m_sMethodName;

        protected GrpcForwardingServerCallListener(MethodDescriptor<ReqT, ?> method, ServerCall.Listener<ReqT> listener) {
            super(listener);
            this.m_sMethodName = method.getFullMethodName();
        }
    }
}

