/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.net.management.Registry;
import java.util.Optional;
import java.util.concurrent.Executor;

public interface GrpcServiceDependencies {
    public Optional<NamedSerializerFactory> getNamedSerializerFactory();

    public Optional<Executor> getExecutor();

    public Optional<Long> getTransferThreshold();

    public Optional<Registry> getRegistry();

    public static class DefaultDependencies
    implements GrpcServiceDependencies {
        private NamedSerializerFactory m_serializerFactory;
        private Executor m_executor;
        private Long m_transferThreshold;
        private Registry m_registry;

        public DefaultDependencies() {
        }

        public DefaultDependencies(GrpcServiceDependencies deps) {
            if (deps != null) {
                this.m_executor = deps.getExecutor().orElse(null);
                this.m_registry = deps.getRegistry().orElse(null);
                this.m_serializerFactory = deps.getNamedSerializerFactory().orElse(null);
                this.m_transferThreshold = deps.getTransferThreshold().orElse(null);
            }
        }

        @Override
        public Optional<NamedSerializerFactory> getNamedSerializerFactory() {
            return Optional.ofNullable(this.m_serializerFactory);
        }

        public void setSerializerFactory(NamedSerializerFactory serializerFactory) {
            this.m_serializerFactory = serializerFactory;
        }

        @Override
        public Optional<Executor> getExecutor() {
            return Optional.ofNullable(this.m_executor);
        }

        public void setExecutor(Executor executor) {
            this.m_executor = executor;
        }

        @Override
        public Optional<Long> getTransferThreshold() {
            return Optional.ofNullable(this.m_transferThreshold);
        }

        public void setTransferThreshold(Long transferThreshold) {
            this.m_transferThreshold = transferThreshold;
        }

        @Override
        public Optional<Registry> getRegistry() {
            return Optional.ofNullable(this.m_registry);
        }

        public void setRegistry(Registry registry) {
            this.m_registry = registry;
        }
    }
}

