/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Classes;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Coherence;
import com.tangosol.net.ConfigurableCacheFactory;
import io.grpc.Status;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public interface ConfigurableCacheFactorySuppliers {
    public static final Function<String, ConfigurableCacheFactory> DEFAULT = new DefaultCacheFactorySupplier();

    public static Function<String, ConfigurableCacheFactory> fixed(ConfigurableCacheFactory ... ccfs) {
        return new FixedCacheFactorySupplier(ccfs);
    }

    public static class FixedCacheFactorySupplier
    implements Function<String, ConfigurableCacheFactory> {
        private final Map<String, ConfigurableCacheFactory> f_mapCCF;

        public FixedCacheFactorySupplier(ConfigurableCacheFactory ... ccfs) {
            HashMap<String, ConfigurableCacheFactory> map = new HashMap<String, ConfigurableCacheFactory>();
            for (ConfigurableCacheFactory ccf : ccfs) {
                map.put(ccf.getScopeName(), ccf);
            }
            this.f_mapCCF = map;
        }

        @Override
        public ConfigurableCacheFactory apply(String scope) {
            ConfigurableCacheFactory ccf;
            if (scope == null) {
                scope = "";
            }
            if ((ccf = this.f_mapCCF.get(scope)) != null) {
                return ccf;
            }
            if ("".equals(scope)) {
                return CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(Classes.getContextClassLoader());
            }
            throw Status.INVALID_ARGUMENT.withDescription("cannot locate ConfigurableCacheFactory with scope name " + scope).asRuntimeException();
        }
    }

    public static class DefaultCacheFactorySupplier
    implements Function<String, ConfigurableCacheFactory> {
        @Override
        public ConfigurableCacheFactory apply(String scope) {
            if (scope == null || "".equals(scope)) {
                return CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(Classes.getContextClassLoader());
            }
            ConfigurableCacheFactory[] aCCF = (ConfigurableCacheFactory[])Coherence.findSessionsByScope((String)scope).stream().filter(ConfigurableCacheFactorySession.class::isInstance).map(ConfigurableCacheFactorySession.class::cast).map(ConfigurableCacheFactorySession::getConfigurableCacheFactory).toArray(ConfigurableCacheFactory[]::new);
            if (aCCF.length == 1) {
                return aCCF[0];
            }
            if (aCCF.length > 1) {
                throw Status.INVALID_ARGUMENT.withDescription("Multiple ConfigurableCacheFactory instances have been configured with scope name " + scope).asRuntimeException();
            }
            String sURI = Config.getProperty((String)("coherence.cacheconfig." + scope));
            if (sURI != null && !sURI.isEmpty()) {
                return CacheFactory.getCacheFactoryBuilder().getConfigurableCacheFactory(sURI, Classes.getContextClassLoader());
            }
            throw Status.INVALID_ARGUMENT.withDescription("cannot locate ConfigurableCacheFactory with scope name " + scope).asRuntimeException();
        }
    }
}

