/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.proxy.BindableGrpcProxyService;
import com.oracle.coherence.grpc.proxy.DefaultGrpcAcceptorController;
import com.tangosol.application.Context;
import com.tangosol.application.LifecycleListener;
import com.tangosol.coherence.config.Config;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DefaultCacheServer;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.ProxyService;
import com.tangosol.net.grpc.GrpcAcceptorController;
import com.tangosol.util.ResourceRegistry;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class GrpcServerController {
    public static final GrpcServerController INSTANCE = new GrpcServerController();
    private ExtensibleConfigurableCacheFactory m_ccf;
    private DefaultCacheServer m_dcs;
    private boolean m_fEnabled = true;
    private CompletableFuture<Void> m_startFuture = new CompletableFuture();

    private GrpcServerController() {
    }

    public synchronized void start() {
        if (this.isRunning() || !this.m_fEnabled) {
            return;
        }
        try {
            ExtensibleConfigurableCacheFactory.Dependencies depsEccf = ExtensibleConfigurableCacheFactory.DependenciesHelper.newInstance((String)"grpc-proxy-cache-config.xml");
            this.m_ccf = new ExtensibleConfigurableCacheFactory(depsEccf);
            this.m_dcs = new DefaultCacheServer((ConfigurableCacheFactory)this.m_ccf);
            this.m_dcs.startDaemon(5000L);
            this.markStarted();
        }
        catch (Throwable e) {
            if (!this.m_startFuture.isDone()) {
                this.m_startFuture.completeExceptionally(e);
            }
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            if (this.m_dcs != null) {
                this.m_dcs.stop();
                this.m_ccf = null;
                this.m_dcs = null;
            }
            this.m_startFuture = new CompletableFuture();
        }
    }

    public void markStarted() {
        if (!this.m_startFuture.isDone()) {
            this.m_startFuture.complete(null);
        }
    }

    public CompletionStage<Void> whenStarted() {
        return this.m_startFuture;
    }

    public boolean isRunning() {
        return this.m_dcs != null && this.m_dcs.isMonitoringServices();
    }

    public int getPort() {
        if (this.isRunning()) {
            ProxyService proxyService = (ProxyService)this.m_ccf.ensureService("GrpcProxy");
            ResourceRegistry registry = proxyService.getResourceRegistry();
            GrpcAcceptorController controller = (GrpcAcceptorController)registry.getResource(GrpcAcceptorController.class);
            return controller.getLocalPort();
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    public String getInProcessName() {
        if (this.isRunning()) {
            ProxyService proxyService = (ProxyService)this.m_ccf.ensureService("GrpcProxy");
            ResourceRegistry registry = proxyService.getResourceRegistry();
            GrpcAcceptorController controller = (GrpcAcceptorController)registry.getResource(GrpcAcceptorController.class);
            return controller.getLocalAddress();
        }
        throw new IllegalStateException("The gRPC server is not running");
    }

    @Deprecated(since="22.06.2")
    public List<BindableGrpcProxyService> createGrpcServices() {
        return DefaultGrpcAcceptorController.createGrpcServices();
    }

    public void setEnabled(boolean fEnabled) {
        this.m_fEnabled = fEnabled;
    }

    public static class Listener
    implements LifecycleListener {
        private boolean m_fOwningInstance;

        public void preStart(Context ctx) {
            if (!this.m_fOwningInstance) {
                this.m_fOwningInstance = true;
            }
        }

        public void postStart(Context ctx) {
            if (this.m_fOwningInstance && Config.getBoolean((String)"coherence.grpc.enabled", (boolean)true)) {
                INSTANCE.start();
            }
        }

        public void preStop(Context ctx) {
            if (this.m_fOwningInstance && ctx.getConfigurableCacheFactory() != GrpcServerController.INSTANCE.m_ccf) {
                INSTANCE.stop();
                this.m_fOwningInstance = false;
            }
        }

        public void postStop(Context ctx) {
        }
    }
}

