/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.internal.GrpcTracingInterceptors;
import com.oracle.coherence.grpc.proxy.GrpcServerConfiguration;
import com.oracle.coherence.grpc.proxy.NettyCredentialsHelper;
import com.oracle.coherence.grpc.proxy.common.BaseGrpcAcceptorController;
import com.oracle.coherence.grpc.proxy.common.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcDependencies;
import io.grpc.BindableService;
import io.grpc.Grpc;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NettyGrpcAcceptorController
extends BaseGrpcAcceptorController {
    private Server m_server;
    private Server m_inProcessServer;
    private DaemonPool m_daemonPool;
    private final Lock f_lock = new ReentrantLock();

    public int getPriority() {
        return 0;
    }

    public void setDaemonPool(DaemonPool pool) {
        this.m_daemonPool = pool;
    }

    protected GrpcServiceDependencies createServiceDeps(GrpcServiceDependencies defaultDeps) {
        GrpcAcceptorDependencies deps = this.getDependencies();
        Context context = deps.getContext();
        GrpcServiceDependencies.DefaultDependencies serviceDeps = new GrpcServiceDependencies.DefaultDependencies(GrpcDependencies.ServerType.Asynchronous, defaultDeps);
        serviceDeps.setContext(context);
        if (this.m_daemonPool != null) {
            serviceDeps.setExecutor((Executor)new DaemonPoolExecutor(this.m_daemonPool));
            serviceDeps.setDaemonPool(this.m_daemonPool);
        }
        return serviceDeps;
    }

    protected void startInternal(List<ServerServiceDefinition> listServices, List<BindableService> listBindable) throws IOException {
        GrpcAcceptorDependencies deps = this.getDependencies();
        ServerBuilder<?> serverBuilder = this.createServerBuilder(deps);
        InProcessServerBuilder inProcessBuilder = this.createInProcessServerBuilder(deps);
        for (ServerServiceDefinition definition : listServices) {
            serverBuilder.addService(definition);
            inProcessBuilder.addService(definition);
        }
        listBindable.forEach(arg_0 -> serverBuilder.addService(arg_0));
        this.configure(serverBuilder, inProcessBuilder);
        ServerInterceptor grpcTracingInterceptor = GrpcTracingInterceptors.getServerInterceptor();
        if (grpcTracingInterceptor != null) {
            serverBuilder.intercept(grpcTracingInterceptor);
        }
        Server server = serverBuilder.build();
        Server inProcessServer = inProcessBuilder.build();
        server.start();
        inProcessServer.start();
        for (SocketAddress address : inProcessServer.getListenSockets()) {
            Logger.info(() -> "In-Process GrpcAcceptor is now listening for connections using name \"" + String.valueOf(address) + "\"");
        }
        this.m_server = server;
        this.m_inProcessServer = inProcessServer;
    }

    protected void stopInternal() {
        this.stopServer(this.m_inProcessServer, "in-process server");
        this.m_inProcessServer = null;
        this.stopServer(this.m_server, "server");
        this.m_server = null;
    }

    public int getLocalPort() {
        Server server = this.m_server;
        if (server == null) {
            throw new IllegalStateException("The gRPC server is not started");
        }
        return server.getPort();
    }

    public String getInProcessName() {
        Server server = this.m_inProcessServer;
        if (server != null) {
            return server.getListenSockets().stream().filter(Objects::nonNull).map(String::valueOf).findAny().orElse(null);
        }
        return null;
    }

    public GrpcDependencies.ServerType getServerType() {
        return GrpcDependencies.ServerType.Asynchronous;
    }

    protected ServerBuilder<?> createServerBuilder(GrpcAcceptorDependencies deps) {
        ServerCredentials credentials = NettyCredentialsHelper.createServerCredentials(deps.getSocketProviderBuilder());
        return Grpc.newServerBuilderForPort((int)deps.getLocalPort(), (ServerCredentials)credentials);
    }

    protected InProcessServerBuilder createInProcessServerBuilder(GrpcAcceptorDependencies deps) {
        Context ctx = deps.getContext();
        ContainerContext ctxContainer = ctx == null ? null : ctx.getContainerContext();
        String sPrefix = ctx == null ? "" : ctx.getDefaultScope();
        String sScope = ServiceScheme.getScopePrefix((String)(sPrefix + "$GRPC"), (ContainerContext)ctxContainer);
        String sName = ServiceScheme.getScopedServiceName((String)sScope, (String)deps.getInProcessName());
        return InProcessServerBuilder.forName((String)sName);
    }

    protected void configure(ServerBuilder<?> serverBuilder, InProcessServerBuilder inProcessServerBuilder) {
        for (GrpcServerConfiguration cfg : ServiceLoader.load(GrpcServerConfiguration.class)) {
            try {
                cfg.configure(serverBuilder, inProcessServerBuilder);
            }
            catch (Throwable t) {
                Logger.err((String)("Caught exception calling GrpcServerConfiguration " + String.valueOf(cfg)), (Throwable)t);
            }
        }
    }

    private void stopServer(Server server, String sName) {
        if (server == null) {
            return;
        }
        server.shutdownNow();
        Logger.fine((String)("Stopped Coherence gRPC proxy " + sName));
    }
}

