/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.helidon;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.proxy.common.BaseGrpcAcceptorController;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.oracle.coherence.grpc.proxy.helidon.HelidonCredentialsHelper;
import com.tangosol.application.Context;
import com.tangosol.internal.net.service.peer.acceptor.GrpcAcceptorDependencies;
import com.tangosol.internal.util.DaemonPool;
import com.tangosol.net.grpc.GrpcDependencies;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.helidon.common.Builder;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.grpc.GrpcRouting;
import java.io.IOException;
import java.util.List;

public class HelidonGrpcAcceptorController
extends BaseGrpcAcceptorController {
    private WebServer m_server;

    public int getPriority() {
        return 1;
    }

    public void setDaemonPool(DaemonPool pool) {
    }

    protected GrpcServiceDependencies createServiceDeps() {
        GrpcAcceptorDependencies deps = this.getDependencies();
        Context context = deps.getContext();
        GrpcServiceDependencies.DefaultDependencies serviceDeps = new GrpcServiceDependencies.DefaultDependencies(GrpcDependencies.ServerType.Synchronous);
        serviceDeps.setContext(context);
        serviceDeps.setExecutor(Runnable::run);
        return serviceDeps;
    }

    protected void startInternal(List<ServerServiceDefinition> listServices, List<BindableService> listBindable) throws IOException {
        GrpcAcceptorDependencies dependencies = this.getDependencies();
        WebServerConfig.Builder serverBuilder = WebServerConfig.builder();
        GrpcRouting.Builder routingBuilder = GrpcRouting.builder();
        for (ServerServiceDefinition definition : listServices) {
            routingBuilder.service(definition).build();
        }
        listBindable.forEach(s -> routingBuilder.service(null, s));
        HelidonCredentialsHelper.createTlsConfig(dependencies.getSocketProviderBuilder()).ifPresent(arg_0 -> ((WebServerConfig.Builder)serverBuilder).tls(arg_0));
        this.m_server = ((WebServerConfig.Builder)((WebServerConfig.Builder)serverBuilder.port(dependencies.getLocalPort())).addRouting((Builder)routingBuilder)).build().start();
    }

    protected void stopInternal() {
        this.stopServer(this.m_server);
    }

    public int getLocalPort() {
        if (this.m_server == null || !this.m_server.isRunning()) {
            throw new IllegalStateException("The gRPC server is not started");
        }
        return this.m_server.port();
    }

    public String getInProcessName() {
        return null;
    }

    public GrpcDependencies.ServerType getServerType() {
        return GrpcDependencies.ServerType.Synchronous;
    }

    private void stopServer(WebServer server) {
        if (server == null) {
            return;
        }
        server.stop();
        Logger.fine((String)"Stopped Coherence gRPC proxy");
    }
}

