/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common.concurrent.queue;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Message;
import com.oracle.coherence.concurrent.Queues;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.GrpcService;
import com.oracle.coherence.grpc.NamedQueueProtocol;
import com.oracle.coherence.grpc.messages.common.v1.OptionalValue;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.EnsureQueueRequest;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.NamedQueueRequest;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.NamedQueueRequestType;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.NamedQueueResponse;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.NamedQueueResponseType;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.NamedQueueType;
import com.oracle.coherence.grpc.messages.concurrent.queue.v1.QueueOfferResult;
import com.oracle.coherence.grpc.messages.proxy.v1.InitRequest;
import com.oracle.coherence.grpc.proxy.common.BaseProxyProtocol;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.queue.BinaryNamedMapDeque;
import com.tangosol.internal.net.queue.BinaryNamedMapQueue;
import com.tangosol.internal.net.queue.ConverterNamedMapDeque;
import com.tangosol.internal.net.queue.ConverterNamedMapQueue;
import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.paged.BinaryPagedNamedQueue;
import com.tangosol.io.Serializer;
import com.tangosol.net.Coherence;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedDeque;
import com.tangosol.net.NamedMap;
import com.tangosol.net.NamedQueue;
import com.tangosol.net.Session;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.LongArray;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.SparseArray;
import com.tangosol.util.UUID;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NamedQueueProxyProtocol
extends BaseProxyProtocol<NamedQueueRequest, NamedQueueResponse>
implements NamedQueueProtocol<NamedQueueRequest, NamedQueueResponse> {
    private Session m_session;
    private boolean m_fConcurrentSession;
    protected final LongArray<NamedQueue<Binary>> m_aQueue = new SparseArray();
    protected final Map<String, Integer> m_mapQueue = new ConcurrentHashMap<String, Integer>();

    public Class<NamedQueueRequest> getRequestType() {
        return NamedQueueRequest.class;
    }

    public Class<NamedQueueResponse> getResponseType() {
        return NamedQueueResponse.class;
    }

    @Override
    protected void initInternal(GrpcService service, InitRequest request, int nVersion, UUID clientUUID) {
        String sScope = request.getScope();
        this.m_fConcurrentSession = "$SYS".equals(sScope);
        if (this.m_fConcurrentSession) {
            this.m_session = (Session)Coherence.findSession((String)Queues.SESSION_NAME).orElseThrow(() -> new IllegalStateException("Coherence Concurrent session not found"));
        } else {
            ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)service.getCCF(sScope);
            this.m_session = new ConfigurableCacheFactorySession((ConfigurableCacheFactory)eccf, eccf.getConfigClassLoader(), sScope);
        }
    }

    @Override
    public void close() {
        this.m_aQueue.clear();
        super.close();
    }

    @Override
    protected void onRequestInternal(NamedQueueRequest request, StreamObserver<NamedQueueResponse> observer) {
        NamedQueueRequestType requestType = request.getType();
        if (requestType == NamedQueueRequestType.EnsureQueue) {
            this.onEnsureQueue(this.unpack(request, EnsureQueueRequest.class), observer);
        } else {
            int queueId = request.getQueueId();
            if (queueId == 0) {
                throw new IllegalArgumentException("Missing queue id in request, has an EnsureQueue request been sent" + String.valueOf(requestType));
            }
            switch (requestType) {
                case Clear: {
                    this.onClear(queueId, observer);
                    break;
                }
                case Destroy: {
                    this.onDestroyQueue(queueId, observer);
                    break;
                }
                case IsEmpty: {
                    this.onIsEmpty(queueId, observer);
                    break;
                }
                case IsReady: {
                    this.onIsReady(queueId, observer);
                    break;
                }
                case OfferTail: {
                    this.onOfferTail(queueId, request, observer);
                    break;
                }
                case OfferHead: {
                    this.onOfferHead(queueId, request, observer);
                    break;
                }
                case PollHead: {
                    this.onPollHead(queueId, observer);
                    break;
                }
                case PeekHead: {
                    this.onPeekHead(queueId, observer);
                    break;
                }
                case PollTail: {
                    this.onPollTail(queueId, observer);
                    break;
                }
                case PeekTail: {
                    this.onPeekTail(queueId, observer);
                    break;
                }
                case Size: {
                    this.onSize(queueId, observer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized request: " + String.valueOf(requestType));
                }
            }
        }
    }

    @Override
    protected NamedQueueResponse response(int queueId, Any any) {
        return NamedQueueResponse.newBuilder().setQueueId(queueId).setType(NamedQueueResponseType.Message).setMessage(any).build();
    }

    @Override
    protected Any getMessage(NamedQueueRequest request) {
        return request.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnsureQueue(EnsureQueueRequest request, StreamObserver<NamedQueueResponse> observer) {
        f_lock.lock();
        try {
            int queueId;
            String sName = request.getQueue();
            NamedQueueType type = request.getType();
            if (this.m_mapQueue.containsKey(sName)) {
                queueId = this.m_mapQueue.get(sName);
                NamedQueue queue = (NamedQueue)this.m_aQueue.get((long)queueId);
                if (queue instanceof ConverterNamedMapQueue) {
                    queue = (NamedQueue)((ConverterNamedMapQueue)queue).getCollection();
                }
                switch (type) {
                    case Queue: {
                        break;
                    }
                    case Deque: {
                        if (queue instanceof BinaryNamedMapDeque) break;
                        throw new IllegalArgumentException("Ensure queue is being called for a previously ensured queue of a different type. name=\"" + sName + "\" requested type \"" + String.valueOf(type) + "\" actual type \"" + String.valueOf(queue.getClass()) + "\"");
                    }
                    case PagedQueue: {
                        if (queue instanceof BinaryPagedNamedQueue) break;
                        throw new IllegalArgumentException("Ensure queue is being called for a previously ensured queue of a different type. name=\"" + sName + "\" requested type \"" + String.valueOf(type) + "\" actual type \"" + String.valueOf(queue.getClass()) + "\"");
                    }
                    case UNRECOGNIZED: {
                        throw new IllegalArgumentException("Unrecognized queue type " + String.valueOf(type));
                    }
                }
            } else {
                while ((queueId = Base.getRandom().nextInt(Integer.MAX_VALUE)) == 0 || this.m_aQueue.get((long)queueId) != null || this.m_destroyedIds.contains(queueId)) {
                }
                Object queue = switch (type) {
                    case NamedQueueType.Queue -> {
                        if (this.m_fConcurrentSession) {
                            sName = Queues.cacheNameForQueue((String)sName);
                        }
                        yield new BinaryNamedMapQueue(sName, this.m_session);
                    }
                    case NamedQueueType.Deque -> {
                        if (this.m_fConcurrentSession) {
                            sName = Queues.cacheNameForDeque((String)sName);
                        }
                        yield new BinaryNamedMapDeque(sName, this.m_session);
                    }
                    case NamedQueueType.PagedQueue -> {
                        if (this.m_fConcurrentSession) {
                            sName = Queues.cacheNameForPagedQueue((String)sName);
                        }
                        yield new BinaryPagedNamedQueue(sName, this.m_session);
                    }
                    default -> throw new IllegalArgumentException("Unrecognized queue type " + String.valueOf(type));
                };
                NamedMap namedMap = queue.getNamedMap();
                namedMap.addMapListener((MapListener)new QueueCacheListener(queueId));
                Serializer serializerThis = this.m_proxy.getSerializer();
                Serializer serializerThat = queue.getNamedMap().getService().getSerializer();
                boolean fCompatible = ExternalizableHelper.isSerializerCompatible((Serializer)serializerThis, (Serializer)serializerThat);
                if (!fCompatible) {
                    Converter cFromThat = bin -> ExternalizableHelper.fromBinary((Binary)bin, (Serializer)serializerThat);
                    Converter cToThat = obj -> ExternalizableHelper.toBinary((Object)obj, (Serializer)serializerThat);
                    Converter cFromThis = bin -> ExternalizableHelper.fromBinary((Binary)bin, (Serializer)serializerThis);
                    Converter cToThis = obj -> ExternalizableHelper.toBinary((Object)obj, (Serializer)serializerThis);
                    Converter convUp = bin -> bin == null ? null : (Binary)cToThis.convert(cFromThat.convert(bin));
                    Converter convDown = bin -> bin == null ? null : (Binary)cToThat.convert(cFromThis.convert(bin));
                    queue = type == NamedQueueType.Deque ? new ConverterNamedMapDeque((NamedMapDeque)queue, convUp, convUp, convDown, convDown) : new ConverterNamedMapQueue((NamedMapQueue)queue, convUp, convUp, convDown, convDown);
                }
                this.m_mapQueue.put(request.getQueue(), queueId);
                this.m_aQueue.set((long)queueId, queue);
            }
            observer.onNext((Object)this.response(queueId).build());
            observer.onCompleted();
        }
        finally {
            f_lock.unlock();
        }
    }

    protected void onClear(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        queue.clear();
        observer.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDestroyQueue(int nId, StreamObserver<NamedQueueResponse> observer) {
        f_lock.lock();
        try {
            NamedQueue queue = (NamedQueue)this.m_aQueue.remove((long)nId);
            if (queue != null) {
                String sName = queue.getName();
                queue.destroy();
                this.m_mapQueue.remove(sName);
            }
            this.m_destroyedIds.add(nId);
        }
        finally {
            f_lock.unlock();
        }
        observer.onCompleted();
    }

    protected void onIsEmpty(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        this.complete(queue.isEmpty(), queueId, observer);
    }

    protected void onIsReady(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        this.complete(queue.isReady(), queueId, observer);
    }

    protected void onOfferTail(int queueId, NamedQueueRequest request, StreamObserver<NamedQueueResponse> observer) {
        Binary binary;
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        long id = queue.append((Object)(binary = this.unpackBinary(request)));
        boolean fSuccess = id != Long.MIN_VALUE;
        QueueOfferResult result = QueueOfferResult.newBuilder().setIndex(id).setSucceeded(fSuccess).build();
        this.complete((Message)result, queueId, observer);
    }

    protected void onOfferHead(int queueId, NamedQueueRequest request, StreamObserver<NamedQueueResponse> observer) {
        Binary binary;
        NamedDeque<Binary> queue = this.assertDeque(queueId);
        long id = queue.prepend((Object)(binary = this.unpackBinary(request)));
        boolean fSuccess = id != Long.MIN_VALUE;
        QueueOfferResult result = QueueOfferResult.newBuilder().setIndex(id).setSucceeded(fSuccess).build();
        this.complete((Message)result, queueId, observer);
    }

    protected void onPollHead(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        this.completePeekOrPoll((Binary)queue.poll(), queueId, observer);
    }

    protected void onPeekHead(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        this.completePeekOrPoll((Binary)queue.peek(), queueId, observer);
    }

    protected void onPollTail(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedDeque<Binary> deque = this.assertDeque(queueId);
        this.completePeekOrPoll((Binary)deque.pollLast(), queueId, observer);
    }

    protected void onPeekTail(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedDeque<Binary> deque = this.assertDeque(queueId);
        this.completePeekOrPoll((Binary)deque.peekLast(), queueId, observer);
    }

    protected void onSize(int queueId, StreamObserver<NamedQueueResponse> observer) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        this.complete(queue.size(), queueId, observer);
    }

    protected void completePeekOrPoll(Binary binResult, int queueId, StreamObserver<NamedQueueResponse> observer) {
        OptionalValue.Builder builder = OptionalValue.newBuilder();
        if (binResult == null) {
            builder.setPresent(false);
        } else {
            builder.setPresent(true);
            builder.setValue(BinaryHelper.toByteString((Binary)binResult));
        }
        observer.onNext((Object)this.response(queueId).setType(NamedQueueResponseType.Message).setMessage(Any.pack((Message)builder.build())).build());
        observer.onCompleted();
    }

    protected NamedQueue<Binary> assertQueue(int queueId) {
        if (this.m_destroyedIds.contains(queueId)) {
            throw new IllegalStateException("The queue with id " + queueId + " has been explicitly destroyed");
        }
        NamedQueue queue = (NamedQueue)this.m_aQueue.get((long)queueId);
        if (queue == null) {
            throw new IllegalStateException("No queue exist for id " + queueId);
        }
        return queue;
    }

    protected NamedDeque<Binary> assertDeque(int queueId) {
        NamedQueue<Binary> queue = this.assertQueue(queueId);
        if (queue instanceof NamedDeque) {
            return (NamedDeque)queue;
        }
        throw new IllegalStateException("The queue with id " + queueId + " is not a NamedDeque");
    }

    protected NamedQueueResponse.Builder response(int queueId) {
        return NamedQueueResponse.newBuilder().setQueueId(queueId);
    }

    protected Binary unpackBinary(NamedQueueRequest request) {
        BytesValue binaryValue = this.unpack(request, BytesValue.class);
        return BinaryHelper.toBinary((ByteString)binaryValue.getValue());
    }

    protected class QueueCacheListener
    implements NamedCacheDeactivationListener {
        private final int m_queueId;

        public QueueCacheListener(int queueId) {
            this.m_queueId = queueId;
        }

        public void entryInserted(MapEvent evt) {
        }

        public void entryUpdated(MapEvent evt) {
            this.send(NamedQueueResponseType.Truncated);
        }

        public void entryDeleted(MapEvent evt) {
            this.send(NamedQueueResponseType.Destroyed);
        }

        private void send(NamedQueueResponseType type) {
            NamedQueueResponse event = NamedQueueResponse.newBuilder().setQueueId(this.m_queueId).setType(type).build();
            NamedQueueProxyProtocol.this.m_eventObserver.onNext((Object)event);
        }
    }
}

