/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.google.protobuf.ByteString;
import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.CacheDestroyedResponse;
import com.oracle.coherence.grpc.CacheRequestHolder;
import com.oracle.coherence.grpc.CacheTruncatedResponse;
import com.oracle.coherence.grpc.MapEventResponse;
import com.oracle.coherence.grpc.MapListenerErrorResponse;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.MapListenerResponse;
import com.oracle.coherence.grpc.MapListenerSubscribedResponse;
import com.oracle.coherence.grpc.MapListenerUnsubscribedResponse;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.proxy.common.NamedCacheService;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.io.Serializer;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.CacheEvent;
import com.tangosol.util.AbstractMapListener;
import com.tangosol.util.Binary;
import com.tangosol.util.ConcurrentMap;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTrigger;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.filter.InKeySetFilter;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MapListenerProxy
implements StreamObserver<MapListenerRequest>,
MapListener<Object, Object> {
    public static final int LITE = 1;
    public static final int PRIMING = 2;
    protected volatile boolean m_fCompleted;
    protected final NamedCacheService f_service;
    protected final SafeStreamObserver<MapListenerResponse> f_observer;
    protected final ConcurrentMap<Filter<?>, FilterInfo> f_mapFilter;
    protected final ConcurrentMap<Object, Integer> f_mapKeys;
    protected final Set<Object> f_setKeys;
    protected final MapListener<Object, Object> f_listenerDeactivation;
    protected CacheRequestHolder<MapListenerRequest, Void> m_holder;
    protected volatile WrapperPrimingListener m_primingListener;
    private final Lock f_lock = new ReentrantLock();

    public MapListenerProxy(NamedCacheService service, StreamObserver<MapListenerResponse> observer) {
        this.f_service = service;
        this.f_observer = (SafeStreamObserver)SafeStreamObserver.ensureSafeObserver(observer);
        this.f_mapFilter = new SegmentedConcurrentMap();
        this.f_mapKeys = new SegmentedConcurrentMap();
        this.f_setKeys = new HashSet<Object>();
        this.f_listenerDeactivation = new DeactivationListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(MapListenerRequest request) {
        this.f_lock.lock();
        try {
            if (this.m_holder == null) {
                this.m_holder = this.f_service.createRequestHolder(request, request.getScope(), request.getCache(), request.getFormat());
                this.m_holder.getCache().addMapListener(this.f_listenerDeactivation);
            } else if (!this.m_holder.getCacheName().equals(request.getCache())) {
                throw new IllegalArgumentException("request for different cache name, original cache name is " + this.m_holder.getCacheName() + " requested cache name is " + request.getCache());
            }
            boolean subscribe = request.getSubscribe();
            ByteString triggerBytes = request.getTrigger();
            MapTrigger trigger = null;
            if (!triggerBytes.isEmpty()) {
                trigger = (MapTrigger)BinaryHelper.fromByteString((ByteString)triggerBytes, (Serializer)this.m_holder.getSerializer());
            }
            switch (request.getType()) {
                case KEY: {
                    this.onKeyRequest(request, trigger);
                    break;
                }
                case FILTER: {
                    this.onFilterRequest(request, (MapTrigger<Binary, Binary>)trigger);
                    break;
                }
                case INIT: {
                    subscribe = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognised request type");
                }
            }
            if (subscribe) {
                MapListenerSubscribedResponse subscribed = MapListenerSubscribedResponse.newBuilder().setUid(request.getUid()).build();
                this.f_observer.onNext((Object)MapListenerResponse.newBuilder().setSubscribed(subscribed).build());
            } else {
                MapListenerUnsubscribedResponse unsubscribed = MapListenerUnsubscribedResponse.newBuilder().setUid(request.getUid()).build();
                this.f_observer.onNext((Object)MapListenerResponse.newBuilder().setUnsubscribed(unsubscribed).build());
            }
        }
        catch (Throwable t) {
            Logger.err((Throwable)t);
            this.f_observer.onNext((Object)MapListenerResponse.newBuilder().setError(this.error(request.getUid(), t)).build());
        }
        finally {
            this.f_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        this.f_lock.lock();
        try {
            boolean fClientCancel;
            boolean bl = fClientCancel = throwable instanceof StatusRuntimeException && ((StatusRuntimeException)throwable).getStatus().getCode() == Status.Code.CANCELLED;
            if (!fClientCancel) {
                Logger.err((String)"Error received in MapListenerProxy onError");
                Logger.err((Throwable)throwable);
            }
            try {
                this.removeAllListeners();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        finally {
            this.f_lock.unlock();
        }
    }

    public void onCompleted() {
        if (!this.m_fCompleted) {
            this.f_lock.lock();
            try {
                if (!this.m_fCompleted) {
                    this.m_fCompleted = true;
                    this.removeAllListeners();
                    this.f_observer.onCompleted();
                    this.m_holder = null;
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
    }

    public void entryInserted(MapEvent<Object, Object> mapEvent) {
        this.onMapEvent(mapEvent);
    }

    public void entryUpdated(MapEvent<Object, Object> mapEvent) {
        this.onMapEvent(mapEvent);
    }

    public void entryDeleted(MapEvent<Object, Object> mapEvent) {
        this.onMapEvent(mapEvent);
    }

    public MapListener<Object, Object> getDeactivationListener() {
        return this.f_listenerDeactivation;
    }

    protected void onKeyRequest(MapListenerRequest request, MapTrigger<?, ?> trigger) {
        Object key = this.m_holder.deserializeRequest(request.getKey());
        if (trigger == null) {
            if (request.getSubscribe()) {
                this.addListener(key, request.getLite(), request.getPriming());
            } else {
                this.removeListener(key, request.getPriming(), true);
            }
        } else {
            NamedCache cache = this.m_holder.getNonPassThruCache();
            MapTriggerListener listener = new MapTriggerListener(trigger);
            if (request.getSubscribe()) {
                cache.addMapListener((MapListener)listener, key, request.getLite());
            } else {
                cache.removeMapListener((MapListener)listener, key);
            }
        }
    }

    protected void onFilterRequest(MapListenerRequest request, MapTrigger<Binary, Binary> trigger) {
        if (trigger == null) {
            Filter filter = this.f_service.ensureFilter(request.getFilter(), this.m_holder.getSerializer());
            if (request.getSubscribe()) {
                this.addListener(filter, request.getFilterId(), request.getLite(), request.getPriming());
            } else {
                this.removeListener(filter, request.getPriming());
            }
        } else {
            NamedCache cache = this.m_holder.getNonPassThruCache();
            Filter filter = this.f_service.getFilter(request.getFilter(), this.m_holder.getSerializer());
            MapTriggerListener listener = new MapTriggerListener(trigger);
            if (request.getSubscribe()) {
                cache.addMapListener((MapListener)listener, filter, request.getLite());
            } else {
                cache.removeMapListener((MapListener)listener, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(Filter<?> filter, long filterId, boolean lite, boolean priming) {
        if (filterId <= 0L) {
            throw new IllegalArgumentException("filter id must be a non-zero positive long value");
        }
        NamedCache cache = this.m_holder.getNonPassThruCache();
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = (InKeySetFilter)filter;
            if (filterKeys.isConverted()) {
                for (Object binaryKey : filterKeys.getKeys()) {
                    Object key = this.m_holder.deserialize((Binary)binaryKey);
                    this.addListener(key, lite, priming, false);
                }
            } else {
                for (Object key : filterKeys.getKeys()) {
                    this.addListener(key, lite, priming, false);
                }
            }
            filterKeys.markConverted();
            MapListenerSupport.PrimingListener<Object, Object> listener = priming ? this.ensurePrimingListener() : this;
            cache.addMapListener(listener, (Filter)filterKeys, lite);
        } else {
            if (priming) {
                throw new IllegalArgumentException("Priming listeners are only supported with InKeySetFilter");
            }
            this.f_mapFilter.lock(filter, -1L);
            try {
                this.f_mapFilter.put(filter, (Object)new FilterInfo(filterId, lite));
                MapListenerSupport.PrimingListener<Object, Object> listener = this;
                cache.addMapListener(listener, filter, lite);
            }
            finally {
                this.f_mapFilter.unlock(filter);
            }
        }
    }

    protected void addListener(Object key, boolean lite, boolean priming) {
        this.addListener(key, lite, priming, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addListener(Object key, boolean lite, boolean priming, boolean register) {
        NamedCache cache = this.m_holder.getNonPassThruCache();
        this.f_mapKeys.lock(key, -1L);
        try {
            int nFlags = lite ? 1 : 0;
            nFlags |= priming ? 2 : nFlags;
            if (this.f_mapKeys.containsKey(key)) {
                nFlags = (Integer)this.f_mapKeys.get(key);
                if ((nFlags & 2) == 2) {
                    register = false;
                }
                if (priming) {
                    register = false;
                    MapEventResponse eventResponse = MapEventResponse.newBuilder().setId(74).setKey(BinaryHelper.toByteString((Object)key, (Serializer)this.m_holder.getSerializer())).setSynthetic(true).setTransformationStateValue(MapEventResponse.TransformationState.TRANSFORMABLE.ordinal()).setPriming(true).setNewValue(BinaryHelper.toByteString((Object)cache.get(key), (Serializer)this.m_holder.getSerializer())).build();
                    this.f_observer.onNext((Object)MapListenerResponse.newBuilder().setEvent(eventResponse).build());
                    nFlags |= 2;
                }
                if (!lite) {
                    nFlags &= 0xFFFFFFFE;
                    register = true;
                }
            }
            this.f_mapKeys.put(key, (Object)nFlags);
            this.f_setKeys.add(key);
            if (register) {
                MapListenerSupport.PrimingListener<Object, Object> listener = priming ? this.ensurePrimingListener() : this;
                cache.addMapListener(listener, key, lite);
            }
        }
        finally {
            this.f_mapKeys.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Filter<Binary> filter, boolean priming) {
        NamedCache cache = this.m_holder.getNonPassThruCache();
        if (filter instanceof InKeySetFilter) {
            InKeySetFilter filterKeys = (InKeySetFilter)filter;
            if (filterKeys.isConverted()) {
                for (Object binaryKey : filterKeys.getKeys()) {
                    Object key = this.m_holder.deserialize((Binary)binaryKey);
                    this.removeListener(key, priming, false);
                }
            } else {
                for (Object key : filterKeys.getKeys()) {
                    this.removeListener(key, priming, false);
                }
            }
            filterKeys.ensureConverted((Converter)new KeyConverter(this.m_holder));
            filterKeys.markConverted();
            cache.removeMapListener(priming ? this.ensurePrimingListener() : this, (Filter)filterKeys);
        } else {
            if (priming) {
                throw new IllegalArgumentException("Priming listeners are only supported with InKeySetFilter");
            }
            this.f_mapFilter.lock(filter, -1L);
            try {
                if (this.f_mapFilter.remove(filter) != null) {
                    cache.removeMapListener((MapListener)this, filter);
                }
            }
            finally {
                this.f_mapFilter.unlock(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Object key, boolean priming, boolean unregister) {
        block5: {
            NamedCache cache = this.m_holder.getNonPassThruCache();
            this.f_mapKeys.lock(key, -1L);
            try {
                Integer nFlags = (Integer)this.f_mapKeys.remove(key);
                if (nFlags == null) break block5;
                priming &= (nFlags & 2) == 2;
                if (this.f_setKeys.remove(key)) {
                    if (unregister) {
                        cache.removeMapListener(priming ? this.ensurePrimingListener() : this, key);
                    }
                    break block5;
                }
                throw new IllegalStateException("attempt to remove key listener for unregistered key");
            }
            finally {
                this.f_mapKeys.unlock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners() {
        if (this.m_holder == null) {
            return;
        }
        if (!this.m_holder.getCache().isActive()) {
            return;
        }
        NamedCache cache = this.m_holder.getNonPassThruCache();
        cache.removeMapListener(this.f_listenerDeactivation);
        this.f_mapFilter.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            for (Filter filter : this.f_mapFilter.keySet()) {
                cache.removeMapListener((MapListener)this, filter);
            }
            this.f_mapFilter.clear();
        }
        finally {
            this.f_mapFilter.unlock(ConcurrentMap.LOCK_ALL);
        }
        this.f_mapKeys.lock(ConcurrentMap.LOCK_ALL, -1L);
        try {
            for (Object key : this.f_setKeys) {
                Integer nFlags = (Integer)this.f_mapKeys.remove(key);
                boolean fPriming = nFlags != null && (nFlags & 2) != 0;
                cache.removeMapListener(fPriming ? this.ensurePrimingListener() : this, key);
            }
            this.f_setKeys.clear();
        }
        finally {
            this.f_mapKeys.unlock(ConcurrentMap.LOCK_ALL);
        }
    }

    protected MapListenerSupport.PrimingListener<Object, Object> ensurePrimingListener() {
        if (this.m_primingListener == null) {
            this.f_lock.lock();
            try {
                if (this.m_primingListener == null) {
                    this.m_primingListener = new WrapperPrimingListener(this);
                }
            }
            finally {
                this.f_lock.unlock();
            }
        }
        return this.m_primingListener;
    }

    protected void onMapEvent(MapEvent<?, ?> event) {
        try {
            MapEventResponse eventResponse = this.createMapEventResponse(event);
            this.f_observer.onNext((Object)MapListenerResponse.newBuilder().setEvent(eventResponse).build());
        }
        catch (Throwable thrown) {
            Logger.err((String)"Error processing MapEvent");
            Logger.err((Throwable)thrown);
        }
    }

    protected MapEventResponse createMapEventResponse(MapEvent<?, ?> mapEvent) {
        boolean fSynthetic;
        int nEventId = mapEvent.getId();
        Object oKey = mapEvent.getKey();
        Integer nFlags = (Integer)this.f_mapKeys.get(oKey);
        boolean fKeyLite = nFlags == null || (nFlags & 1) != 0;
        boolean fPriming = nFlags != null && (nFlags & 2) != 0;
        boolean fFilterLite = true;
        Collection<Object> colFilterIds = Collections.emptyList();
        MapEvent unwrapped = MapListenerSupport.unwrapEvent(mapEvent);
        CacheEvent evtCache = unwrapped instanceof CacheEvent ? (CacheEvent)unwrapped : null;
        boolean bl = fSynthetic = evtCache != null && evtCache.isSynthetic();
        if (unwrapped instanceof MapListenerSupport.FilterEvent) {
            Filter[] filters = ((MapListenerSupport.FilterEvent)unwrapped).getFilter();
            colFilterIds = new ArrayList();
            for (Filter filter : filters) {
                FilterInfo filterInfo = (FilterInfo)this.f_mapFilter.get((Object)filter);
                if (filterInfo == null) continue;
                boolean fLite = filterInfo.isLite();
                colFilterIds.add(filterInfo.getId());
                if (fLite) continue;
                fFilterLite = false;
            }
        } else {
            FilterInfo filterInfo = (FilterInfo)this.f_mapFilter.get(null);
            if (filterInfo != null) {
                boolean fLite = filterInfo.isLite();
                colFilterIds = Collections.singleton(filterInfo.getId());
                fFilterLite = fLite;
            }
        }
        int transformationState = evtCache == null ? CacheEvent.TransformationState.TRANSFORMABLE.ordinal() : evtCache.getTransformationState().ordinal();
        Serializer serializer = this.m_holder.getSerializer();
        MapEventResponse.Builder builder = MapEventResponse.newBuilder().setId(nEventId).addAllFilterIds(colFilterIds).setKey(BinaryHelper.toByteString((Object)oKey, (Serializer)serializer)).setSynthetic(fSynthetic).setTransformationStateValue(transformationState).setPriming(evtCache != null && evtCache.isPriming());
        if (!fKeyLite || !fFilterLite || fPriming) {
            Object newValue = mapEvent.getNewValue();
            ByteString newBytes = newValue == null ? ByteString.EMPTY : BinaryHelper.toByteString((Object)newValue, (Serializer)serializer);
            builder.setNewValue(newBytes);
            if (!fPriming) {
                Object oldValue = mapEvent.getOldValue();
                ByteString oldBytes = oldValue == null ? ByteString.EMPTY : BinaryHelper.toByteString((Object)oldValue, (Serializer)serializer);
                builder.setOldValue(oldBytes);
            }
        }
        return builder.build();
    }

    protected MapListenerErrorResponse error(String uid, Throwable t) {
        MapListenerErrorResponse.Builder builder = MapListenerErrorResponse.newBuilder().setUid(uid).setMessage(String.valueOf(t.getMessage()));
        if (t instanceof StatusException) {
            builder.setCode(((StatusException)t).getStatus().getCode().value());
        } else if (t instanceof StatusRuntimeException) {
            builder.setCode(((StatusRuntimeException)t).getStatus().getCode().value());
        } else if (t instanceof IllegalArgumentException) {
            builder.setCode(Status.Code.INVALID_ARGUMENT.value());
        } else if (t instanceof IllegalStateException) {
            builder.setCode(Status.Code.FAILED_PRECONDITION.value());
        } else {
            builder.setCode(Status.Code.INTERNAL.value());
        }
        for (StackTraceElement element : t.getStackTrace()) {
            builder.addStack(element.toString());
        }
        return builder.build();
    }

    protected static class DeactivationListener
    extends AbstractMapListener
    implements NamedCacheDeactivationListener {
        protected final MapListenerProxy f_proxy;

        protected DeactivationListener(MapListenerProxy proxy) {
            this.f_proxy = proxy;
        }

        public void entryDeleted(MapEvent evt) {
            Object source = evt.getSource();
            if (source instanceof NamedCache) {
                String sCacheName = ((NamedCache)source).getCacheName();
                try {
                    CacheDestroyedResponse response = CacheDestroyedResponse.newBuilder().setCache(sCacheName).build();
                    this.f_proxy.f_observer.onNext((Object)MapListenerResponse.newBuilder().setDestroyed(response).build());
                    this.f_proxy.onCompleted();
                }
                catch (Throwable t) {
                    Logger.err((String)("Failed to send cache destroy response for cache " + sCacheName));
                    Logger.err((Throwable)t);
                }
            }
        }

        public void entryUpdated(MapEvent evt) {
            Object source = evt.getSource();
            if (source instanceof NamedCache) {
                CacheTruncatedResponse response = CacheTruncatedResponse.newBuilder().setCache(((NamedCache)source).getCacheName()).build();
                this.f_proxy.f_observer.onNext((Object)MapListenerResponse.newBuilder().setTruncated(response).build());
            }
        }
    }

    protected static class FilterInfo {
        protected final long f_lId;
        protected final boolean f_fLite;

        protected FilterInfo(long lId, boolean fLite) {
            this.f_lId = lId;
            this.f_fLite = fLite;
        }

        public long getId() {
            return this.f_lId;
        }

        public boolean isLite() {
            return this.f_fLite;
        }
    }

    protected static class KeyConverter
    implements Converter<Object, Binary> {
        protected final CacheRequestHolder<MapListenerRequest, Void> f_holder;
        protected final Converter<Object, Binary> f_converter;

        protected KeyConverter(CacheRequestHolder<MapListenerRequest, Void> holder) {
            this.f_holder = holder;
            this.f_converter = holder.getNonPassThruCache().getCacheService().getBackingMapManager().getContext().getKeyToInternalConverter();
        }

        public Binary convert(Object oKey) {
            Binary binKey = oKey instanceof Binary ? this.f_holder.convertKeyDown((Binary)oKey) : (oKey instanceof ByteString ? this.f_holder.convertKeyDown((ByteString)oKey) : (Binary)this.f_converter.convert(oKey));
            return binKey;
        }
    }

    public static class WrapperPrimingListener
    implements MapListenerSupport.PrimingListener<Object, Object> {
        protected final MapListener<Object, Object> f_listenerWrapped;

        public WrapperPrimingListener(MapListener<Object, Object> wrapped) {
            this.f_listenerWrapped = wrapped;
        }

        public void entryInserted(MapEvent<Object, Object> mapEvent) {
            this.f_listenerWrapped.entryInserted(mapEvent);
        }

        public void entryUpdated(MapEvent<Object, Object> mapEvent) {
            this.f_listenerWrapped.entryUpdated(mapEvent);
        }

        public void entryDeleted(MapEvent<Object, Object> mapEvent) {
            this.f_listenerWrapped.entryDeleted(mapEvent);
        }
    }
}

