/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Empty;
import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.AddIndexRequest;
import com.oracle.coherence.grpc.AggregateRequest;
import com.oracle.coherence.grpc.BinaryHelper;
import com.oracle.coherence.grpc.CacheRequestHolder;
import com.oracle.coherence.grpc.ClearRequest;
import com.oracle.coherence.grpc.DestroyRequest;
import com.oracle.coherence.grpc.ErrorsHelper;
import com.oracle.coherence.grpc.GetAllRequest;
import com.oracle.coherence.grpc.MapListenerRequest;
import com.oracle.coherence.grpc.MapListenerResponse;
import com.oracle.coherence.grpc.PutAllRequest;
import com.oracle.coherence.grpc.RemoveIndexRequest;
import com.oracle.coherence.grpc.SafeStreamObserver;
import com.oracle.coherence.grpc.proxy.common.BaseGrpcServiceImpl;
import com.oracle.coherence.grpc.proxy.common.MapListenerProxy;
import com.oracle.coherence.grpc.proxy.common.NamedCacheService;
import com.oracle.coherence.grpc.proxy.common.ResponseHandlers;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.util.collection.ConvertingNamedCache;
import com.tangosol.internal.util.processor.BinaryProcessors;
import com.tangosol.io.Serializer;
import com.tangosol.net.AsyncNamedCache;
import com.tangosol.net.CacheService;
import com.tangosol.net.Coherence;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.net.cache.NearCache;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.Filters;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ValueExtractor;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public abstract class BaseNamedCacheServiceImpl
extends BaseGrpcServiceImpl
implements NamedCacheService {
    public static final String MBEAN_NAME = "type=GrpcNamedCacheProxy";
    public static final String INVALID_REQUEST_MESSAGE = "invalid request, the request cannot be null";
    public static final String INVALID_CACHE_NAME_MESSAGE = "invalid request, cache name cannot be null or empty";
    public static final String MISSING_PROCESSOR_MESSAGE = "the request does not contain a serialized entry processor";
    public static final String MISSING_EXTRACTOR_MESSAGE = "the request does not contain a serialized ValueExtractor";
    public static final String MISSING_AGGREGATOR_MESSAGE = "the request does not contain a serialized ValueExtractor";

    public BaseNamedCacheServiceImpl(NamedCacheService.Dependencies dependencies) {
        super(dependencies, MBEAN_NAME, "GrpcNamedCacheProxy");
    }

    protected Empty addIndex(CacheRequestHolder<AddIndexRequest, Void> holder) {
        AddIndexRequest request = (AddIndexRequest)holder.getRequest();
        NamedCache cache = holder.getCache();
        Serializer serializer = holder.getSerializer();
        ValueExtractor<?, ?> extractor = this.ensureValueExtractor(request.getExtractor(), serializer);
        Comparator comparator = (Comparator)BinaryHelper.fromByteString((ByteString)request.getComparator(), (Serializer)serializer);
        cache.addIndex(extractor, request.getSorted(), comparator);
        return BinaryHelper.EMPTY;
    }

    protected CompletionStage<BytesValue> aggregateWithFilter(AggregateRequest request, Executor executor) {
        return this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> this.aggregateWithFilter((CacheRequestHolder<AggregateRequest, Void>)h, executor), executor).handleAsync(ResponseHandlers::handleError, executor);
    }

    protected CompletionStage<BytesValue> aggregateWithFilter(CacheRequestHolder<AggregateRequest, Void> holder, Executor executor) {
        AggregateRequest request = (AggregateRequest)holder.getRequest();
        ByteString filterBytes = request.getFilter();
        Filter filter = filterBytes.isEmpty() ? Filters.always() : (Filter)BinaryHelper.fromByteString((ByteString)filterBytes, (Serializer)holder.getSerializer());
        ByteString processorBytes = request.getAggregator();
        InvocableMap.EntryAggregator aggregator = (InvocableMap.EntryAggregator)BinaryHelper.fromByteString((ByteString)processorBytes, (Serializer)holder.getSerializer());
        return holder.runAsync((CompletionStage)holder.getAsyncCache().aggregate(filter, aggregator)).thenApplyAsync(h -> BinaryHelper.toBytesValue((Object)h.getResult(), (Serializer)h.getSerializer()), executor);
    }

    protected CompletionStage<BytesValue> aggregateWithKeys(AggregateRequest request, Executor executor) {
        return this.createHolderAsync(request, request.getScope(), request.getCache(), request.getFormat()).thenComposeAsync(h -> this.aggregateWithKeys((CacheRequestHolder<AggregateRequest, Void>)h, executor), executor).handleAsync(ResponseHandlers::handleError, executor);
    }

    protected CompletionStage<BytesValue> aggregateWithKeys(CacheRequestHolder<AggregateRequest, Void> holder, Executor executor) {
        AggregateRequest request = (AggregateRequest)holder.getRequest();
        List keys = request.getKeysList().stream().map(arg_0 -> holder.convertKeyDown(arg_0)).collect(Collectors.toList());
        InvocableMap.EntryAggregator aggregator = (InvocableMap.EntryAggregator)BinaryHelper.fromByteString((ByteString)request.getAggregator(), (Serializer)holder.getSerializer());
        return holder.runAsync((CompletionStage)holder.getAsyncCache().aggregate(keys, aggregator)).thenApplyAsync(h -> BinaryHelper.toBytesValue((Object)h.getResult(), (Serializer)h.getSerializer()), executor);
    }

    @Override
    public void clear(ClearRequest request, StreamObserver<Empty> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        try {
            NamedCache<Binary, Binary> cache = this.getPassThroughCache(request.getScope(), request.getCache());
            cache.clear();
            ResponseHandlers.handleUnary(Empty.getDefaultInstance(), null, safeObserver);
        }
        catch (Throwable t) {
            ResponseHandlers.handleUnary(Empty.getDefaultInstance(), t, safeObserver);
        }
    }

    @Override
    public void destroy(DestroyRequest request, StreamObserver<Empty> observer) {
        StreamObserver safeObserver = SafeStreamObserver.ensureSafeObserver(observer);
        try {
            String sCacheName = request.getCache();
            if (sCacheName == null || sCacheName.trim().isEmpty()) {
                throw Status.INVALID_ARGUMENT.withDescription(INVALID_CACHE_NAME_MESSAGE).asRuntimeException();
            }
            ConfigurableCacheFactory ccf = this.getCCF(request.getScope());
            NamedCache cachePassThru = ccf.ensureCache(sCacheName, NullImplementation.getClassLoader());
            NamedCache cache = ccf.ensureCache(sCacheName, Classes.getContextClassLoader());
            ccf.destroyCache(cachePassThru);
            try {
                ccf.destroyCache(cache);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResponseHandlers.handleUnary(Empty.getDefaultInstance(), null, safeObserver);
        }
        catch (Throwable t) {
            ResponseHandlers.handleUnary(Empty.getDefaultInstance(), t, safeObserver);
        }
    }

    @Override
    public StreamObserver<MapListenerRequest> events(StreamObserver<MapListenerResponse> observer) {
        return new MapListenerProxy(this, (StreamObserver<MapListenerResponse>)SafeStreamObserver.ensureSafeObserver(observer));
    }

    protected List<Binary> convertKeysToBinary(CacheRequestHolder<GetAllRequest, Void> holder) {
        GetAllRequest request = (GetAllRequest)holder.getRequest();
        return request.getKeyList().stream().map(arg_0 -> holder.convertKeyDown(arg_0)).collect(Collectors.toList());
    }

    protected CompletionStage<Empty> partitionedPutAll(CacheRequestHolder<PutAllRequest, Void> holder, Map<Binary, Binary> map) {
        try {
            HashMap<Member, Map> mapByOwner = new HashMap<Member, Map>();
            PartitionedService service = (PartitionedService)holder.getCache().getCacheService();
            for (Map.Entry<Binary, Binary> entry : map.entrySet()) {
                Binary key = entry.getKey();
                Member member = service.getKeyOwner((Object)key);
                Map mapForMember2 = mapByOwner.computeIfAbsent(member, m -> new HashMap());
                mapForMember2.put(key, entry.getValue());
            }
            AsyncNamedCache cache = holder.getAsyncCache();
            long cMillis = ((PutAllRequest)holder.getRequest()).getTtl();
            CompletableFuture[] futures = (CompletableFuture[])mapByOwner.values().stream().map(mapForMember -> this.plainPutAll((AsyncNamedCache<Binary, Binary>)cache, (Map<Binary, Binary>)mapForMember, cMillis)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(futures).thenApply(v -> BinaryHelper.EMPTY);
        }
        catch (Throwable t) {
            CompletableFuture<Empty> future = new CompletableFuture<Empty>();
            future.completeExceptionally(t);
            return future;
        }
    }

    protected CompletionStage<Empty> plainPutAll(AsyncNamedCache<Binary, Binary> cache, Map<Binary, Binary> map, long cMillis) {
        return cache.invokeAll(map.keySet(), BinaryProcessors.putAll(map, (long)cMillis)).thenApplyAsync(v -> BinaryHelper.EMPTY, this.f_executor);
    }

    protected Empty removeIndex(CacheRequestHolder<RemoveIndexRequest, Void> holder) {
        RemoveIndexRequest request = (RemoveIndexRequest)holder.getRequest();
        NamedCache cache = holder.getCache();
        ValueExtractor<?, ?> extractor = this.ensureValueExtractor(request.getExtractor(), holder.getSerializer());
        cache.removeIndex(extractor);
        return BinaryHelper.EMPTY;
    }

    protected <V> Empty empty(V ignored) {
        return BinaryHelper.EMPTY;
    }

    protected Empty execute(Runnable task) {
        task.run();
        return BinaryHelper.EMPTY;
    }

    protected <T> T execute(Callable<T> task) {
        try {
            return task.call();
        }
        catch (Throwable t) {
            throw ErrorsHelper.ensureStatusRuntimeException((Throwable)t);
        }
    }

    protected BoolValue toBoolValue(Binary binary, Serializer serializer) {
        return BoolValue.of((boolean)((Boolean)BinaryHelper.fromBinary((Binary)binary, (Serializer)serializer)));
    }

    public ValueExtractor<?, ?> ensureValueExtractor(ByteString bytes, Serializer serializer) {
        if (bytes == null || bytes.isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription("the request does not contain a serialized ValueExtractor").asRuntimeException();
        }
        return (ValueExtractor)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)serializer);
    }

    @Override
    public <T> Filter<T> ensureFilter(ByteString bytes, Serializer serializer) {
        if (bytes == null || bytes.isEmpty()) {
            return Filters.always();
        }
        return (Filter)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)serializer);
    }

    @Override
    public <T> Filter<T> getFilter(ByteString bytes, Serializer serializer) {
        if (bytes == null || bytes.isEmpty()) {
            return null;
        }
        return (Filter)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)serializer);
    }

    public <T> Comparator<T> deserializeComparator(ByteString bytes, Serializer serializer) {
        if (bytes == null || bytes.isEmpty()) {
            return null;
        }
        return (Comparator)BinaryHelper.fromByteString((ByteString)bytes, (Serializer)serializer);
    }

    protected CompletionStage<AsyncNamedCache<Binary, Binary>> getAsyncCache(String scope, String cacheName) {
        return CompletableFuture.supplyAsync(() -> this.getPassThroughCache(scope, cacheName).async(), this.f_executor);
    }

    protected NamedCache<Binary, Binary> getPassThroughCache(String scope, String cacheName) {
        return this.getCache(scope, cacheName, true);
    }

    protected ConfigurableCacheFactory getCCF(String sScope) {
        Object sScopeFinal;
        String sMTName;
        Context context;
        Optional<Context> optional = this.f_dependencies.getContext();
        ContainerContext containerContext = null;
        if (optional.isPresent()) {
            context = optional.get();
            String sAppName = context.getApplicationName();
            containerContext = context.getContainerContext();
            sMTName = ServiceScheme.getScopePrefix((String)sAppName, (ContainerContext)containerContext);
            sScopeFinal = sScope.isEmpty() || Objects.equals(sAppName, sScope) || Objects.equals(sMTName, sScope) ? sAppName : sAppName + sScope;
        } else {
            sScopeFinal = sScope;
            sMTName = null;
            context = null;
        }
        if (containerContext != null) {
            ClassLoader loader = context.getClassLoader();
            Coherence coherence = Coherence.getInstances((ClassLoader)loader).stream().filter(c -> c.getName().equals(sMTName)).filter(c -> Objects.equals(context, c.getConfiguration().getApplicationContext().orElse(null))).findFirst().orElse(null);
            if (coherence == null) {
                String sNames = Coherence.getInstances((ClassLoader)loader).stream().map(Coherence::getName).map(s -> "".equals(s) ? "<default>" : s).collect(Collectors.joining(","));
                throw new IllegalStateException("No Coherence instance exists with name " + sMTName + " scopeFinal=" + (String)sScopeFinal + " [" + sNames + "]");
            }
            String sScopes = coherence.getSessionScopeNames().stream().map(s -> "".equals(s) ? "<default>" : s).collect(Collectors.joining(","));
            return coherence.getSessionsWithScope((String)sScopeFinal).stream().findFirst().filter(s -> s instanceof ConfigurableCacheFactorySession).map(ConfigurableCacheFactorySession.class::cast).map(ConfigurableCacheFactorySession::getConfigurableCacheFactory).orElseThrow(() -> BaseNamedCacheServiceImpl.lambda$getCCF$15((String)sScopeFinal, sMTName, sScopes));
        }
        try {
            return (ConfigurableCacheFactory)this.f_cacheFactorySupplier.apply(sScopeFinal);
        }
        catch (Exception e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    protected NamedCache<Binary, Binary> getCache(String sScope, String sCacheName, boolean fPassThru) {
        if (sCacheName == null || sCacheName.trim().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription(INVALID_CACHE_NAME_MESSAGE).asRuntimeException();
        }
        Context context = this.f_dependencies.getContext().orElse(null);
        ContainerContext containerContext = context == null ? null : context.getContainerContext();
        ConfigurableCacheFactory ccf = this.getCCF(sScope);
        if (containerContext != null) {
            return (NamedCache)containerContext.runInDomainPartitionContext(this.createCallable(ccf, sCacheName, fPassThru));
        }
        try {
            return this.createCallable(ccf, sCacheName, fPassThru).call();
        }
        catch (Exception e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    private Callable<NamedCache<Binary, Binary>> createCallable(ConfigurableCacheFactory ccf, String sCacheName, boolean fPassThru) {
        return () -> {
            CacheService service;
            ClassLoader loader = fPassThru ? NullImplementation.getClassLoader() : Classes.getContextClassLoader();
            NamedCache cache = ccf.ensureCache(sCacheName, loader);
            boolean near = cache instanceof NearCache;
            if (near && (service = cache.getCacheService()) instanceof DistributedCacheService && ((DistributedCacheService)service).isLocalStorageEnabled()) {
                cache = ((NearCache)cache).getBackCache();
                near = false;
            }
            if (near) {
                return new ConvertingNamedCache(cache, NullImplementation.getConverter(), ExternalizableHelper.CONVERTER_STRIP_INTDECO, NullImplementation.getConverter(), NullImplementation.getConverter());
            }
            return cache;
        };
    }

    protected InvocableMap.EntryProcessor<Binary, Binary, Binary> castProcessor(InvocableMap.EntryProcessor<Binary, Binary, ?> ep) {
        return ep;
    }

    public <Req> CompletionStage<CacheRequestHolder<Req, Void>> createHolderAsync(Req request, String sScope, String sCacheName, String format) {
        return CompletableFuture.supplyAsync(() -> this.createRequestHolder(request, sScope, sCacheName, format), this.f_executor);
    }

    @Override
    public <Req> CacheRequestHolder<Req, Void> createRequestHolder(Req request, String sScope, String sCacheName, String format) {
        if (request == null) {
            throw Status.INVALID_ARGUMENT.withDescription(INVALID_REQUEST_MESSAGE).asRuntimeException();
        }
        if (sCacheName == null || sCacheName.isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription(INVALID_CACHE_NAME_MESSAGE).asRuntimeException();
        }
        NamedCache<Binary, Binary> c = this.getCache(sScope, sCacheName, true);
        NamedCache<Binary, Binary> nonPassThrough = this.getCache(sScope, sCacheName, false);
        AsyncNamedCache cache = c.async();
        CacheService cacheService = cache.getNamedCache().getCacheService();
        String cacheFormat = CacheRequestHolder.getCacheFormat((Service)cacheService);
        Serializer serializer = this.getSerializer(format, cacheFormat, () -> ((CacheService)cacheService).getSerializer(), () -> ((CacheService)cacheService).getContextClassLoader());
        return new CacheRequestHolder(request, cache, () -> nonPassThrough, format, serializer, this.f_executor);
    }

    private static /* synthetic */ IllegalStateException lambda$getCCF$15(String sScopeFinal, String sMTName, String sScopes) {
        return new IllegalStateException("cannot locate a session with scope " + sScopeFinal + " Coherence instance '" + sMTName + "' contains [" + sScopes + "]");
    }
}

