/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.SocketAddress;

public class ProxyServiceInterceptor
implements ServerInterceptor {
    private static final String KEY_NAME_REMOTE_ADDRESS = "com.oracle.coherence.remoteAddress";
    public static final Context.Key<SocketAddress> KEY_REMOTE_ADDRESS = Context.key((String)"com.oracle.coherence.remoteAddress");

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        SocketAddress address = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        Context context = Context.current().withValue(KEY_REMOTE_ADDRESS, (Object)address);
        return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
    }

    public static SocketAddress getRemoteAddress() {
        return (SocketAddress)KEY_REMOTE_ADDRESS.get();
    }
}

