/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy.common;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.grpc.GrpcService;
import com.oracle.coherence.grpc.proxy.common.ConfigurableCacheFactorySuppliers;
import com.oracle.coherence.grpc.proxy.common.DaemonPoolExecutor;
import com.oracle.coherence.grpc.proxy.common.GrpcProxyMetrics;
import com.oracle.coherence.grpc.proxy.common.GrpcServiceDependencies;
import com.tangosol.application.ContainerContext;
import com.tangosol.application.Context;
import com.tangosol.coherence.config.scheme.ServiceScheme;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.internal.util.collection.ConvertingNamedCache;
import com.tangosol.io.NamedSerializerFactory;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Coherence;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.NearCache;
import com.tangosol.net.grpc.GrpcDependencies;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.management.Registry;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import io.grpc.Status;
import java.io.Closeable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BaseGrpcServiceImpl
implements GrpcService {
    protected static final Void VOID = null;
    public static final long DEFAULT_TRANSFER_THRESHOLD = 524288L;
    public static final String INVALID_CACHE_NAME_MESSAGE = "invalid request, cache name cannot be null or empty";
    protected final Dependencies f_dependencies;
    protected final Function<String, ConfigurableCacheFactory> f_cacheFactorySupplier;
    protected final NamedSerializerFactory f_serializerProducer;
    protected final Executor f_executor;
    protected final GrpcProxyMetrics f_metrics;
    private final ScopedReferenceStore<Serializer> f_storeSerializer;
    protected long transferThreshold = 524288L;
    protected ConcurrentLinkedQueue<Closeable> f_listCloseable = new ConcurrentLinkedQueue();

    public BaseGrpcServiceImpl(Dependencies dependencies, String sMBeanName, String sPoolName) {
        this.f_dependencies = dependencies;
        this.f_executor = dependencies.getExecutor().orElseGet(() -> BaseGrpcServiceImpl.createDefaultExecutor(sPoolName));
        this.f_cacheFactorySupplier = dependencies.getCacheFactorySupplier().orElse(ConfigurableCacheFactorySuppliers.DEFAULT);
        this.f_serializerProducer = dependencies.getNamedSerializerFactory().orElse(NamedSerializerFactory.DEFAULT);
        this.f_storeSerializer = new ScopedReferenceStore(Serializer.class, s -> true, Serializer::getName, s -> null);
        dependencies.getTransferThreshold().ifPresent(this::setTransferThreshold);
        DaemonPoolExecutor.DaemonPoolManagement management = this.f_executor instanceof DaemonPoolExecutor ? ((DaemonPoolExecutor)this.f_executor).getManagement() : null;
        Registry registry = dependencies.getRegistry().orElseGet(() -> CacheFactory.getCluster().getManagement());
        this.f_metrics = new GrpcProxyMetrics(sMBeanName, management);
        this.f_metrics.registerMBean(registry);
    }

    public Dependencies getDependencies() {
        return this.f_dependencies;
    }

    public GrpcProxyMetrics getMetrics() {
        return this.f_metrics;
    }

    public Executor getExecutor() {
        return this.f_executor;
    }

    public long getTransferThreshold() {
        return this.transferThreshold;
    }

    void setTransferThreshold(long lSize) {
        this.transferThreshold = lSize;
    }

    public ConfigurableCacheFactory getCCF(String sScope) {
        Object sScopeFinal;
        String sMTName;
        Context context;
        Optional<Context> optional = this.f_dependencies.getContext();
        ContainerContext containerContext = null;
        if (optional.isPresent()) {
            context = optional.get();
            String sAppName = context.getApplicationName();
            containerContext = context.getContainerContext();
            sMTName = ServiceScheme.getScopePrefix((String)sAppName, (ContainerContext)containerContext);
            sScopeFinal = sScope.isEmpty() || Objects.equals(sAppName, sScope) || Objects.equals(sMTName, sScope) ? sAppName : sAppName + sScope;
        } else {
            sScopeFinal = sScope;
            sMTName = null;
            context = null;
        }
        if (containerContext != null) {
            ClassLoader loader = context.getClassLoader();
            Coherence coherence = Coherence.getInstances((ClassLoader)loader).stream().filter(c -> c.getName().equals(sMTName)).filter(c -> Objects.equals(context, c.getConfiguration().getApplicationContext().orElse(null))).findFirst().orElse(null);
            if (coherence == null) {
                String sNames = Coherence.getInstances((ClassLoader)loader).stream().map(Coherence::getName).map(s -> "".equals(s) ? "<default>" : s).collect(Collectors.joining(","));
                throw new IllegalStateException("No Coherence instance exists with name " + sMTName + " scopeFinal=" + (String)sScopeFinal + " [" + sNames + "]");
            }
            String sScopes = coherence.getSessionScopeNames().stream().map(s -> "".equals(s) ? "<default>" : s).collect(Collectors.joining(","));
            return coherence.getSessionsWithScope((String)sScopeFinal).stream().findFirst().filter(s -> s instanceof ConfigurableCacheFactorySession).map(ConfigurableCacheFactorySession.class::cast).map(ConfigurableCacheFactorySession::getConfigurableCacheFactory).orElseThrow(() -> BaseGrpcServiceImpl.lambda$getCCF$9((String)sScopeFinal, sMTName, sScopes));
        }
        try {
            return this.f_cacheFactorySupplier.apply((String)sScopeFinal);
        }
        catch (Exception e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    protected NamedCache<Binary, Binary> getPassThroughCache(String scope, String cacheName) {
        return this.getCache(scope, cacheName, true);
    }

    protected NamedCache<Binary, Binary> getCache(String sScope, String sCacheName, boolean fPassThru) {
        if (sCacheName == null || sCacheName.trim().isEmpty()) {
            throw Status.INVALID_ARGUMENT.withDescription(INVALID_CACHE_NAME_MESSAGE).asRuntimeException();
        }
        Context context = this.f_dependencies.getContext().orElse(null);
        ContainerContext containerContext = context == null ? null : context.getContainerContext();
        ConfigurableCacheFactory ccf = this.getCCF(sScope);
        if (containerContext != null) {
            return (NamedCache)containerContext.runInDomainPartitionContext(this.createCallable(ccf, sCacheName, fPassThru));
        }
        try {
            return this.createCallable(ccf, sCacheName, fPassThru).call();
        }
        catch (Exception e) {
            throw Exceptions.ensureRuntimeException((Throwable)e);
        }
    }

    private Callable<NamedCache<Binary, Binary>> createCallable(ConfigurableCacheFactory ccf, String sCacheName, boolean fPassThru) {
        return () -> {
            CacheService service;
            ClassLoader loader = fPassThru ? NullImplementation.getClassLoader() : Classes.getContextClassLoader();
            NamedCache cache = ccf.ensureCache(sCacheName, loader);
            boolean near = cache instanceof NearCache;
            if (near && (service = cache.getCacheService()) instanceof DistributedCacheService && ((DistributedCacheService)service).isLocalStorageEnabled()) {
                cache = ((NearCache)cache).getBackCache();
                near = false;
            }
            if (near) {
                return new ConvertingNamedCache(cache, NullImplementation.getConverter(), ExternalizableHelper.CONVERTER_STRIP_INTDECO, NullImplementation.getConverter(), NullImplementation.getConverter());
            }
            return cache;
        };
    }

    protected static Executor createDefaultExecutor(String sName) {
        DefaultDaemonPoolDependencies deps = new DefaultDaemonPoolDependencies();
        deps.setName(sName);
        deps.setThreadCountMin(1);
        deps.setThreadCount(1);
        deps.setThreadCountMax(Integer.MAX_VALUE);
        DaemonPoolExecutor executor = DaemonPoolExecutor.newInstance(deps);
        executor.start();
        return executor;
    }

    protected Serializer getSerializer(String sFormatRequest, String sFormatProxy, Supplier<Serializer> supplierSerializer, Supplier<ClassLoader> supplierLoader) {
        Serializer serializer;
        if (sFormatRequest == null || sFormatRequest.trim().isEmpty() || sFormatRequest.equals(sFormatProxy)) {
            serializer = supplierSerializer.get();
        } else {
            ClassLoader loader = supplierLoader.get();
            serializer = this.getSerializer(sFormatRequest, loader);
        }
        if (serializer == null) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid request format, cannot find serializer with name '" + sFormatRequest + "'").asRuntimeException();
        }
        return serializer;
    }

    public Serializer getSerializer(String sFormat, ClassLoader loader) {
        Serializer serializer = (Serializer)this.f_storeSerializer.get(sFormat, loader);
        if (serializer == null) {
            serializer = this.f_dependencies.getContext().map(c -> c.getNamedSerializer(sFormat)).orElse(null);
        }
        if (serializer == null) {
            serializer = this.f_serializerProducer.getNamedSerializer(sFormat, loader);
        }
        if (serializer != null) {
            this.f_storeSerializer.put((Object)serializer, loader);
        }
        if (serializer == null) {
            throw Status.INVALID_ARGUMENT.withDescription("invalid request format, cannot find serializer with name '" + sFormat + "'").asRuntimeException();
        }
        return serializer;
    }

    public void addCloseable(Closeable closeable) {
        this.f_listCloseable.add(closeable);
    }

    public void removeCloseable(Closeable closeable) {
        this.f_listCloseable.remove(closeable);
    }

    private static /* synthetic */ IllegalStateException lambda$getCCF$9(String sScopeFinal, String sMTName, String sScopes) {
        return new IllegalStateException("cannot locate a session with scope " + sScopeFinal + " Coherence instance '" + sMTName + "' contains [" + sScopes + "]");
    }

    public static interface Dependencies
    extends GrpcServiceDependencies {
        public Optional<Function<String, ConfigurableCacheFactory>> getCacheFactorySupplier();
    }

    public static class DefaultDependencies
    extends GrpcServiceDependencies.DefaultDependencies
    implements Dependencies {
        private Function<String, ConfigurableCacheFactory> m_ccfSupplier;

        public DefaultDependencies(GrpcDependencies.ServerType serverType) {
            super(serverType);
        }

        public DefaultDependencies(GrpcServiceDependencies deps) {
            super(deps);
        }

        public DefaultDependencies(Dependencies deps) {
            super(deps);
            this.m_ccfSupplier = deps.getCacheFactorySupplier().orElse(null);
        }

        @Override
        public Optional<Function<String, ConfigurableCacheFactory>> getCacheFactorySupplier() {
            return Optional.ofNullable(this.m_ccfSupplier);
        }

        public void setConfigurableCacheFactorySupplier(Function<String, ConfigurableCacheFactory> ccfSupplier) {
            this.m_ccfSupplier = ccfSupplier;
        }
    }
}

